/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableGriefingData;
import org.spongepowered.api.data.manipulator.mutable.entity.GriefingData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeGriefingData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.interfaces.entity.IMixinGriefer;

public class GriefingDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, Boolean, Value<Boolean>, GriefingData, ImmutableGriefingData> {
    public GriefingDataProcessor() {
        super(Entity.class, Keys.CAN_GRIEF);
    }

    @Override
    protected boolean supports(Entity dataHolder) {
        return dataHolder instanceof IMixinGriefer && ((IMixinGriefer)dataHolder).isGriefer();
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(Keys.CAN_GRIEF, true, actualValue);
    }

    @Override
    protected boolean set(Entity dataHolder, Boolean value) {
        ((IMixinGriefer)dataHolder).setCanGrief(value);
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(Entity dataHolder) {
        return Optional.of(((IMixinGriefer)dataHolder).canGrief());
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.CAN_GRIEF, true, value);
    }

    @Override
    protected GriefingData createManipulator() {
        return new SpongeGriefingData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

