/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public abstract class AbstractCatalogDataProcessor<T, V extends BaseValue<T>, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractItemSingleDataProcessor<T, V, M, I> {
    protected AbstractCatalogDataProcessor(Key<V> key, Predicate<ItemStack> predicate) {
        super(predicate, key);
    }

    protected abstract T getFromMeta(int var1);

    protected abstract int setToMeta(T var1);

    @Override
    protected boolean set(ItemStack itemStack, T value) {
        itemStack.func_77964_b(this.setToMeta(value));
        return true;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected Optional<T> getVal(ItemStack itemStack) {
        return Optional.of(this.getFromMeta(itemStack.func_77952_i()));
    }

    protected abstract T getDefaultValue();

    @Override
    protected ImmutableValue<T> constructImmutableValue(T value) {
        return ImmutableSpongeValue.cachedOf(this.key, this.getDefaultValue(), value);
    }
}

