/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.InvalidDataException;

public final class NbtTranslator
implements DataTranslator<NBTTagCompound> {
    private static final NbtTranslator instance = new NbtTranslator();
    private static final TypeToken<NBTTagCompound> TOKEN = TypeToken.of(NBTTagCompound.class);
    public static final String BOOLEAN_IDENTIFER = "$Boolean";

    public static NbtTranslator getInstance() {
        return instance;
    }

    private NbtTranslator() {
    }

    private static NBTTagCompound containerToCompound(DataView container) {
        Preconditions.checkNotNull((Object)container);
        NBTTagCompound compound = new NBTTagCompound();
        NbtTranslator.containerToCompound(container, compound);
        return compound;
    }

    private static void containerToCompound(DataView container, NBTTagCompound compound) {
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)compound);
        for (Map.Entry<DataQuery, Object> entry : container.getValues(false).entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey().asString('.');
            if (value instanceof DataView) {
                NBTTagCompound inner = new NBTTagCompound();
                NbtTranslator.containerToCompound(container.getView(entry.getKey()).get(), inner);
                compound.func_74782_a(key, (NBTBase)inner);
                continue;
            }
            if (value instanceof Boolean) {
                compound.func_74782_a(key + BOOLEAN_IDENTIFER, (NBTBase)new NBTTagByte((Boolean)value != false ? (byte)1 : 0));
                continue;
            }
            compound.func_74782_a(key, NbtTranslator.getBaseFromObject(value));
        }
    }

    private static NBTBase getBaseFromObject(Object value) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof Boolean) {
            return new NBTTagByte((Boolean)value != false ? (byte)1 : 0);
        }
        if (value instanceof Byte) {
            return new NBTTagByte(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new NBTTagShort(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new NBTTagInt(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new NBTTagLong(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new NBTTagFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new NBTTagDouble(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new NBTTagString((String)value);
        }
        if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                return new NBTTagByteArray((byte[])value);
            }
            if (value instanceof Byte[]) {
                byte[] array = new byte[((Byte[])value).length];
                int counter = 0;
                for (Byte data : (Byte[])value) {
                    array[counter++] = data;
                }
                return new NBTTagByteArray(array);
            }
            if (value instanceof int[]) {
                return new NBTTagIntArray((int[])value);
            }
            if (value instanceof Integer[]) {
                int[] array = new int[((Integer[])value).length];
                int counter = 0;
                for (Integer data : (Integer[])value) {
                    array[counter++] = data;
                }
                return new NBTTagIntArray(array);
            }
        } else {
            if (value instanceof List) {
                NBTTagList list = new NBTTagList();
                for (Object object : (List)value) {
                    list.func_74742_a(NbtTranslator.getBaseFromObject(object));
                }
                return list;
            }
            if (value instanceof Map) {
                NBTTagCompound compound = new NBTTagCompound();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    if (entry.getKey() instanceof DataQuery) {
                        if (entry.getValue() instanceof Boolean) {
                            compound.func_74757_a(((DataQuery)entry.getKey()).asString('.') + BOOLEAN_IDENTIFER, ((Boolean)entry.getValue()).booleanValue());
                            continue;
                        }
                        compound.func_74782_a(((DataQuery)entry.getKey()).asString('.'), NbtTranslator.getBaseFromObject(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey() instanceof String) {
                        compound.func_74782_a((String)entry.getKey(), NbtTranslator.getBaseFromObject(entry.getValue()));
                        continue;
                    }
                    compound.func_74782_a(entry.getKey().toString(), NbtTranslator.getBaseFromObject(entry.getValue()));
                }
                return compound;
            }
            if (value instanceof DataSerializable) {
                return NbtTranslator.containerToCompound(((DataSerializable)value).toContainer());
            }
            if (value instanceof DataView) {
                return NbtTranslator.containerToCompound((DataView)value);
            }
        }
        throw new IllegalArgumentException("Unable to translate object to NBTBase: " + value);
    }

    private static DataContainer getViewFromCompound(NBTTagCompound compound) {
        Preconditions.checkNotNull((Object)compound);
        DataContainer container = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
        NbtTranslator.getInstance().addTo(compound, (DataView)container);
        return container;
    }

    private static void setInternal(NBTBase base, byte type, DataView view, String key) {
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)view);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((type > 0 && type <= 11 ? 1 : 0) != 0);
        switch (type) {
            case 1: {
                if (key.contains(BOOLEAN_IDENTIFER)) {
                    view.set(DataQuery.of(key.replace(BOOLEAN_IDENTIFER, "")), (Object)(((NBTTagByte)base).func_150290_f() != 0 ? 1 : 0));
                    break;
                }
                view.set(DataQuery.of(key), (Object)((NBTTagByte)base).func_150290_f());
                break;
            }
            case 2: {
                view.set(DataQuery.of(key), (Object)((NBTTagShort)base).func_150289_e());
                break;
            }
            case 3: {
                view.set(DataQuery.of(key), (Object)((NBTTagInt)base).func_150287_d());
                break;
            }
            case 4: {
                view.set(DataQuery.of(key), (Object)((NBTTagLong)base).func_150291_c());
                break;
            }
            case 5: {
                view.set(DataQuery.of(key), Float.valueOf(((NBTTagFloat)base).func_150288_h()));
                break;
            }
            case 6: {
                view.set(DataQuery.of(key), (Object)((NBTTagDouble)base).func_150286_g());
                break;
            }
            case 7: {
                view.set(DataQuery.of(key), ((NBTTagByteArray)base).func_150292_c());
                break;
            }
            case 8: {
                view.set(DataQuery.of(key), ((NBTTagString)base).func_150285_a_());
                break;
            }
            case 9: {
                NBTTagList list = (NBTTagList)base;
                byte listType = (byte)list.func_150303_d();
                int count = list.func_74745_c();
                ArrayList objectList = Lists.newArrayListWithCapacity((int)count);
                for (int i = 0; i < count; ++i) {
                    objectList.add(NbtTranslator.fromTagBase(list.func_179238_g(i), listType));
                }
                view.set(DataQuery.of(key), objectList);
                break;
            }
            case 10: {
                DataView internalView = view.createView(DataQuery.of(key));
                NBTTagCompound compound = (NBTTagCompound)base;
                for (String internalKey : compound.func_150296_c()) {
                    NBTBase internalBase = compound.func_74781_a(internalKey);
                    byte internalType = internalBase.func_74732_a();
                    NbtTranslator.setInternal(internalBase, internalType, internalView, internalKey);
                }
                break;
            }
            case 11: {
                view.set(DataQuery.of(key), ((NBTTagIntArray)base).func_150302_c());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown NBT type " + type);
            }
        }
    }

    private static Object fromTagBase(NBTBase base, byte type) {
        switch (type) {
            case 1: {
                return ((NBTTagByte)base).func_150290_f();
            }
            case 2: {
                return ((NBTTagShort)base).func_150289_e();
            }
            case 3: {
                return ((NBTTagInt)base).func_150287_d();
            }
            case 4: {
                return ((NBTTagLong)base).func_150291_c();
            }
            case 5: {
                return Float.valueOf(((NBTTagFloat)base).func_150288_h());
            }
            case 6: {
                return ((NBTTagDouble)base).func_150286_g();
            }
            case 7: {
                return ((NBTTagByteArray)base).func_150292_c();
            }
            case 8: {
                return ((NBTTagString)base).func_150285_a_();
            }
            case 9: {
                NBTTagList list = (NBTTagList)base;
                byte listType = (byte)list.func_150303_d();
                int count = list.func_74745_c();
                ArrayList objectList = Lists.newArrayListWithCapacity((int)count);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    objectList.add(NbtTranslator.fromTagBase(list.func_179238_g(i), listType));
                }
                return objectList;
            }
            case 10: {
                return NbtTranslator.getViewFromCompound((NBTTagCompound)base);
            }
            case 11: {
                return ((NBTTagIntArray)base).func_150302_c();
            }
        }
        return null;
    }

    public NBTTagCompound translateData(DataView container) {
        return NbtTranslator.containerToCompound(container);
    }

    public void translateContainerToData(NBTTagCompound node, DataView container) {
        NbtTranslator.containerToCompound(container, node);
    }

    public DataContainer translateFrom(NBTTagCompound node) {
        return NbtTranslator.getViewFromCompound(node);
    }

    @Override
    public TypeToken<NBTTagCompound> getToken() {
        return TOKEN;
    }

    @Override
    public NBTTagCompound translate(DataView view) throws InvalidDataException {
        return NbtTranslator.containerToCompound(view);
    }

    @Override
    public DataContainer translate(NBTTagCompound obj) throws InvalidDataException {
        return NbtTranslator.getViewFromCompound(obj);
    }

    @Override
    public DataView addTo(NBTTagCompound compound, DataView container) {
        for (String key : compound.func_150296_c()) {
            NBTBase base = compound.func_74781_a(key);
            byte type = base.func_74732_a();
            NbtTranslator.setInternal(base, type, container, key);
        }
        return container;
    }

    @Override
    public String getId() {
        return "sponge:nbt";
    }

    @Override
    public String getName() {
        return "NbtTagCompoundTranslator";
    }
}

