/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.nbt;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.common.data.nbt.NbtDataType;
import org.spongepowered.common.data.nbt.data.NbtDataProcessor;

public class SpongeNbtProcessorDelegate<M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
implements NbtDataProcessor<M, I> {
    private final ImmutableList<NbtDataProcessor<M, I>> processors;
    private final NbtDataType nbtDataType;

    public SpongeNbtProcessorDelegate(ImmutableList<NbtDataProcessor<M, I>> processors, NbtDataType nbtDataType) {
        this.processors = processors;
        this.nbtDataType = nbtDataType;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public NbtDataType getTargetType() {
        return this.nbtDataType;
    }

    @Override
    public boolean isCompatible(NBTTagCompound compound) {
        for (NbtDataProcessor processor : this.processors) {
            if (!processor.isCompatible(compound)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<M> readFrom(NBTTagCompound compound) {
        for (NbtDataProcessor processor : this.processors) {
            Optional returnVal = processor.readFrom(compound);
            if (!returnVal.isPresent()) continue;
            return returnVal;
        }
        return Optional.empty();
    }

    @Override
    public Optional<M> readFrom(DataView view) {
        for (NbtDataProcessor processor : this.processors) {
            Optional returnVal = processor.readFrom(view);
            if (!returnVal.isPresent()) continue;
            return returnVal;
        }
        return Optional.empty();
    }

    @Override
    public Optional<NBTTagCompound> storeToCompound(NBTTagCompound compound, M manipulator) {
        for (NbtDataProcessor processor : this.processors) {
            Optional<NBTTagCompound> returnVal = processor.storeToCompound(compound, manipulator);
            if (!returnVal.isPresent()) continue;
            return returnVal;
        }
        return Optional.empty();
    }

    @Override
    public Optional<DataView> storeToView(DataView view, M manipulator) {
        for (NbtDataProcessor processor : this.processors) {
            Optional<DataView> returnVal = processor.storeToView(view, manipulator);
            if (!returnVal.isPresent()) continue;
            return returnVal;
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult remove(NBTTagCompound data) {
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult remove(DataView data) {
        return DataTransactionResult.failNoData();
    }
}

