/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableExperienceHolderData;
import org.spongepowered.api.data.manipulator.mutable.entity.ExperienceHolderData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeExperienceHolderData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.processor.common.ExperienceHolderUtils;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class SpongeExperienceHolderData
extends AbstractData<ExperienceHolderData, ImmutableExperienceHolderData>
implements ExperienceHolderData {
    private int level;
    private int totalExp;
    private int expSinceLevel;
    private int expBetweenLevels;

    public SpongeExperienceHolderData(int level, int totalExp, int expSinceLevel) {
        super(ExperienceHolderData.class);
        this.level = level;
        this.expBetweenLevels = ExperienceHolderUtils.getExpBetweenLevels(level);
        this.totalExp = totalExp;
        this.expSinceLevel = expSinceLevel;
        this.registerGettersAndSetters();
    }

    public SpongeExperienceHolderData() {
        this(0, 0, 0);
    }

    @Override
    public ExperienceHolderData copy() {
        return new SpongeExperienceHolderData(this.level, this.totalExp, this.expSinceLevel);
    }

    @Override
    public ImmutableExperienceHolderData asImmutable() {
        return new ImmutableSpongeExperienceHolderData(this.level, this.totalExp, this.expSinceLevel);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.EXPERIENCE_LEVEL.getQuery(), (Object)this.level).set(Keys.TOTAL_EXPERIENCE.getQuery(), (Object)this.totalExp).set(Keys.EXPERIENCE_SINCE_LEVEL.getQuery(), (Object)this.expSinceLevel);
    }

    @Override
    public MutableBoundedValue<Integer> level() {
        return SpongeValueFactory.boundedBuilder(Keys.EXPERIENCE_LEVEL).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).actualValue(this.level).build();
    }

    @Override
    public MutableBoundedValue<Integer> totalExperience() {
        return SpongeValueFactory.boundedBuilder(Keys.TOTAL_EXPERIENCE).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).actualValue(this.totalExp).build();
    }

    @Override
    public MutableBoundedValue<Integer> experienceSinceLevel() {
        return SpongeValueFactory.boundedBuilder(Keys.EXPERIENCE_SINCE_LEVEL).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue(this.expSinceLevel).build();
    }

    @Override
    public ImmutableBoundedValue<Integer> getExperienceBetweenLevels() {
        return SpongeValueFactory.boundedBuilder(Keys.EXPERIENCE_FROM_START_OF_LEVEL).defaultValue(0).actualValue(this.expBetweenLevels).minimum(0).maximum(Integer.MAX_VALUE).build().asImmutable();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.totalExp = ExperienceHolderUtils.xpAtLevel(level);
        this.expSinceLevel = 0;
        this.expBetweenLevels = ExperienceHolderUtils.getExpBetweenLevels(level);
    }

    public int getTotalExp() {
        return this.totalExp;
    }

    public void setTotalExp(int totalExp) {
        this.totalExp = totalExp;
        this.level = ExperienceHolderUtils.getLevelForExp(totalExp);
        this.expSinceLevel = totalExp - ExperienceHolderUtils.xpAtLevel(this.level);
        this.expBetweenLevels = ExperienceHolderUtils.getExpBetweenLevels(this.level);
    }

    public int getExpSinceLevel() {
        return this.expSinceLevel;
    }

    public void setExpSinceLevel(int expSinceLevel) {
        Preconditions.checkArgument((0 <= expSinceLevel && expSinceLevel <= this.expBetweenLevels ? 1 : 0) != 0, (Object)("expSinceLevel (" + expSinceLevel + ") must be between 0 and expBetweenLevels (" + this.expBetweenLevels + ")"));
        this.expSinceLevel = expSinceLevel;
    }

    public int getExpBetweenLevels() {
        return this.expBetweenLevels;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.EXPERIENCE_LEVEL, this::getLevel);
        this.registerFieldSetter(Keys.EXPERIENCE_LEVEL, this::setLevel);
        this.registerKeyValue(Keys.EXPERIENCE_LEVEL, this::level);
        this.registerFieldGetter(Keys.TOTAL_EXPERIENCE, this::getTotalExp);
        this.registerFieldSetter(Keys.TOTAL_EXPERIENCE, this::setTotalExp);
        this.registerKeyValue(Keys.TOTAL_EXPERIENCE, this::totalExperience);
        this.registerFieldGetter(Keys.EXPERIENCE_SINCE_LEVEL, this::getExpSinceLevel);
        this.registerFieldSetter(Keys.EXPERIENCE_SINCE_LEVEL, this::setExpSinceLevel);
        this.registerKeyValue(Keys.EXPERIENCE_SINCE_LEVEL, this::experienceSinceLevel);
        this.registerFieldGetter(Keys.EXPERIENCE_FROM_START_OF_LEVEL, this::getExpBetweenLevels);
        this.registerFieldSetter(Keys.EXPERIENCE_FROM_START_OF_LEVEL, value -> {});
        this.registerKeyValue(Keys.EXPERIENCE_FROM_START_OF_LEVEL, () -> this.getExperienceBetweenLevels().asMutable());
    }
}

