/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.data.datasync.DataParameterConverter;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.text.SpongeTexts;

public class EntityCustomNameConverter
extends DataParameterConverter<String> {
    public EntityCustomNameConverter() {
        super(Entity.field_184242_az);
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(String currentValue, String value) {
        Text currentText = SpongeTexts.fromLegacy(currentValue);
        Text newValue = SpongeTexts.fromLegacy(value);
        return Optional.of(DataTransactionResult.builder().replace(new ImmutableSpongeValue<Text>(Keys.DISPLAY_NAME, Text.of(), currentText)).success(new ImmutableSpongeValue<Text>(Keys.DISPLAY_NAME, Text.of(), newValue)).result(DataTransactionResult.Type.SUCCESS).build());
    }

    @Override
    public String getValueFromEvent(String originalValue, List<ImmutableValue<?>> immutableValues) {
        for (ImmutableValue<?> value : immutableValues) {
            if (value.getKey() != Keys.DISPLAY_NAME) continue;
            try {
                return SpongeTexts.toLegacy((Text)value.get());
            }
            catch (Exception e) {
                return originalValue;
            }
        }
        return originalValue;
    }
}

