/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import java.util.HashMap;
import java.util.Map;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.common.config.category.CollisionModCategory;
import org.spongepowered.common.config.category.ConfigCategory;

@ConfigSerializable
public class EntityCollisionCategory
extends ConfigCategory {
    @Setting(value="auto-populate", comment="If 'true', newly discovered entities/blocks will be added to this config with a default value.")
    private boolean autoPopulate = false;
    @Setting(value="max-entities-within-aabb", comment="Maximum amount of entities any given entity or block can collide with. This improves \nperformance when there are more than 8 entities on top of each other such as a 1x1 \nspawn pen. Set to 0 to disable.")
    private int maxEntitiesWithinAABB = 8;
    @Setting(value="defaults", comment="Default maximum collisions used for all entities/blocks unless overridden.")
    private Map<String, Integer> defaultMaxCollisions = new HashMap<String, Integer>();
    @Setting(value="mods", comment="Per-mod overrides. Refer to the minecraft default mod for example.")
    private Map<String, CollisionModCategory> modList = new HashMap<String, CollisionModCategory>();

    public EntityCollisionCategory() {
        this.defaultMaxCollisions.put("blocks", 8);
        this.defaultMaxCollisions.put("entities", 8);
        this.modList.put("minecraft", new CollisionModCategory("minecraft"));
        this.modList.put("botania", new CollisionModCategory("botania"));
    }

    public boolean autoPopulateData() {
        return this.autoPopulate;
    }

    public Map<String, CollisionModCategory> getModList() {
        return this.modList;
    }

    public Map<String, Integer> getDefaultMaxCollisions() {
        return this.defaultMaxCollisions;
    }

    public int getMaxEntitiesWithinAABB() {
        return this.maxEntitiesWithinAABB;
    }

    public void setMaxEntitiesWithinAABB(int maxEntities) {
        this.maxEntitiesWithinAABB = maxEntities;
    }
}

