/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import org.spongepowered.api.config.ConfigRoot;
import org.spongepowered.common.SpongeImpl;

public class SpongeConfigRoot
implements ConfigRoot {
    private final ObjectMapperFactory mapperFactory;
    private final String pluginName;
    private final Path baseDir;

    public SpongeConfigRoot(ObjectMapperFactory mapperFactory, String pluginName, Path baseDir) {
        this.mapperFactory = mapperFactory;
        this.pluginName = pluginName;
        this.baseDir = baseDir;
    }

    @Override
    public Path getConfigPath() {
        Path configFile = this.baseDir.resolve(this.pluginName + ".conf");
        try {
            Files.createDirectories(this.baseDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            SpongeImpl.getLogger().error("Failed to create plugin dir for {} at {}", (Object)this.pluginName, (Object)this.baseDir, (Object)e);
        }
        return configFile;
    }

    @Override
    public ConfigurationLoader<CommentedConfigurationNode> getConfig() {
        return ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.getConfigPath())).setDefaultOptions(ConfigurationOptions.defaults().setObjectMapperFactory(this.mapperFactory))).build();
    }

    @Override
    public Path getDirectory() {
        return this.baseDir;
    }
}

