/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import co.aikar.timings.SpongeTimingsFactory;
import co.aikar.timings.Timings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.util.StartsWithPredicate;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.BlockUtil;
import org.spongepowered.common.command.ChunkSaveHelper;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.MetricsCategory;
import org.spongepowered.common.config.type.ConfigBase;
import org.spongepowered.common.config.type.DimensionConfig;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.TrackerConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.IMixinMinecraftServer;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.IMixinDimensionType;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.util.SpongeCommonTranslationHelper;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.WorldManager;

public class SpongeCommandFactory {
    public static final String INDENT = "    ";
    public static final String LONG_INDENT = "        ";
    public static final List<String> CONTAINER_LIST_STATICS = Lists.newArrayList((Object[])new String[]{"minecraft", "mcp", "spongeapi", "sponge"});
    protected static final Text SEPARATOR_TEXT = Text.of(", ");
    static final Text INDENT_TEXT = Text.of("    ");
    static final Text NEWLINE_TEXT = Text.NEW_LINE;
    static final Text LIST_ITEM_TEXT = Text.of(TextColors.GRAY, "- ");
    static final Text UNKNOWN = Text.of("UNKNOWN");
    private static final Text ENABLED_TEXT = Text.of(TextColors.GREEN, "enabled");
    private static final Text DISABLED_TEXT = Text.of(TextColors.RED, "disabled");
    private static final Text FAILED_TEXT = Text.of(TextColors.RED, "Failed to set config entry.");
    private static final CommandElement DUMMY_ELEMENT = new CommandElement(Text.EMPTY){

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            throw args.createError(SpongeCommonTranslationHelper.t("No subcommand was specified", new Object[0]));
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return ImmutableList.of();
        }
    };
    private static final DecimalFormat THREE_DECIMAL_DIGITS_FORMATTER = new DecimalFormat("########0.000");
    private static final Comparator<CommandMapping> COMMAND_COMPARATOR = Comparator.comparing(CommandMapping::getPrimaryAlias);
    private static final Text PAGE_KEY = Text.of("page");
    private static final Text COMMAND_KEY = Text.of("command");
    private static final Text PLUGIN_KEY = Text.of("plugin");
    private static final Text ENABLED_KEY = Text.of("enabled");
    private static final CommandElement COMMAND_ARGUMENT = new CommandElement(COMMAND_KEY){

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String input = args.next();
            Optional<? extends CommandMapping> cmd = SpongeImpl.getGame().getCommandManager().get(input, source);
            if (!cmd.isPresent()) {
                throw args.createError(SpongeApiTranslationHelper.t("No such command: ", input));
            }
            return cmd.orElse(null);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            String prefix = args.nextIfPresent().orElse("");
            return (List)SpongeCommandFactory.commandsStr(src).stream().filter(new StartsWithPredicate(prefix)).collect(ImmutableList.toImmutableList());
        }
    };
    private static final Text NOT_FOUND = Text.of("notFound");
    private static final Map<String, Tristate> ENABLED_CHOICES = ImmutableMap.builder().put((Object)"enable", (Object)Tristate.TRUE).put((Object)"enabled", (Object)Tristate.TRUE).put((Object)"disabled", (Object)Tristate.FALSE).put((Object)"disable", (Object)Tristate.FALSE).put((Object)"default", (Object)Tristate.UNDEFINED).build();
    private static final Text IMPLEMENTATION_NAME = Text.of(TextColors.YELLOW, TextStyles.BOLD, Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getName());

    public static CommandSpec createSpongeCommand() {
        ChildCommandElementExecutor trackerFlagChildren = new ChildCommandElementExecutor(null);
        ChildCommandElementExecutor flagChildren = new ChildCommandElementExecutor(trackerFlagChildren, DUMMY_ELEMENT, true);
        ChildCommandElementExecutor nonFlagChildren = new ChildCommandElementExecutor(flagChildren, DUMMY_ELEMENT, true);
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeVersionCommand(), "version");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeBlockInfoCommand(), "blockInfo");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeEntityInfoCommand(), "entityInfo");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeAuditCommand(), "audit");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeHeapCommand(), "heap");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongePluginsCommand(), "plugins");
        nonFlagChildren.register(SpongeCommandFactory.createSpongeTimingsCommand(), "timings");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeWhichCommand(), "which");
        nonFlagChildren.register(SpongeCommandFactory.createSpongeMetricsCommand(), "metrics");
        flagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeChunksCommand(), "chunks");
        flagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeTpsCommand(), "tps");
        trackerFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeConfigCommand(), "config");
        trackerFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeReloadCommand(), "reload");
        trackerFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeSaveCommand(), "save");
        SpongeImplHooks.registerAdditionalCommands(flagChildren, nonFlagChildren);
        return CommandSpec.builder().description(Text.of("General Sponge command")).extendedDescription(Text.of("commands:\n", INDENT, SpongeCommandFactory.title("chunks"), LONG_INDENT, "Prints chunk data for a specific dimension or world(s)\n", INDENT, SpongeCommandFactory.title("conf"), LONG_INDENT, "Configure sponge settings\n", INDENT, SpongeCommandFactory.title("heap"), LONG_INDENT, "Dump live JVM heap\n", INDENT, SpongeCommandFactory.title("reload"), LONG_INDENT, "Reloads a global, dimension, or world config\n", INDENT, SpongeCommandFactory.title("save"), LONG_INDENT, "Saves a global, dimension, or world config\n", INDENT, SpongeCommandFactory.title("version"), LONG_INDENT, "Prints current Sponge version\n", INDENT, SpongeCommandFactory.title("audit"), LONG_INDENT, "Audit mixin classes for implementation\n", INDENT, SpongeCommandFactory.title("plugins"), LONG_INDENT, "List currently installed plugins\n", INDENT, SpongeCommandFactory.title("which"), LONG_INDENT, "List plugins that own a specific command\n", INDENT, SpongeCommandFactory.title("tps"), LONG_INDENT, "Provides TPS (ticks per second) data for loaded worlds\n", INDENT, SpongeCommandFactory.title("metrics"), LONG_INDENT, "Gets or sets permission for metric plugins to operate\n", SpongeImplHooks.getAdditionalCommandDescriptions())).arguments(GenericArguments.firstParsing(nonFlagChildren, GenericArguments.flags().flag("-global", "g").valueFlag(GenericArguments.world(Text.of("world")), "-world", "w").valueFlag(GenericArguments.dimension(Text.of("dimension")), "-dimension", "d").buildWith(flagChildren), GenericArguments.flags().flag("-global", "g").valueFlag(GenericArguments.world(Text.of("world")), "-world", "w").valueFlag(GenericArguments.dimension(Text.of("dimension")), "-dimension", "d").flag("-tracker", "t").buildWith(trackerFlagChildren))).executor(nonFlagChildren).build();
    }

    private static CommandSpec createSpongeChunksCommand() {
        return CommandSpec.builder().description(Text.of("Print chunk information, optionally dump")).arguments(GenericArguments.optional(GenericArguments.seq(GenericArguments.literal((Text)Text.of("dump"), "dump"), GenericArguments.optional(GenericArguments.literal((Text)Text.of("dump-all"), "all"))))).permission("sponge.command.chunks").executor(new ConfigUsingExecutor(true){

            @Override
            public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
                CommandResult res = super.execute(src, args);
                if (args.hasAny("dump")) {
                    File file = new File(new File(new File("."), "chunk-dumps"), "chunk-info-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(Instant.now()) + "-server.txt");
                    src.sendMessage(Text.of("Writing chunk info to: ", file));
                    ChunkSaveHelper.writeChunks(file, args.hasAny("dump-all"));
                    src.sendMessage(Text.of("Chunk info complete"));
                }
                return res;
            }

            @Override
            protected Text processGlobal(SpongeConfig<GlobalConfig> config, CommandSource source, CommandContext args) throws CommandException {
                for (World world : SpongeImpl.getGame().getServer().getWorlds()) {
                    source.sendMessage(Text.of("World ", Text.of(TextStyles.BOLD, world.getName()), this.getChunksInfo((WorldServer)world)));
                }
                return Text.of("Printed chunk info for all worlds ");
            }

            @Override
            protected Text processDimension(SpongeConfig<DimensionConfig> config, DimensionType dim, CommandSource source, CommandContext args) throws CommandException {
                SpongeImpl.getGame().getServer().getWorlds().stream().filter(world -> world.getDimension().getType().equals(dim)).forEach(world -> source.sendMessage(Text.of("World ", Text.of(TextStyles.BOLD, world.getName()), this.getChunksInfo((WorldServer)world))));
                return Text.of("Printed chunk info for all worlds in dimension ", dim.getName());
            }

            @Override
            protected Text processWorld(SpongeConfig<WorldConfig> config, World world, CommandSource source, CommandContext args) throws CommandException {
                return this.getChunksInfo((WorldServer)world);
            }

            protected Text key(Object text) {
                return Text.of(TextColors.GOLD, text);
            }

            protected Text value(Object text) {
                return Text.of(TextColors.GRAY, text);
            }

            protected Text getChunksInfo(WorldServer worldserver) {
                if (((IMixinWorld)worldserver).isFake() || worldserver.func_72912_H() == null) {
                    return Text.of(NEWLINE_TEXT, "Fake world");
                }
                return Text.of(NEWLINE_TEXT, this.key("DimensionId: "), this.value(WorldManager.getDimensionId(worldserver)), NEWLINE_TEXT, this.key("Loaded chunks: "), this.value(worldserver.func_72863_F().func_73152_e()), NEWLINE_TEXT, this.key("Active chunks: "), this.value(worldserver.func_72863_F().func_189548_a().size()), NEWLINE_TEXT, this.key("Entities: "), this.value(worldserver.field_72996_f.size()), NEWLINE_TEXT, this.key("Tile Entities: "), this.value(worldserver.field_147482_g.size()), NEWLINE_TEXT, this.key("Removed Entities:"), this.value(worldserver.field_72997_g.size()), NEWLINE_TEXT, this.key("Removed Tile Entities: "), this.value(worldserver.field_147483_b), NEWLINE_TEXT);
            }
        }).build();
    }

    private static CommandSpec createSpongeConfigCommand() {
        return CommandSpec.builder().description(Text.of("Inspect the Sponge config")).arguments(GenericArguments.seq(GenericArguments.string(Text.of("key")), GenericArguments.optional(GenericArguments.string(Text.of("value"))))).permission("sponge.command.config").executor(new ConfigIncludingTrackerUsingExecutor(false){

            @Override
            protected Text process(SpongeConfig<? extends ConfigBase> config, CommandSource source, CommandContext args) throws CommandException {
                Optional key = args.getOne("key");
                Optional value = args.getOne("value");
                if (config.getSetting((String)key.get()) == null || config.getSetting((String)key.get()).isVirtual()) {
                    throw new CommandException(Text.of("Key ", Text.builder((String)key.get()).color(TextColors.GREEN).build(), " is not valid"));
                }
                if (value.isPresent()) {
                    config.updateSetting((String)key.get(), value.get());
                    return Text.builder().append(Text.of(TextColors.GOLD, key), Text.of(" set to "), SpongeCommandFactory.title((String)value.get())).build();
                }
                return Text.builder().append(Text.of(TextColors.GOLD, key), Text.of(" is "), SpongeCommandFactory.title(String.valueOf(config.getSetting((String)key.get()).getValue()))).build();
            }
        }).build();
    }

    private static CommandSpec createSpongeReloadCommand() {
        return CommandSpec.builder().description(Text.of("Reload the Sponge game")).permission("sponge.command.reload").executor(new ConfigIncludingTrackerUsingExecutor(false){

            @Override
            protected Text process(SpongeConfig<? extends ConfigBase> config, CommandSource source, CommandContext args) throws CommandException {
                config.reload();
                SpongeHooks.refreshActiveConfigs();
                return Text.of("Reloaded configuration");
            }
        }).build();
    }

    private static CommandSpec createSpongeSaveCommand() {
        return CommandSpec.builder().description(Text.of("Save the configuration")).permission("sponge.command.save").executor(new ConfigIncludingTrackerUsingExecutor(false){

            @Override
            protected Text process(SpongeConfig<? extends ConfigBase> config, CommandSource source, CommandContext args) throws CommandException {
                config.save();
                return Text.of("Saved");
            }
        }).build();
    }

    private static CommandSpec createSpongeHeapCommand() {
        return CommandSpec.builder().description(Text.of("Generate a dump of the Sponge heap")).permission("sponge.command.heap").executor((src, args) -> {
            File file = new File(new File(new File("."), "dumps"), "heap-dump-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + "-server.hprof");
            src.sendMessage(Text.of("Writing JVM heap data to: ", file));
            SpongeHooks.dumpHeap(file, true);
            src.sendMessage(Text.of("Heap dump complete"));
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec createSpongeVersionCommand() {
        return CommandSpec.builder().description(Text.of("Display Sponge's current version")).permission("sponge.command.version").executor((src, args) -> {
            Text.Builder builder = Text.builder().append(IMPLEMENTATION_NAME);
            for (PluginContainer container : SpongeImpl.getInternalPlugins()) {
                builder.append(NEWLINE_TEXT, Text.of(TextColors.GRAY, INDENT + container.getName(), ": "), container.getVersion().isPresent() ? Text.of(container.getVersion().get()) : UNKNOWN);
            }
            src.sendMessage(builder.build());
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec createSpongeBlockInfoCommand() {
        return CommandSpec.builder().description(Text.of("Display the tracked information of the Block you are looking at.")).permission("sponge.command.blockinfo").executor((src, args) -> {
            if (!(src instanceof Player)) {
                src.sendMessage(Text.of(TextColors.RED, "Players must execute this command!"));
                return CommandResult.empty();
            }
            EntityPlayerMP entityPlayerMP = EntityUtil.toNative((Player)src);
            RayTraceResult rayTraceResult = EntityUtil.rayTraceFromEntity((net.minecraft.entity.Entity)entityPlayerMP, 5.0, 1.0f);
            if (rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                src.sendMessage(Text.of(TextColors.RED, TextStyles.ITALIC, "Failed to find a block! Please execute the command when looking at a block!"));
                return CommandResult.empty();
            }
            WorldServer worldServer = (WorldServer)entityPlayerMP.field_70170_p;
            Chunk chunk = worldServer.func_175726_f(rayTraceResult.func_178782_a());
            IMixinChunk mixinChunk = (IMixinChunk)chunk;
            IBlockState blockState = worldServer.func_180495_p(rayTraceResult.func_178782_a());
            BlockState spongeState = BlockUtil.fromNative(blockState);
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Block Type: ", TextColors.BLUE, TextStyles.RESET, spongeState.getId()));
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Block Owner: ", TextColors.BLUE, TextStyles.RESET, mixinChunk.getBlockOwner(rayTraceResult.func_178782_a())));
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Block Notifier: ", TextColors.BLUE, TextStyles.RESET, mixinChunk.getBlockNotifier(rayTraceResult.func_178782_a())));
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec createSpongeEntityInfoCommand() {
        return CommandSpec.builder().description(Text.of("Display the tracked information of the Entity you are looking at.")).permission("sponge.command.entityinfo").executor((src, args) -> {
            if (!(src instanceof Player)) {
                return CommandResult.empty();
            }
            EntityPlayerMP entityPlayerMP = EntityUtil.toNative((Player)src);
            RayTraceResult rayTraceResult = EntityUtil.rayTraceFromEntity((net.minecraft.entity.Entity)entityPlayerMP, 5.0, 1.0f, true);
            if (rayTraceResult.field_72313_a != RayTraceResult.Type.ENTITY) {
                src.sendMessage(Text.of(TextColors.RED, TextStyles.ITALIC, "Failed to find an entity! Please execute the command when looking at an entity!"));
                return CommandResult.empty();
            }
            net.minecraft.entity.Entity entityHit = rayTraceResult.field_72308_g;
            IMixinEntity mixinEntity = EntityUtil.toMixin(entityHit);
            Entity spongeEntity = EntityUtil.fromNative(entityHit);
            Text.Builder builder = Text.builder();
            builder.append(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "EntityType: ")).append(Text.of(TextColors.BLUE, TextStyles.RESET, spongeEntity.getType().getId()));
            src.sendMessage(builder.build());
            Optional<User> owner = mixinEntity.getCreatorUser();
            Optional<User> notifier = mixinEntity.getNotifierUser();
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Owner: ", TextColors.BLUE, TextStyles.RESET, owner));
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Notifier: ", TextColors.BLUE, TextStyles.RESET, notifier));
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec createSpongeAuditCommand() {
        return CommandSpec.builder().description(Text.of("Audit Mixin classes for implementation")).permission("sponge.command.audit").executor((src, args) -> {
            MixinEnvironment.getCurrentEnvironment().audit();
            return CommandResult.empty();
        }).build();
    }

    public static Text title(String title) {
        return Text.of(TextColors.GREEN, title);
    }

    public static Text hl(String toHighlight) {
        return Text.of(TextColors.DARK_GREEN, toHighlight);
    }

    private static CommandSpec createSpongePluginsCommand() {
        return CommandSpec.builder().description(Text.of("List currently installed plugins")).permission("sponge.command.plugins").arguments(GenericArguments.optionalWeak(GenericArguments.literal((Text)Text.of("reload"), "reload")), GenericArguments.optional(GenericArguments.plugin(Text.of("plugin")))).executor((src, args) -> {
            if (args.hasAny("reload") && src.hasPermission("sponge.command.plugins.reload")) {
                Sponge.getCauseStackManager().pushCause(src);
                if (args.hasAny("plugin")) {
                    PluginContainer plugin = (PluginContainer)args.getOne("plugin").orElseThrow(() -> new CommandException(Text.of("More than one plugin was matched by the input, please be more specific.")));
                    src.sendMessage(Text.of("Sending reload event to " + plugin.getId() + ". Please wait."));
                    ((SpongeEventManager)Sponge.getEventManager()).post((Event)SpongeEventFactory.createGameReloadEvent(Sponge.getCauseStackManager().getCurrentCause()), plugin);
                } else {
                    src.sendMessage(Text.of("Sending reload event to all plugins. Please wait."));
                    SpongeImpl.postEvent(SpongeEventFactory.createGameReloadEvent(Sponge.getCauseStackManager().getCurrentCause()));
                }
                Sponge.getCauseStackManager().popCause();
                src.sendMessage(Text.of("Reload complete!"));
            } else if (args.hasAny("plugin")) {
                SpongeCommandFactory.sendContainerMeta(src, args, "plugin");
            } else {
                Collection<PluginContainer> containers = SpongeImpl.getGame().getPluginManager().getPlugins();
                ArrayList sortedContainers = new ArrayList();
                CONTAINER_LIST_STATICS.forEach(containerId -> containers.stream().filter(container -> container.getId().equalsIgnoreCase((String)containerId)).findFirst().ifPresent(sortedContainers::add));
                containers.stream().filter(SpongeImplHooks.getPluginFilterPredicate()).sorted(Comparator.comparing(PluginContainer::getName)).forEachOrdered(sortedContainers::add);
                if (src instanceof Player) {
                    ArrayList<Text> containerList = new ArrayList<Text>();
                    PaginationList.Builder builder = PaginationList.builder();
                    builder.title(Text.of(TextColors.YELLOW, "Plugins", TextColors.WHITE, " (", sortedContainers.size(), ")")).padding(Text.of(TextColors.DARK_GREEN, "="));
                    for (PluginContainer container : sortedContainers) {
                        Text.Builder containerBuilder = Text.builder().append(Text.of(TextColors.RESET, " - ", TextColors.GREEN, container.getName())).onClick(TextActions.runCommand("/sponge:sponge plugins " + container.getId())).onHover(TextActions.showText(Text.of(TextColors.RESET, "ID: ", container.getId(), Text.NEW_LINE, "Version: ", container.getVersion().orElse("Unknown"))));
                        containerList.add(containerBuilder.build());
                    }
                    builder.contents(containerList).build().sendTo(src);
                } else {
                    Text.Builder builder = Text.builder();
                    builder.append(Text.of(TextColors.YELLOW, "Plugins", TextColors.WHITE, " (", sortedContainers.size(), "): "));
                    boolean first = true;
                    for (PluginContainer container : sortedContainers) {
                        if (!first) {
                            builder.append(SEPARATOR_TEXT);
                        }
                        first = false;
                        builder.append(Text.of(TextColors.GREEN, container.getName()));
                    }
                    src.sendMessage(builder.build());
                }
            }
            return CommandResult.success();
        }).build();
    }

    public static void appendPluginMeta(Text.Builder builder, String key, Optional<?> value) {
        if (value.isPresent()) {
            SpongeCommandFactory.appendPluginMeta(builder, key, value.get());
        }
    }

    public static void appendPluginMeta(Text.Builder builder, String key, Object value) {
        builder.append(NEWLINE_TEXT, INDENT_TEXT, SpongeCommandFactory.title(key + ": "), Text.of(value));
    }

    public static void sendContainerMeta(CommandSource src, CommandContext args, String argumentName) {
        for (PluginContainer container : args.getAll(argumentName)) {
            Text.Builder builder = Text.builder().append(SpongeCommandFactory.title(container.getName()));
            container.getVersion().ifPresent(version -> builder.append(Text.of(" v" + version)));
            SpongeCommandFactory.appendPluginMeta(builder, "ID", container.getId());
            SpongeCommandFactory.appendPluginMeta(builder, "Description", container.getDescription());
            SpongeCommandFactory.appendPluginMeta(builder, "URL", container.getUrl().map(url -> {
                ClickAction.OpenUrl action = null;
                try {
                    action = TextActions.openUrl(new URL((String)url));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return Text.builder(url).onClick((ClickAction)action);
            }));
            if (!container.getAuthors().isEmpty()) {
                SpongeCommandFactory.appendPluginMeta(builder, "Authors", String.join((CharSequence)", ", container.getAuthors()));
            }
            SpongeCommandFactory.appendPluginMeta(builder, "Main class", container.getInstance().map(instance -> instance.getClass().getCanonicalName()));
            src.sendMessage(builder.build());
        }
    }

    private static CommandCallable createSpongeTimingsCommand() {
        return CommandSpec.builder().permission("sponge.command.timings").description(Text.of("Manages Sponge Timings data to see performance of the server.")).child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.reset();
            src.sendMessage(Text.of("Timings reset"));
            return CommandResult.success();
        }).build(), "reset").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.generateReport(src);
            return CommandResult.success();
        }).build(), "report", "paste").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            Timings.setTimingsEnabled(true);
            src.sendMessage(Text.of("Enabled Timings & Reset"));
            return CommandResult.success();
        }).build(), "on").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            Timings.setTimingsEnabled(false);
            src.sendMessage(Text.of("Disabled Timings"));
            return CommandResult.success();
        }).build(), "off").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.setVerboseTimingsEnabled(true);
            src.sendMessage(Text.of("Enabled Verbose Timings"));
            return CommandResult.success();
        }).build(), "verbon").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.setVerboseTimingsEnabled(false);
            src.sendMessage(Text.of("Disabled Verbose Timings"));
            return CommandResult.success();
        }).build(), "verboff").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            src.sendMessage(Text.of("Timings cost: " + SpongeTimingsFactory.getCost()));
            return CommandResult.success();
        }).build(), "cost").build();
    }

    private static CommandSpec createSpongeWhichCommand() {
        return CommandSpec.builder().permission("sponge.command.which").description(Text.of("List plugins that own a specific command")).arguments(GenericArguments.choices((Text)Text.of("command"), () -> Sponge.getCommandManager().getAll().keySet(), Function.identity())).executor((src, args) -> {
            CommandManager mgr = Sponge.getCommandManager();
            String commandName = (String)args.getOne("command").get();
            CommandMapping primary = mgr.get(commandName, src).orElseThrow(() -> new CommandException(Text.of("Invalid command ", commandName)));
            Set<? extends CommandMapping> all = mgr.getAll(commandName);
            src.sendMessage(Text.of(SpongeCommandFactory.title("Primary: "), "Aliases ", SpongeCommandFactory.hl(primary.getAllAliases().toString()), " owned by ", SpongeCommandFactory.hl(mgr.getOwner(primary).map(PluginContainer::getName).orElse("unknown"))));
            if (all.size() > 1 || all.iterator().next() != primary) {
                src.sendMessage(SpongeCommandFactory.title("Others:"));
                all.stream().filter(map -> !map.equals(primary)).forEach(mapping -> src.sendMessage(Text.of(LIST_ITEM_TEXT, "Aliases ", SpongeCommandFactory.hl(mapping.getAllAliases().toString()), " owned by ", SpongeCommandFactory.hl(mgr.getOwner((CommandMapping)mapping).map(PluginContainer::getName).orElse("unknown")))));
            }
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec createSpongeTpsCommand() {
        return CommandSpec.builder().permission("sponge.command.tps").description(Text.of("Provides TPS (ticks per second) data for loaded worlds.")).arguments(GenericArguments.optional(GenericArguments.world(Text.of("world")))).executor((src, args) -> {
            if (args.hasAny("world")) {
                for (WorldProperties properties : args.getAll("world")) {
                    Optional<World> optWorld = Sponge.getServer().getWorld(properties.getWorldName());
                    if (!optWorld.isPresent()) {
                        src.sendMessage(Text.of(properties.getWorldName() + " has no TPS as it is offline!"));
                        continue;
                    }
                    SpongeCommandFactory.printWorldTickTime(src, optWorld.get());
                }
            } else {
                Sponge.getServer().getWorlds().forEach(world -> SpongeCommandFactory.printWorldTickTime(src, world));
            }
            double serverMeanTickTime = (double)SpongeCommandFactory.mean(SpongeImpl.getServer().field_71311_j).longValue() * 1.0E-6;
            src.sendMessage(Text.of("Overall TPS: ", TextColors.LIGHT_PURPLE, THREE_DECIMAL_DIGITS_FORMATTER.format(Math.min(1000.0 / serverMeanTickTime, 20.0)), TextColors.RESET, ", Mean: ", TextColors.RED, THREE_DECIMAL_DIGITS_FORMATTER.format(serverMeanTickTime), "ms"));
            return CommandResult.success();
        }).build();
    }

    private static void printWorldTickTime(CommandSource src, World world) {
        long[] worldTickTimes = ((IMixinMinecraftServer)SpongeImpl.getServer()).getWorldTickTimes(((IMixinWorldServer)((Object)world)).getDimensionId());
        double worldMeanTickTime = (double)SpongeCommandFactory.mean(worldTickTimes).longValue() * 1.0E-6;
        double worldTps = Math.min(1000.0 / worldMeanTickTime, 20.0);
        src.sendMessage(Text.of("World [", TextColors.DARK_GREEN, world.getName(), TextColors.RESET, "] (DIM", ((IMixinWorldServer)((Object)world)).getDimensionId(), ") TPS: ", TextColors.LIGHT_PURPLE, THREE_DECIMAL_DIGITS_FORMATTER.format(worldTps), TextColors.RESET, ", Mean: ", TextColors.RED, THREE_DECIMAL_DIGITS_FORMATTER.format(worldMeanTickTime), "ms"));
    }

    private static Long mean(long[] values) {
        Long mean = 0L;
        if (values.length > 0) {
            for (long value : values) {
                mean = mean + value;
            }
            mean = mean / (long)values.length;
        }
        return mean;
    }

    public static CommandSpec createHelpCommand() {
        return CommandSpec.builder().permission("sponge.command.help").arguments(GenericArguments.optional(GenericArguments.firstParsing(GenericArguments.integer(PAGE_KEY), COMMAND_ARGUMENT, GenericArguments.string(NOT_FOUND)))).description(Text.of("View a list of all commands.")).extendedDescription(Text.of("View a list of all commands. Hover over\n a command to view its description. Click\n a command to insert it into your chat bar.")).executor((src, args) -> {
            if (args.getOne(NOT_FOUND).isPresent()) {
                throw new CommandException(Text.of("No such command: ", args.getOne(NOT_FOUND).get()));
            }
            Optional command = args.getOne(COMMAND_KEY);
            Optional<Integer> page = args.getOne(PAGE_KEY);
            if (command.isPresent()) {
                CommandCallable callable = ((CommandMapping)command.get()).getCallable();
                Optional<Text> desc = callable.getHelp(src);
                if (desc.isPresent()) {
                    src.sendMessage(desc.get());
                } else {
                    src.sendMessage(Text.of("Usage: /", command.get(), callable.getUsage(src)));
                }
                return CommandResult.success();
            }
            ImmutableList contents = ImmutableList.builder().add((Object)Text.of(Sponge.getRegistry().getTranslationById("commands.help.footer").get(), new Object[0])).addAll((Iterable)SpongeCommandFactory.commands(src).stream().map(input -> SpongeCommandFactory.createDescription(src, input)).collect(Collectors.toList())).build();
            PaginationList.builder().title(Text.of(TextColors.DARK_GREEN, "Showing Help (/page <page>):")).padding(Text.of(TextColors.DARK_GREEN, "=")).contents((Iterable<Text>)contents).build().sendTo(src, (int)page.orElse(1));
            return CommandResult.success();
        }).build();
    }

    private static CommandCallable createSpongeMetricsCommand() {
        return CommandSpec.builder().arguments(GenericArguments.optional(GenericArguments.onlyOne(GenericArguments.plugin(Text.of(PLUGIN_KEY)))), GenericArguments.optional(GenericArguments.onlyOne(GenericArguments.choicesInsensitive(Text.of(ENABLED_KEY), ENABLED_CHOICES)))).description(Text.of("Gets or sets permission for metric plugins to operate.")).permission("sponge.command.metrics").executor((source, context) -> {
            SpongeConfig<GlobalConfig> config = SpongeImpl.getGlobalConfig();
            MetricsCategory category = config.getConfig().getMetricsCategory();
            if (!context.hasAny(PLUGIN_KEY)) {
                if (category.isGloballyEnabled()) {
                    source.sendMessage(Text.of("Metric collection default permission is currently ", ENABLED_TEXT));
                } else {
                    source.sendMessage(Text.of("Metric collection default permission is currently ", DISABLED_TEXT));
                }
            } else {
                PluginContainer container = (PluginContainer)context.requireOne(PLUGIN_KEY);
                if (context.hasAny(ENABLED_KEY)) {
                    Tristate stateToSet = (Tristate)((Object)((Object)context.requireOne(ENABLED_KEY)));
                    if (stateToSet == Tristate.UNDEFINED) {
                        SpongeCommandFactory.setPermissions(category, container, category.isGloballyEnabled()).handle((node, exception) -> {
                            if (exception == null) {
                                SpongeCommandFactory.createMessageTask(source, Text.of("Metric collection for ", container.getName(), " is now set to the default value (", category.isGloballyEnabled() ? ENABLED_TEXT : DISABLED_TEXT, ")"));
                            } else {
                                SpongeCommandFactory.createMessageTask(source, FAILED_TEXT);
                            }
                            return node;
                        });
                    } else if (stateToSet == Tristate.TRUE) {
                        SpongeCommandFactory.setPermissions(category, container, true).handle((node, exception) -> {
                            if (exception == null) {
                                SpongeCommandFactory.createMessageTask(source, Text.of("Set metric collection for ", container.getName(), " to ", ENABLED_TEXT));
                            } else {
                                SpongeCommandFactory.createMessageTask(source, FAILED_TEXT);
                            }
                            return node;
                        });
                    } else {
                        SpongeCommandFactory.setPermissions(category, container, false).handle((node, exception) -> {
                            if (exception == null) {
                                SpongeCommandFactory.createMessageTask(source, Text.of("Set metric collection for ", container.getName(), " to ", DISABLED_TEXT));
                            } else {
                                SpongeCommandFactory.createMessageTask(source, FAILED_TEXT);
                            }
                            return node;
                        });
                    }
                    config.save();
                } else {
                    boolean state = category.getPluginPermission(container).orElseGet(category::isGloballyEnabled);
                    if (state) {
                        source.sendMessage(Text.of("Metric collection for ", container.getName(), " is currently ", ENABLED_TEXT));
                    } else {
                        source.sendMessage(Text.of("Metric collection for ", container.getName(), " is currently ", DISABLED_TEXT));
                    }
                }
            }
            return CommandResult.success();
        }).build();
    }

    private static CompletableFuture<CommentedConfigurationNode> setPermissions(MetricsCategory category, PluginContainer container, boolean enabled) {
        Map<String, Boolean> permissions = category.getPluginPermissions();
        permissions.put(container.getId(), enabled);
        return SpongeHooks.savePluginsInMetricsConfig(permissions);
    }

    private static void createMessageTask(CommandSource source, Text message) {
        Task.builder().execute(() -> source.sendMessage(message)).submit(SpongeImpl.getPlugin());
    }

    private static Collection<String> commandsStr(CommandSource src) {
        return SpongeCommandFactory.commands(src).stream().map(CommandMapping::getPrimaryAlias).collect(Collectors.toList());
    }

    private static TreeSet<CommandMapping> commands(CommandSource src) {
        TreeSet<CommandMapping> commands = new TreeSet<CommandMapping>(COMMAND_COMPARATOR);
        commands.addAll(Sponge.getCommandManager().getAll().values().stream().filter(input -> input.getCallable().testPermission(src)).collect(Collectors.toList()));
        return commands;
    }

    private static Text createDescription(CommandSource source, CommandMapping mapping) {
        Optional<Text> description = mapping.getCallable().getShortDescription(source);
        LiteralText.Builder text = Text.builder("/" + mapping.getPrimaryAlias());
        ((Text.Builder)text).color(TextColors.GREEN);
        ((Text.Builder)text).onClick(TextActions.suggestCommand("/" + mapping.getPrimaryAlias() + " "));
        Optional<Text> longDescription = mapping.getCallable().getHelp(source);
        if (longDescription.isPresent()) {
            ((Text.Builder)text).onHover(TextActions.showText(longDescription.get()));
        }
        return Text.of(text, " ", description.orElse(mapping.getCallable().getUsage(source)));
    }

    private static abstract class ConfigIncludingTrackerUsingExecutor
    extends ConfigUsingExecutor {
        ConfigIncludingTrackerUsingExecutor(boolean requireWorldLoaded) {
            super(requireWorldLoaded);
        }

        @Override
        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            int successes = 0;
            if (args.hasAny("tracker")) {
                src.sendMessage(Text.of("Tracker: ", this.processTracker(SpongeImpl.getTrackerConfig(), src, args)));
                ++successes;
            }
            return this.execute(src, args, successes);
        }

        protected Text processTracker(SpongeConfig<TrackerConfig> config, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }
    }

    private static abstract class ConfigUsingExecutor
    implements CommandExecutor {
        private boolean requireWorldLoaded;

        ConfigUsingExecutor(boolean requireWorldLoaded) {
            this.requireWorldLoaded = requireWorldLoaded;
        }

        @Override
        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            return this.execute(src, args, 0);
        }

        public CommandResult execute(CommandSource src, CommandContext args, int successes) throws CommandException {
            if (args.hasAny("global")) {
                src.sendMessage(Text.of("Global: ", this.processGlobal(SpongeImpl.getGlobalConfig(), src, args)));
                ++successes;
            }
            if (args.hasAny("dimension")) {
                for (DimensionType dimensionType : args.getAll("dimension")) {
                    src.sendMessage(Text.of("Dimension ", dimensionType.getName(), ": ", this.processDimension(((IMixinDimensionType)((Object)dimensionType)).getDimensionConfig(), dimensionType, src, args)));
                    ++successes;
                }
            }
            if (args.hasAny("world")) {
                for (WorldProperties properties : args.getAll("world")) {
                    Optional<World> world = SpongeImpl.getGame().getServer().getWorld(properties.getUniqueId());
                    if (!world.isPresent() && this.requireWorldLoaded) {
                        throw new CommandException(Text.of("World ", properties.getWorldName(), " is not loaded, cannot work with it"));
                    }
                    src.sendMessage(Text.of("World ", properties.getWorldName(), ": ", this.processWorld(((IMixinWorldInfo)((Object)properties)).getOrCreateWorldConfig(), world.orElse(null), src, args)));
                    ++successes;
                }
            }
            if (successes == 0) {
                throw new CommandException(Text.of("At least one target flag must be specified"));
            }
            return CommandResult.builder().successCount(successes).build();
        }

        protected Text processGlobal(SpongeConfig<GlobalConfig> config, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }

        protected Text processDimension(SpongeConfig<DimensionConfig> config, DimensionType dim, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }

        protected Text processWorld(SpongeConfig<WorldConfig> config, World world, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }

        protected Text process(SpongeConfig<? extends ConfigBase> config, CommandSource source, CommandContext args) throws CommandException {
            return Text.of("Unimplemented");
        }
    }
}

