/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.command.SpongeCommandFactory;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.plugin.BasicPluginContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.interfaces.entity.IMixinEntityLivingBase;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.interfaces.world.IMixinITeleporter;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.InventoryUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.entity.ProfessionRegistryModule;
import org.spongepowered.common.util.SpawnerSpawnType;
import org.spongepowered.common.world.WorldManager;

public final class SpongeImplHooks {
    public static boolean isVanilla() {
        return true;
    }

    public static boolean isClientAvailable() {
        return false;
    }

    public static boolean isDeobfuscatedEnvironment() {
        return true;
    }

    public static String getModIdFromClass(Class<?> clazz) {
        String className = clazz.getName();
        if (className.startsWith("net.minecraft.")) {
            return "minecraft";
        }
        if (className.startsWith("org.spongepowered.")) {
            return "sponge";
        }
        return "unknown";
    }

    public static boolean isCreatureOfType(Entity entity, EnumCreatureType type) {
        return type.func_75598_a().isAssignableFrom(entity.getClass());
    }

    public static boolean isFakePlayer(Entity entity) {
        return false;
    }

    public static void fireServerConnectionEvent(NetworkManager netManager) {
    }

    public static void firePlayerJoinSpawnEvent(EntityPlayerMP playerMP) {
    }

    public static void handlePostChangeDimensionEvent(EntityPlayerMP playerIn, WorldServer fromWorld, WorldServer toWorld) {
    }

    public static boolean checkAttackEntity(EntityPlayer entityPlayer, Entity targetEntity) {
        return true;
    }

    public static double getBlockReachDistance(EntityPlayerMP player) {
        return 5.0;
    }

    @Nullable
    public static Class<? extends Entity> getEntityClass(ResourceLocation name) {
        return (Class)EntityList.field_191308_b.func_82594_a((Object)name);
    }

    @Nullable
    public static String getEntityTranslation(ResourceLocation name) {
        return EntityList.func_191302_a((ResourceLocation)name);
    }

    public static int getEntityId(Class<? extends Entity> entityClass) {
        return EntityList.field_191308_b.func_148757_b(entityClass);
    }

    public static boolean isBlockFlammable(Block block, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return Blocks.field_150480_ab.func_176532_c(block) > 0;
    }

    public static int getBlockLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_185891_c();
    }

    public static int getChunkPosLight(IBlockState blockState, net.minecraft.world.World world, BlockPos pos) {
        return blockState.func_185906_d();
    }

    @Nullable
    public static TileEntity createTileEntity(Block block, net.minecraft.world.World world, IBlockState state) {
        if (block instanceof ITileEntityProvider) {
            return ((ITileEntityProvider)block).func_149915_a(world, block.func_176201_c(state));
        }
        return null;
    }

    public static boolean hasBlockTileEntity(Block block, IBlockState state) {
        return block instanceof ITileEntityProvider;
    }

    public static boolean shouldRefresh(TileEntity tile, net.minecraft.world.World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public static void onTileChunkUnload(TileEntity te) {
    }

    public static Iterator<Chunk> getChunkIterator(WorldServer world) {
        return world.func_184164_w().func_187300_b();
    }

    public static void registerPortalAgentType(@Nullable IMixinITeleporter teleporter) {
    }

    public static boolean canDoLightning(WorldProvider provider, Chunk chunk) {
        return true;
    }

    public static boolean canDoRainSnowIce(WorldProvider provider, Chunk chunk) {
        return true;
    }

    public static int getRespawnDimension(WorldProvider targetDimension, EntityPlayerMP player) {
        return 0;
    }

    public static BlockPos getRandomizedSpawnPoint(WorldServer world) {
        BlockPos ret = world.func_175694_M();
        boolean isAdventure = world.func_72912_H().func_76077_q() == GameType.ADVENTURE;
        int spawnFuzz = Math.max(0, world.func_73046_m().func_184108_a(world));
        int border = MathHelper.func_76128_c((double)world.func_175723_af().func_177729_b((double)ret.func_177958_n(), (double)ret.func_177952_p()));
        if (border < spawnFuzz) {
            spawnFuzz = border;
        }
        if (!world.field_73011_w.func_177495_o() && !isAdventure && spawnFuzz != 0) {
            if (spawnFuzz < 2) {
                spawnFuzz = 2;
            }
            int spawnFuzzHalf = spawnFuzz / 2;
            ret = world.func_175672_r(ret.func_177982_a(world.field_73012_v.nextInt(spawnFuzzHalf) - spawnFuzz, 0, world.field_73012_v.nextInt(spawnFuzzHalf) - spawnFuzz));
        }
        return ret;
    }

    public static void addItemStackToListForSpawning(Collection<ItemDropData> itemStacks, @Nullable ItemDropData itemStack) {
        if (itemStack != null) {
            itemStacks.add(itemStack);
        }
    }

    public static MapStorage getWorldMapStorage(net.minecraft.world.World world) {
        return world.func_175693_T();
    }

    public static int countEntities(WorldServer worldServer, EnumCreatureType type, boolean forSpawnCount) {
        return worldServer.func_72907_a(type.func_75598_a());
    }

    public static int getMaxSpawnPackSize(EntityLiving entityLiving) {
        return entityLiving.func_70641_bl();
    }

    public static SpawnerSpawnType canEntitySpawnHere(EntityLiving entityLiving, boolean entityNotColliding) {
        if (entityLiving.func_70601_bi() && entityNotColliding) {
            return SpawnerSpawnType.NORMAL;
        }
        return SpawnerSpawnType.NONE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Object onUtilRunTask(FutureTask<?> task, Logger logger) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        try (BasicPluginContext context = (BasicPluginContext)PluginPhase.State.SCHEDULED_TASK.createPhaseContext().source(task);){
            Object o;
            context.buildAndSwitch();
            Object object = o = Util.func_181617_a(task, (Logger)logger);
            return object;
        }
        catch (Exception e) {
            phaseTracker.printExceptionFromPhase(e);
            return null;
        }
    }

    public static void onEntityError(Entity entity, CrashReport crashReport) {
        throw new ReportedException(crashReport);
    }

    public static void onTileEntityError(TileEntity tileEntity, CrashReport crashReport) {
        throw new ReportedException(crashReport);
    }

    public static void blockExploded(Block block, net.minecraft.world.World world, BlockPos blockpos, Explosion explosion) {
        world.func_175698_g(blockpos);
        block.func_180652_a(world, blockpos, explosion);
    }

    public static boolean isRestoringBlocks(net.minecraft.world.World world) {
        return PhaseTracker.getInstance().getCurrentState() == BlockPhase.State.RESTORING_BLOCKS;
    }

    public static void onTileEntityChunkUnload(TileEntity tileEntity) {
    }

    public static boolean canConnectRedstone(Block block, IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return state.func_185897_m() && side != null;
    }

    public static Optional<ItemStack> getContainerItem(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"The itemStack must not be null");
        net.minecraft.item.ItemStack nmsStack = ItemStackUtil.toNative(itemStack);
        if (nmsStack.func_190926_b()) {
            return Optional.empty();
        }
        Item nmsItem = nmsStack.func_77973_b();
        if (nmsItem.func_77634_r()) {
            Item nmsContainerItem = nmsItem.func_77668_q();
            net.minecraft.item.ItemStack nmsContainerStack = new net.minecraft.item.ItemStack(nmsContainerItem);
            ItemStack containerStack = ItemStackUtil.fromNative(nmsContainerStack);
            return Optional.of(containerStack);
        }
        return Optional.empty();
    }

    public static Optional<CraftingRecipe> findMatchingRecipe(CraftingGridInventory inventory, World world) {
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)InventoryUtil.toNativeInventory(inventory), (net.minecraft.world.World)((net.minecraft.world.World)world));
        return Optional.ofNullable((CraftingRecipe)recipe);
    }

    public static Collection<CraftingRecipe> getCraftingRecipes() {
        return (Collection)Streams.stream((Iterator)CraftingManager.field_193380_a.iterator()).map(CraftingRecipe.class::cast).collect(ImmutableList.toImmutableList());
    }

    public static Optional<CraftingRecipe> getRecipeById(String id) {
        IRecipe recipe = (IRecipe)CraftingManager.field_193380_a.func_82594_a((Object)new ResourceLocation(id));
        if (recipe == null) {
            return Optional.empty();
        }
        return Optional.of((CraftingRecipe)recipe);
    }

    @Nullable
    public static PluginContainer getActiveModContainer() {
        return null;
    }

    public static Text getAdditionalCommandDescriptions() {
        return Text.EMPTY;
    }

    public static void registerAdditionalCommands(ChildCommandElementExecutor flagChildren, ChildCommandElementExecutor nonFlagChildren) {
    }

    public static Predicate<? super PluginContainer> getPluginFilterPredicate() {
        return plugin -> !SpongeCommandFactory.CONTAINER_LIST_STATICS.contains(plugin.getId());
    }

    @Nullable
    public static RayTraceResult rayTraceEyes(EntityLivingBase entity, double length) {
        Vec3d startPos = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        Vec3d endPos = startPos.func_178787_e(entity.func_70040_Z().func_186678_a(length));
        return entity.field_70170_p.func_72933_a(startPos, endPos);
    }

    public static boolean shouldKeepSpawnLoaded(DimensionType dimensionType, int dimensionId) {
        WorldServer worldServer = WorldManager.getWorldByDimensionId(dimensionId).orElse(null);
        return worldServer != null && ((WorldProperties)worldServer.func_72912_H()).doesKeepSpawnLoaded();
    }

    public static void setShouldLoadSpawn(DimensionType dimensionType, boolean keepSpawnLoaded) {
    }

    public static BlockPos getBedLocation(EntityPlayer playerIn, int dimension) {
        return ((IMixinEntityPlayer)playerIn).getBedLocation(dimension);
    }

    public static boolean isSpawnForced(EntityPlayer playerIn, int dimension) {
        return ((IMixinEntityPlayer)playerIn).isSpawnForced(dimension);
    }

    public static Inventory toInventory(Object inventory, @Nullable Object fallback) {
        SpongeImpl.getLogger().error("Unknown inventory " + inventory.getClass().getName() + " report this to Sponge");
        return null;
    }

    public static void onTileEntityInvalidate(TileEntity te) {
        te.func_145843_s();
    }

    public static void capturePerEntityItemDrop(PhaseContext<?> phaseContext, Entity owner, EntityItem entityitem) {
        phaseContext.getPerEntityItemEntityDropSupplier().get().put((Object)owner.func_110124_au(), (Object)entityitem);
    }

    public static int getLootingEnchantmentModifier(IMixinEntityLivingBase mixinEntityLivingBase, EntityLivingBase entity, DamageSource cause) {
        return EnchantmentHelper.func_185283_h((EntityLivingBase)entity);
    }

    public static double getWorldMaxEntityRadius(IMixinWorldServer mixinWorldServer) {
        return 2.0;
    }

    public static Profession validateProfession(int professionId) {
        List professions = (List)ProfessionRegistryModule.getInstance().getAll();
        for (Profession profession : professions) {
            if (!(profession instanceof SpongeProfession) || professionId != ((SpongeProfession)profession).type) continue;
            return profession;
        }
        throw new IllegalStateException("Invalid Villager profession id is present! Found: " + professionId + " when the expected contain: " + professions);
    }

    public static void onUseItemTick(EntityLivingBase entity, net.minecraft.item.ItemStack stack, int activeItemStackUseCount) {
    }

    public static void onTETickStart(TileEntity te) {
    }

    public static void onTETickEnd(TileEntity te) {
    }

    public static void onEntityTickStart(Entity entity) {
    }

    public static void onEntityTickEnd(Entity entity) {
    }

    public static boolean isMainThread() {
        return !Sponge.isServerAvailable() || Sponge.getServer().isMainThread();
    }

    public static boolean creativeExploitCheck(Packet<?> packetIn, EntityPlayerMP playerMP) {
        return false;
    }

    public static String getImplementationId() {
        throw new UnsupportedOperationException("SpongeCommon does not have it's own ecosystem, this needs to be mixed into for implementations depending on SpongeCommon");
    }
}

