/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.gen.populator;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.type.MushroomType;

public interface Mushroom
extends Populator {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public ChanceTable<MushroomType> getTypes();

    public VariableAmount getMushroomsPerChunk();

    public void setMushroomsPerChunk(VariableAmount var1);

    default public void setMushroomsPerChunk(int count) {
        this.setMushroomsPerChunk(VariableAmount.fixed(count));
    }

    public Optional<Function<Location<Extent>, MushroomType>> getSupplierOverride();

    public void setSupplierOverride(@Nullable Function<Location<Extent>, MushroomType> var1);

    default public void clearSupplierOverride() {
        this.setSupplierOverride(null);
    }

    public static interface Builder
    extends ResettableBuilder<Mushroom, Builder> {
        public Builder types(ChanceTable<MushroomType> var1);

        public Builder type(MushroomType var1, double var2);

        public Builder mushroomsPerChunk(VariableAmount var1);

        default public Builder mushroomsPerChunk(int count) {
            return this.mushroomsPerChunk(VariableAmount.fixed(count));
        }

        public Builder supplier(@Nullable Function<Location<Extent>, MushroomType> var1);

        public Mushroom build() throws IllegalStateException;
    }
}

