/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.gen.populator;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.type.PlantType;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.Populator;

public interface Flower
extends Populator {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public VariableAmount getFlowersPerChunk();

    public void setFlowersPerChunk(VariableAmount var1);

    default public void setFlowersPerChunk(int count) {
        this.setFlowersPerChunk(VariableAmount.fixed(count));
    }

    public WeightedTable<PlantType> getFlowerTypes();

    public Optional<Function<Location<Extent>, PlantType>> getSupplierOverride();

    public void setSupplierOverride(@Nullable Function<Location<Extent>, PlantType> var1);

    default public void clearSupplierOverride() {
        this.setSupplierOverride(null);
    }

    public static interface Builder
    extends ResettableBuilder<Flower, Builder> {
        public Builder perChunk(VariableAmount var1);

        default public Builder perChunk(int count) {
            return this.perChunk(VariableAmount.fixed(count));
        }

        public Builder types(WeightedTable<PlantType> var1);

        public Builder type(PlantType var1, double var2);

        public Builder supplier(Function<Location<Extent>, PlantType> var1);

        public Flower build() throws IllegalStateException;
    }
}

