/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.extent;

import com.flowpowered.math.vector.Vector3i;
import com.google.gson.internal.;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;

public interface LocationCompositeValueStore {
    default public <E> Optional<E> get(Vector3i coordinates, Key<? extends BaseValue<E>> key) {
        return this.get(coordinates.getX(), coordinates.getY(), coordinates.getZ(), key);
    }

    public <E> Optional<E> get(int var1, int var2, int var3, Key<? extends BaseValue<E>> var4);

    default public <T extends DataManipulator<?, ?>> Optional<T> get(Vector3i coordinates, Class<T> manipulatorClass) {
        return this.get(coordinates.getX(), coordinates.getY(), coordinates.getZ(), manipulatorClass);
    }

    public <T extends DataManipulator<?, ?>> Optional<T> get(int var1, int var2, int var3, Class<T> var4);

    default public <T extends DataManipulator<?, ?>> Optional<T> getOrCreate(Vector3i coordinates, Class<T> manipulatorClass) {
        return this.getOrCreate(coordinates.getX(), coordinates.getY(), coordinates.getZ(), manipulatorClass);
    }

    public <T extends DataManipulator<?, ?>> Optional<T> getOrCreate(int var1, int var2, int var3, Class<T> var4);

    @Nullable
    default public <E> E getOrNull(Vector3i coordinates, Key<? extends BaseValue<E>> key) {
        return this.get(coordinates.getX(), coordinates.getY(), coordinates.getZ(), key).orElse(null);
    }

    @Nullable
    default public <E> E getOrNull(int x, int y, int z, Key<? extends BaseValue<E>> key) {
        return this.get(x, y, z, key).orElse(null);
    }

    default public <E> E getOrElse(Vector3i coordinates, Key<? extends BaseValue<E>> key, E defaultValue) {
        return (E)this.get(coordinates.getX(), coordinates.getY(), coordinates.getZ(), key).orElse(.Gson.Preconditions.checkNotNull(defaultValue));
    }

    default public <E> E getOrElse(int x, int y, int z, Key<? extends BaseValue<E>> key, E defaultValue) {
        return (E)this.get(x, y, z, key).orElse(.Gson.Preconditions.checkNotNull(defaultValue));
    }

    default public <E, V extends BaseValue<E>> Optional<V> getValue(Vector3i coordinates, Key<V> key) {
        return this.getValue(coordinates.getX(), coordinates.getY(), coordinates.getZ(), key);
    }

    public <E, V extends BaseValue<E>> Optional<V> getValue(int var1, int var2, int var3, Key<V> var4);

    default public boolean supports(Vector3i coordinates, Key<?> key) {
        return this.supports(coordinates.getX(), coordinates.getY(), coordinates.getZ(), key);
    }

    public boolean supports(int var1, int var2, int var3, Key<?> var4);

    default public boolean supports(Vector3i coordinates, BaseValue<?> value) {
        return this.supports(coordinates.getX(), coordinates.getY(), coordinates.getZ(), value.getKey());
    }

    default public boolean supports(int x, int y, int z, BaseValue<?> value) {
        return this.supports(x, y, z, value.getKey());
    }

    default public boolean supports(Vector3i coordinates, Class<? extends DataManipulator<?, ?>> manipulatorClass) {
        return this.supports(coordinates.getX(), coordinates.getY(), coordinates.getZ(), manipulatorClass);
    }

    public boolean supports(int var1, int var2, int var3, Class<? extends DataManipulator<?, ?>> var4);

    default public boolean supports(Vector3i coordinates, DataManipulator<?, ?> manipulator) {
        return this.supports(coordinates.getX(), coordinates.getY(), coordinates.getZ(), manipulator.getClass());
    }

    default public boolean supports(int x, int y, int z, DataManipulator<?, ?> manipulator) {
        return this.supports(x, y, z, manipulator.getClass());
    }

    default public Set<Key<?>> getKeys(Vector3i coordinates) {
        return this.getKeys(coordinates.getX(), coordinates.getY(), coordinates.getZ());
    }

    public Set<Key<?>> getKeys(int var1, int var2, int var3);

    default public Set<ImmutableValue<?>> getValues(Vector3i coordinates) {
        return this.getValues(coordinates.getX(), coordinates.getY(), coordinates.getZ());
    }

    public Set<ImmutableValue<?>> getValues(int var1, int var2, int var3);

    default public <E> DataTransactionResult transform(Vector3i coordinates, Key<? extends BaseValue<E>> key, Function<E, E> function) {
        return this.transform(coordinates.getX(), coordinates.getY(), coordinates.getZ(), key, function);
    }

    default public <E> DataTransactionResult transform(int x, int y, int z, Key<? extends BaseValue<E>> key, Function<E, E> function) {
        Optional<E> optional;
        if (this.supports(x, y, z, key) && (optional = this.get(x, y, z, key)).isPresent()) {
            return this.offer(x, y, z, key, function.apply(optional.get()));
        }
        return DataTransactionResult.failNoData();
    }

    default public <E> DataTransactionResult offer(Vector3i coordinates, Key<? extends BaseValue<E>> key, E value) {
        return this.offer(coordinates.getX(), coordinates.getY(), coordinates.getZ(), key, value);
    }

    public <E> DataTransactionResult offer(int var1, int var2, int var3, Key<? extends BaseValue<E>> var4, E var5);

    default public <E> DataTransactionResult offer(Vector3i coordinates, BaseValue<E> value) {
        return this.offer(coordinates.getX(), coordinates.getY(), coordinates.getZ(), value.getKey(), value.get());
    }

    default public <E> DataTransactionResult offer(int x, int y, int z, BaseValue<E> value) {
        return this.offer(x, y, z, value.getKey(), value.get());
    }

    default public DataTransactionResult offer(Vector3i coordinates, DataManipulator<?, ?> manipulator) {
        return this.offer(coordinates.getX(), coordinates.getY(), coordinates.getZ(), manipulator, MergeFunction.IGNORE_ALL);
    }

    default public DataTransactionResult offer(int x, int y, int z, DataManipulator<?, ?> manipulator) {
        return this.offer(x, y, z, manipulator, MergeFunction.IGNORE_ALL);
    }

    default public DataTransactionResult offer(Vector3i coordinates, DataManipulator<?, ?> manipulator, MergeFunction function) {
        return this.offer(coordinates.getX(), coordinates.getY(), coordinates.getZ(), manipulator, function);
    }

    public DataTransactionResult offer(int var1, int var2, int var3, DataManipulator<?, ?> var4, MergeFunction var5);

    default public DataTransactionResult offer(Vector3i coordinates, Iterable<DataManipulator<?, ?>> manipulators) {
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (DataManipulator<?, ?> manipulator : manipulators) {
            builder.absorbResult(this.offer(coordinates.getX(), coordinates.getY(), coordinates.getZ(), manipulator, MergeFunction.IGNORE_ALL));
        }
        return builder.build();
    }

    default public DataTransactionResult offer(int x, int y, int z, Iterable<DataManipulator<?, ?>> manipulators) {
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (DataManipulator<?, ?> manipulator : manipulators) {
            builder.absorbResult(this.offer(x, y, z, manipulator, MergeFunction.IGNORE_ALL));
        }
        return builder.build();
    }

    default public DataTransactionResult offer(Vector3i blockPosition, Iterable<DataManipulator<?, ?>> values, MergeFunction function) {
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (DataManipulator<?, ?> manipulator : values) {
            builder.absorbResult(this.offer(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ(), manipulator, function));
        }
        return builder.build();
    }

    default public DataTransactionResult remove(Vector3i coordinates, Class<? extends DataManipulator<?, ?>> manipulatorClass) {
        return this.remove(coordinates.getX(), coordinates.getY(), coordinates.getZ(), manipulatorClass);
    }

    public DataTransactionResult remove(int var1, int var2, int var3, Class<? extends DataManipulator<?, ?>> var4);

    default public DataTransactionResult remove(Vector3i coordinates, Key<?> key) {
        return this.remove(coordinates.getX(), coordinates.getY(), coordinates.getZ(), key);
    }

    public DataTransactionResult remove(int var1, int var2, int var3, Key<?> var4);

    default public DataTransactionResult undo(Vector3i coordinates, DataTransactionResult result) {
        return this.undo(coordinates.getX(), coordinates.getY(), coordinates.getZ(), result);
    }

    public DataTransactionResult undo(int var1, int var2, int var3, DataTransactionResult var4);

    default public DataTransactionResult copyFrom(Vector3i to, DataHolder from) {
        return this.copyFrom(to.getX(), to.getY(), to.getZ(), from);
    }

    public DataTransactionResult copyFrom(int var1, int var2, int var3, DataHolder var4);

    default public DataTransactionResult copyFrom(Vector3i coordinatesTo, Vector3i coordinatesFrom) {
        return this.copyFrom(coordinatesTo.getX(), coordinatesTo.getY(), coordinatesTo.getZ(), coordinatesFrom.getX(), coordinatesFrom.getY(), coordinatesFrom.getZ(), MergeFunction.IGNORE_ALL);
    }

    default public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, int xFrom, int yFrom, int zFrom) {
        return this.copyFrom(xTo, yTo, zTo, xFrom, yFrom, zFrom, MergeFunction.IGNORE_ALL);
    }

    default public DataTransactionResult copyFrom(Vector3i to, DataHolder from, MergeFunction function) {
        return this.copyFrom(to.getX(), to.getY(), to.getZ(), from, function);
    }

    public DataTransactionResult copyFrom(int var1, int var2, int var3, DataHolder var4, MergeFunction var5);

    default public DataTransactionResult copyFrom(Vector3i coordinatesTo, Vector3i coordinatesFrom, MergeFunction function) {
        return this.copyFrom(coordinatesTo.getX(), coordinatesTo.getY(), coordinatesTo.getZ(), coordinatesFrom.getX(), coordinatesFrom.getY(), coordinatesFrom.getZ(), function);
    }

    public DataTransactionResult copyFrom(int var1, int var2, int var3, int var4, int var5, int var6, MergeFunction var7);

    default public Collection<DataManipulator<?, ?>> getManipulators(Vector3i coordinates) {
        return this.getManipulators(coordinates.getX(), coordinates.getY(), coordinates.getZ());
    }

    public Collection<DataManipulator<?, ?>> getManipulators(int var1, int var2, int var3);

    default public boolean validateRawData(Vector3i position, DataView container) {
        return this.validateRawData(position.getX(), position.getY(), position.getZ(), container);
    }

    public boolean validateRawData(int var1, int var2, int var3, DataView var4);

    default public void setRawData(Vector3i position, DataView container) throws InvalidDataException {
        this.setRawData(position.getX(), position.getY(), position.getZ(), container);
    }

    public void setRawData(int var1, int var2, int var3, DataView var4) throws InvalidDataException;
}

