/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.permission;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.NodeTree;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;

public class MemorySubjectData
implements SubjectData {
    private final PermissionService service;
    private final ConcurrentMap<Set<Context>, Map<String, String>> options = Maps.newConcurrentMap();
    private final ConcurrentMap<Set<Context>, NodeTree> permissions = Maps.newConcurrentMap();
    private final ConcurrentMap<Set<Context>, List<Map.Entry<String, String>>> parents = Maps.newConcurrentMap();

    public MemorySubjectData(PermissionService service) {
        Preconditions.checkNotNull((Object)service, (Object)"service");
        this.service = service;
    }

    @Override
    public Map<Set<Context>, Map<String, Boolean>> getAllPermissions() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry ent : this.permissions.entrySet()) {
            ret.put(ent.getKey(), ((NodeTree)ent.getValue()).asMap());
        }
        return ret.build();
    }

    public NodeTree getNodeTree(Set<Context> contexts) {
        NodeTree perms = (NodeTree)this.permissions.get(contexts);
        return perms == null ? NodeTree.of(Collections.emptyMap()) : perms;
    }

    @Override
    public Map<String, Boolean> getPermissions(Set<Context> contexts) {
        NodeTree perms = (NodeTree)this.permissions.get(contexts);
        return perms == null ? Collections.emptyMap() : perms.asMap();
    }

    @Override
    public CompletableFuture<Boolean> setPermission(Set<Context> contexts, String permission, Tristate value) {
        NodeTree oldTree;
        contexts = ImmutableSet.copyOf(contexts);
        do {
            if ((oldTree = (NodeTree)this.permissions.get(contexts)) == null || oldTree.get(permission) != value) continue;
            return CompletableFuture.completedFuture(false);
        } while (!(oldTree == null && value != Tristate.UNDEFINED ? this.permissions.putIfAbsent((Set<Context>)contexts, NodeTree.of((Map<String, Boolean>)ImmutableMap.of((Object)permission, (Object)value.asBoolean()))) == null : oldTree == null || this.permissions.replace((Set<Context>)contexts, oldTree, oldTree.withValue(permission, value))));
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions() {
        boolean wasEmpty = this.permissions.isEmpty();
        this.permissions.clear();
        return CompletableFuture.completedFuture(!wasEmpty);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions(Set<Context> context) {
        return CompletableFuture.completedFuture(this.permissions.remove(context) != null);
    }

    @Override
    public Map<Set<Context>, List<SubjectReference>> getAllParents() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry ent : this.parents.entrySet()) {
            ret.put(ent.getKey(), this.toSubjectList((List)ent.getValue()));
        }
        return ret.build();
    }

    List<SubjectReference> toSubjectList(List<Map.Entry<String, String>> parents) {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (Map.Entry<String, String> ent : parents) {
            ret.add((Object)this.service.newSubjectReference(ent.getKey(), ent.getValue()));
        }
        return ret.build();
    }

    @Override
    public List<SubjectReference> getParents(Set<Context> contexts) {
        List ret = (List)this.parents.get(contexts);
        return ret == null ? Collections.emptyList() : this.toSubjectList(ret);
    }

    @Override
    public CompletableFuture<Boolean> addParent(Set<Context> contexts, SubjectReference parent) {
        ImmutableList newParents;
        List oldParents;
        contexts = ImmutableSet.copyOf(contexts);
        do {
            Map.Entry newEnt = Maps.immutableEntry((Object)parent.getCollectionIdentifier(), (Object)parent.getSubjectIdentifier());
            oldParents = (List)this.parents.get(contexts);
            newParents = ImmutableList.builder().addAll((Iterable)(oldParents == null ? Collections.emptyList() : oldParents)).add((Object)newEnt).build();
            if (oldParents == null || !oldParents.contains(newEnt)) continue;
            return CompletableFuture.completedFuture(false);
        } while (!this.updateCollection(this.parents, contexts, oldParents, newParents));
        return CompletableFuture.completedFuture(true);
    }

    private <K, V> boolean updateCollection(ConcurrentMap<K, V> collection, K key, @Nullable V oldValue, V newValue) {
        return oldValue == null ? collection.putIfAbsent(key, newValue) == null : collection.replace(key, oldValue, newValue);
    }

    @Override
    public CompletableFuture<Boolean> removeParent(Set<Context> contexts, SubjectReference parent) {
        ArrayList newParents;
        List oldParents;
        contexts = ImmutableSet.copyOf(contexts);
        do {
            Map.Entry removeEnt = Maps.immutableEntry((Object)parent.getCollectionIdentifier(), (Object)parent.getSubjectIdentifier());
            oldParents = (List)this.parents.get(contexts);
            if (oldParents == null || !oldParents.contains(removeEnt)) {
                return CompletableFuture.completedFuture(false);
            }
            newParents = new ArrayList(oldParents);
            newParents.remove(removeEnt);
        } while (!this.updateCollection(this.parents, contexts, oldParents, Collections.unmodifiableList(newParents)));
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearParents() {
        boolean wasEmpty = this.parents.isEmpty();
        this.parents.clear();
        return CompletableFuture.completedFuture(!wasEmpty);
    }

    @Override
    public CompletableFuture<Boolean> clearParents(Set<Context> contexts) {
        return CompletableFuture.completedFuture(this.parents.remove(contexts) != null);
    }

    @Override
    public Map<Set<Context>, Map<String, String>> getAllOptions() {
        return ImmutableMap.copyOf(this.options);
    }

    @Override
    public Map<String, String> getOptions(Set<Context> contexts) {
        Map ret = (Map)this.options.get(contexts);
        return ret == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)ret);
    }

    @Override
    public CompletableFuture<Boolean> setOption(Set<Context> contexts, String key, @Nullable String value) {
        Map<String, String> newMap;
        Map<String, String> origMap = (Map<String, String>)this.options.get(contexts);
        if (origMap == null) {
            if (value == null) {
                return CompletableFuture.completedFuture(false);
            }
            origMap = this.options.putIfAbsent((Set<Context>)ImmutableSet.copyOf(contexts), (Map<String, String>)ImmutableMap.of((Object)key.toLowerCase(), (Object)value));
            if (origMap == null) {
                return CompletableFuture.completedFuture(true);
            }
        }
        do {
            if (value == null) {
                if (!origMap.containsKey(key)) {
                    return CompletableFuture.completedFuture(false);
                }
                newMap = new HashMap();
                newMap.putAll(origMap);
                newMap.remove(key);
                continue;
            }
            newMap = new HashMap<String, String>();
            newMap.putAll(origMap);
            newMap.put(key, value);
        } while (!this.options.replace(contexts, origMap, newMap = Collections.unmodifiableMap(newMap)));
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions(Set<Context> contexts) {
        return CompletableFuture.completedFuture(this.options.remove(contexts) != null);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions() {
        this.options.clear();
        return CompletableFuture.completedFuture(true);
    }
}

