/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.profile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.api.util.Identifiable;

public interface GameProfile
extends Identifiable,
DataSerializable {
    public static GameProfile of(UUID uniqueId) {
        return GameProfile.of(uniqueId, null);
    }

    public static GameProfile of(UUID uniqueId, @Nullable String name) {
        return Sponge.getServer().getGameProfileManager().createProfile(uniqueId, name);
    }

    public Optional<String> getName();

    public Multimap<String, ProfileProperty> getPropertyMap();

    default public GameProfile addProperty(ProfileProperty property) {
        Preconditions.checkNotNull((Object)property, (Object)"property");
        return this.addProperty(property.getName(), property);
    }

    default public GameProfile addProperty(String name, ProfileProperty property) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)property, (Object)"property");
        this.getPropertyMap().put((Object)name, (Object)property);
        return this;
    }

    default public boolean removeProperty(ProfileProperty property) {
        Preconditions.checkNotNull((Object)property, (Object)"property");
        return this.getPropertyMap().remove((Object)property.getName(), (Object)property);
    }

    default public boolean removeProperty(String name, ProfileProperty property) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)property, (Object)"property");
        return this.getPropertyMap().remove((Object)name, (Object)property);
    }

    public boolean isFilled();
}

