/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.property;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.item.inventory.InventoryProperty;

public abstract class AbstractInventoryProperty<K, V>
implements InventoryProperty<K, V> {
    private static Map<Class<? extends InventoryProperty>, String> defaultKeys = new HashMap<Class<? extends InventoryProperty>, String>();
    protected final Property.Operator operator;
    private final K key;
    protected V value;

    protected AbstractInventoryProperty() {
        this(null);
    }

    protected AbstractInventoryProperty(@Nullable V value) {
        this(null, value);
    }

    protected AbstractInventoryProperty(@Nullable V value, Property.Operator op) {
        this(null, value, op);
    }

    protected AbstractInventoryProperty(@Nullable K key, @Nullable V value) {
        this(key, value, null);
    }

    protected AbstractInventoryProperty(@Nullable K key, @Nullable V value, Property.Operator op) {
        this.key = key != null ? key : this.getDefaultKey(value);
        this.value = value;
        this.operator = op != null ? op : this.getDefaultOperator(this.key, value);
    }

    protected K getDefaultKey(@Nullable V value) {
        return (K)AbstractInventoryProperty.getDefaultKey(this.getClass());
    }

    public static <T extends InventoryProperty<?, ?>> Object getDefaultKey(Class<T> clazz) {
        return defaultKeys.computeIfAbsent(clazz, k -> k.getSimpleName().toLowerCase(Locale.ENGLISH));
    }

    protected Property.Operator getDefaultOperator(K key, @Nullable V value) {
        return Property.Operator.defaultOperator();
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public Property.Operator getOperator() {
        return this.operator;
    }

    @Override
    public boolean matches(@Nullable Property<?, ?> other) {
        return this.getOperator().compare(this, other);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InventoryProperty)) {
            return false;
        }
        InventoryProperty other = (InventoryProperty)obj;
        return other.getKey().equals(this.getKey()) && other.getValue().equals(this.getValue());
    }

    public int hashCode() {
        return this.hashCodeOf(this.getKey()) ^ this.hashCodeOf(this.getValue()) * 37;
    }

    protected int hashCodeOf(Object value) {
        return value != null ? value.hashCode() : 0;
    }
}

