/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import org.spongepowered.api.event.cause.entity.ModifierFunction;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.util.Tuple;

public abstract class AbstractModifierEvent<T extends ModifierFunction<M>, M>
extends AbstractEvent {
    protected double originalFinalAmount;
    protected List<Tuple<M, Double>> originalModifiers;
    protected Map<M, Double> originalModifierMap;
    protected final LinkedHashMap<M, Double> modifiers = Maps.newLinkedHashMap();
    protected final List<T> modifierFunctions = new ArrayList<T>();

    protected ImmutableList<T> init(double originalValue, List<T> originalFunctions) {
        ImmutableList.Builder modifierMapBuilder = ImmutableList.builder();
        ImmutableList.Builder functionListBuilder = ImmutableList.builder();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        double finalDamage = originalValue;
        for (ModifierFunction tuple : originalFunctions) {
            this.modifierFunctions.add(this.convertTuple(tuple.getModifier(), tuple.getFunction()));
            double tempDamage = (Double)Preconditions.checkNotNull((Object)tuple.getFunction().applyAsDouble(finalDamage));
            finalDamage += tempDamage;
            modifierMapBuilder.add(new Tuple(tuple.getModifier(), tempDamage));
            mapBuilder.put(tuple.getModifier(), (Object)tempDamage);
            this.modifiers.put(tuple.getModifier(), tempDamage);
            functionListBuilder.add(this.convertTuple(tuple.getModifier(), tuple.getFunction()));
        }
        this.originalFinalAmount = finalDamage;
        this.originalModifiers = modifierMapBuilder.build();
        this.originalModifierMap = mapBuilder.build();
        return functionListBuilder.build();
    }

    protected abstract T convertTuple(M var1, DoubleUnaryOperator var2);

    protected void recalculateDamages(double baseAmount) {
        double tempAmount = baseAmount;
        this.modifiers.clear();
        for (ModifierFunction entry : this.modifierFunctions) {
            double modifierAmount = (Double)Preconditions.checkNotNull((Object)entry.getFunction().applyAsDouble(tempAmount));
            if (this.modifiers.containsKey(entry.getModifier())) {
                double oldAmount = this.modifiers.get(entry.getModifier());
                double difference = oldAmount - modifierAmount;
                if (oldAmount > 0.0) {
                    this.modifiers.put(entry.getModifier(), Math.max(0.0, oldAmount - difference));
                } else {
                    this.modifiers.put(entry.getModifier(), Math.min(0.0, oldAmount - difference));
                }
            } else {
                this.modifiers.put(entry.getModifier(), modifierAmount);
            }
            tempAmount += modifierAmount;
        }
    }

    protected double getFinalAmount(double baseAmount) {
        double damage = baseAmount;
        for (ModifierFunction entry : this.modifierFunctions) {
            damage += ((Double)Preconditions.checkNotNull((Object)entry.getFunction().applyAsDouble(damage))).doubleValue();
        }
        return damage;
    }

    public List<T> getModifiers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModifierFunction entry : this.modifierFunctions) {
            builder.add((Object)entry);
        }
        return builder.build();
    }
}

