/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity.living;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.entity.DamageableData;
import org.spongepowered.api.data.manipulator.mutable.entity.HealthData;
import org.spongepowered.api.data.property.entity.EyeLocationProperty;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.scoreboard.TeamMember;

public interface Living
extends Entity,
ProjectileSource,
TeamMember {
    default public HealthData getHealthData() {
        return this.get(HealthData.class).get();
    }

    default public MutableBoundedValue<Double> health() {
        return this.getValue(Keys.HEALTH).get();
    }

    default public MutableBoundedValue<Double> maxHealth() {
        return this.getValue(Keys.MAX_HEALTH).get();
    }

    default public DamageableData getDamageableData() {
        return this.get(DamageableData.class).get();
    }

    default public OptionalValue<EntitySnapshot> lastAttacker() {
        return this.getValue(Keys.LAST_ATTACKER).get();
    }

    default public OptionalValue<Double> lastDamage() {
        return this.getValue(Keys.LAST_DAMAGE).get();
    }

    public Vector3d getHeadRotation();

    public void setHeadRotation(Vector3d var1);

    default public void lookAt(Vector3d targetPos) {
        Vector2d xz2;
        Vector3d eyePos = (Vector3d)this.getProperty(EyeLocationProperty.class).get().getValue();
        if (eyePos == null) {
            return;
        }
        Vector2d xz1 = eyePos.toVector2(true);
        double distance = xz1.distance(xz2 = targetPos.toVector2(true));
        if (distance == 0.0) {
            return;
        }
        Vector2d p1 = Vector2d.UNIT_Y.mul(eyePos.getY());
        Vector2d p2 = new Vector2d(distance, targetPos.getY());
        Vector2d v1 = p2.sub(p1);
        Vector2d v2 = Vector2d.UNIT_X.mul(distance);
        double pitchRad = Math.acos(v1.dot(v2) / (v1.length() * v2.length()));
        double pitchDeg = pitchRad * 180.0 / Math.PI * (-v1.getY() / Math.abs(v1.getY()));
        p1 = xz1;
        p2 = xz2;
        v1 = p2.sub(p1);
        v2 = Vector2d.UNIT_Y.mul(v1.getY());
        double yawRad = Math.acos(v1.dot(v2) / (v1.length() * v2.length()));
        double yawDeg = yawRad * 180.0 / Math.PI;
        if (v1.getX() < 0.0 && v1.getY() < 0.0) {
            yawDeg = 180.0 - yawDeg;
        } else if (v1.getX() > 0.0 && v1.getY() < 0.0) {
            yawDeg = 270.0 - (90.0 - yawDeg);
        } else if (v1.getX() > 0.0 && v1.getY() > 0.0) {
            yawDeg = 270.0 + (90.0 - yawDeg);
        }
        this.setHeadRotation(new Vector3d(pitchDeg, yawDeg, this.getHeadRotation().getZ()));
        this.setRotation(new Vector3d(pitchDeg, yawDeg, this.getRotation().getZ()));
    }
}

