/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.mutable.common;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;

public abstract class AbstractSingleData<T, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractData<M, I> {
    protected final Key<? extends BaseValue<T>> usedKey;
    protected final T defaultValue;
    protected T value;

    @Deprecated
    protected AbstractSingleData(T value, Key<? extends BaseValue<T>> usedKey) {
        this(usedKey, value, value);
    }

    protected AbstractSingleData(Key<? extends Value<T>> usedKey, T value) {
        this(usedKey, value, value);
    }

    protected AbstractSingleData(Key<? extends Value<T>> usedKey, T value, T defaultValue) {
        this.usedKey = (Key)Preconditions.checkNotNull(usedKey, (Object)"usedKey");
        this.value = Preconditions.checkNotNull(value, (Object)"value");
        this.defaultValue = Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
        this.registerGettersAndSetters();
    }

    @Override
    protected final void registerGettersAndSetters() {
        this.registerFieldGetter(this.usedKey, this::getValue);
        this.registerFieldSetter(this.usedKey, this::setValue);
        this.registerKeyValue(this.usedKey, this::getValueGetter);
    }

    protected abstract Value<?> getValueGetter();

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        return key == this.usedKey ? Optional.of(this.value) : super.get(key);
    }

    @Override
    public boolean supports(Key<?> key) {
        return Preconditions.checkNotNull(key) == this.usedKey;
    }

    @Override
    public abstract I asImmutable();

    protected T getValue() {
        return this.value;
    }

    protected M setValue(T value) {
        this.value = Preconditions.checkNotNull(value);
        return (M)this;
    }

    @Override
    protected DataContainer fillContainer(DataContainer dataContainer) {
        return dataContainer.set(this.usedKey.getQuery(), this.getValue());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Objects.hashCode(this.value);
        hash = 31 * hash + Objects.hashCode(this.defaultValue);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AbstractSingleData other = (AbstractSingleData)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.defaultValue, other.defaultValue);
    }
}

