/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.noise.module.combiner.selector;

import com.flowpowered.noise.Utils;
import com.flowpowered.noise.module.Module;
import com.flowpowered.noise.module.combiner.selector.Selector;

public class Select
extends Selector {
    public static final double DEFAULT_EDGE_FALLOFF = 0.0;
    public static final double DEFAULT_LOWER_BOUND = -1.0;
    public static final double DEFAULT_UPPER_BOUND = 1.0;
    private final double edgeFalloff;
    private final double lowerBound;
    private final double upperBound;

    public Select(Module control, Module sourceA, Module sourceB, double edgeFalloff, double lowerBound, double upperBound) {
        super(control, sourceA, sourceB);
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lower must be less than upper");
        }
        double boundSize = upperBound - lowerBound;
        this.edgeFalloff = edgeFalloff > boundSize / 2.0 ? boundSize / 2.0 : edgeFalloff;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public double getEdgeFalloff() {
        return this.edgeFalloff;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    @Override
    public double getValue(double x, double y, double z) {
        double controlValue = this.control.getValue(x, y, z);
        if (this.edgeFalloff > 0.0) {
            if (controlValue < this.lowerBound - this.edgeFalloff) {
                return this.sourceA.getValue(x, y, z);
            }
            if (controlValue < this.lowerBound + this.edgeFalloff) {
                double lowerCurve = this.lowerBound - this.edgeFalloff;
                double upperCurve = this.lowerBound + this.edgeFalloff;
                double alpha = Utils.sCurve3((controlValue - lowerCurve) / (upperCurve - lowerCurve));
                return Utils.linearInterp(this.sourceA.getValue(x, y, z), this.sourceB.getValue(x, y, z), alpha);
            }
            if (controlValue < this.upperBound - this.edgeFalloff) {
                return this.sourceB.getValue(x, y, z);
            }
            if (controlValue < this.upperBound + this.edgeFalloff) {
                double lowerCurve = this.upperBound - this.edgeFalloff;
                double upperCurve = this.upperBound + this.edgeFalloff;
                double alpha = Utils.sCurve3((controlValue - lowerCurve) / (upperCurve - lowerCurve));
                return Utils.linearInterp(this.sourceB.getValue(x, y, z), this.sourceA.getValue(x, y, z), alpha);
            }
            return this.sourceA.getValue(x, y, z);
        }
        if (controlValue < this.lowerBound || controlValue > this.upperBound) {
            return this.sourceA.getValue(x, y, z);
        }
        return this.sourceB.getValue(x, y, z);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Selector.Builder {
        private double edgeFalloff = 0.0;
        private double lowerBound = 1.0;
        private double upperBound = -1.0;

        public double getEdgeFalloff() {
            return this.edgeFalloff;
        }

        public double getLowerBound() {
            return this.lowerBound;
        }

        public double getUpperBound() {
            return this.upperBound;
        }

        public Builder setEdgeFalloff(double edgeFalloff) {
            this.edgeFalloff = edgeFalloff;
            return this;
        }

        public Builder setLowerBound(double lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        public Builder setUpperBound(double upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        public Builder setBounds(double lowerBound, double upperBound) {
            this.setLowerBound(lowerBound);
            this.setUpperBound(upperBound);
            return this;
        }

        @Override
        public Builder setSourceA(Module sourceA) {
            super.setSourceA(sourceA);
            return this;
        }

        @Override
        public Builder setSourceB(Module sourceA) {
            super.setSourceA(sourceA);
            return this;
        }

        @Override
        public Builder setSources(Module sourceA, Module sourceB) {
            super.setSources(sourceA, sourceB);
            return this;
        }

        @Override
        public Builder setControl(Module control) {
            this.control = control;
            return this;
        }

        @Override
        protected void checkValues() throws IllegalStateException {
            super.checkValues();
            if (this.lowerBound > this.upperBound) {
                throw new IllegalStateException("Lower bound must be less than upper bound");
            }
        }

        @Override
        public Select build() throws IllegalStateException {
            this.checkValues();
            return new Select(this.control, this.sourceA, this.sourceB, this.edgeFalloff, this.lowerBound, this.upperBound);
        }
    }
}

