/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.SpongeTimingsFactory;
import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import java.lang.reflect.Method;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;

public class TimedEventListener<T extends Event>
implements EventListener<T> {
    private final EventListener<T> listener;
    private final Timing timings;

    public TimedEventListener(EventListener<T> listener, PluginContainer plugin, Method method, Class<? extends Event> eventClass) {
        this.listener = listener;
        if (method == null) {
            method = listener.getClass().getEnclosingMethod();
        }
        String id = method.getDeclaringClass().getName();
        this.timings = SpongeTimingsFactory.ofSafe(plugin.getId(), "Event: " + id + " (" + eventClass.getSimpleName() + ")", null);
    }

    @Override
    public void handle(T event) throws Exception {
        if (!Timings.isTimingsEnabled() || !SpongeImpl.getServer().func_152345_ab()) {
            this.listener.handle(event);
            return;
        }
        this.timings.startTiming();
        this.listener.handle(event);
        this.timings.stopTiming();
    }
}

