/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.CertificateHelper;
import net.minecraftforge.fml.common.DuplicateModsFoundException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.MCPDummyContainer;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.MinecraftDummyContainer;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.MultipleModsErrored;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.WrongMinecraftVersionException;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.registry.ItemStackHolderInjector;
import net.minecraftforge.fml.common.toposort.ModSorter;
import net.minecraftforge.fml.common.toposort.ModSortingException;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DependencyParser;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import net.minecraftforge.fml.relauncher.libraries.Repository;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.ObjectHolderRegistry;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public class Loader {
    public static final String MC_VERSION = "1.12.2";
    private static Loader instance;
    private static String major;
    private static String minor;
    private static String rev;
    private static String build;
    private static String mccversion;
    private static String mcpversion;
    private ModClassLoader modClassLoader;
    private List<ModContainer> mods;
    private Map<String, ModContainer> namedMods;
    private ListMultimap<String, String> reverseDependencies;
    private File canonicalConfigDir;
    private File canonicalModsDir;
    private LoadController modController;
    private MinecraftDummyContainer minecraft;
    private MCPDummyContainer mcp;
    private static File minecraftDir;
    private static List<String> injectedContainers;
    private ImmutableMap<String, String> fmlBrandingProperties;
    private File forcedModFile;
    private ModDiscoverer discoverer;
    private ProgressManager.ProgressBar progressBar;
    private ListMultimap<String, ArtifactVersion> injectedBefore = ArrayListMultimap.create();
    private ListMultimap<String, ArtifactVersion> injectedAfter = ArrayListMultimap.create();

    public static Loader instance() {
        if (instance == null) {
            instance = new Loader();
        }
        return instance;
    }

    public static void injectData(Object ... data) {
        major = (String)data[0];
        minor = (String)data[1];
        rev = (String)data[2];
        build = (String)data[3];
        mccversion = (String)data[4];
        mcpversion = (String)data[5];
        minecraftDir = (File)data[6];
        injectedContainers = (List)data[7];
    }

    private Loader() {
        this.modClassLoader = new ModClassLoader(this.getClass().getClassLoader());
        if (mccversion != null && !mccversion.equals(MC_VERSION)) {
            FMLLog.log.fatal("This version of FML is built for Minecraft {}, we have detected Minecraft {} in your minecraft jar file", (Object)mccversion, (Object)MC_VERSION);
            throw new LoaderException(String.format("This version of FML is built for Minecraft %s, we have detected Minecraft %s in your minecraft jar file", mccversion, MC_VERSION));
        }
        this.minecraft = new MinecraftDummyContainer(MC_VERSION);
        InputStream mcpModInputStream = this.getClass().getResourceAsStream("/mcpmod.info");
        try {
            this.mcp = new MCPDummyContainer(MetadataCollection.from(mcpModInputStream, "MCP").getMetadataForId("mcp", null));
        }
        finally {
            IOUtils.closeQuietly((InputStream)mcpModInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortModList() {
        FMLLog.log.trace("Verifying mod requirements are satisfied");
        ArrayList<WrongMinecraftVersionException> wrongMinecraftExceptions = new ArrayList<WrongMinecraftVersionException>();
        ArrayList<MissingModsException> missingModsExceptions = new ArrayList<MissingModsException>();
        try {
            HashBiMap modVersions = HashBiMap.create();
            for (ModContainer modContainer : Iterables.concat(this.getActiveModList(), ModAPIManager.INSTANCE.getAPIList())) {
                modVersions.put((Object)modContainer.getModId(), (Object)modContainer.getProcessedVersion());
            }
            ArrayListMultimap reqList = ArrayListMultimap.create();
            for (ModContainer mod : this.getActiveModList()) {
                if (!mod.acceptableMinecraftVersionRange().containsVersion(this.minecraft.getProcessedVersion())) {
                    FMLLog.log.fatal("The mod {} does not wish to run in Minecraft version {}. You will have to remove it to play.", (Object)mod.getModId(), (Object)this.getMCVersionString());
                    WrongMinecraftVersionException ret = new WrongMinecraftVersionException(mod, this.getMCVersionString());
                    FMLLog.log.fatal(ret.getMessage());
                    wrongMinecraftExceptions.add(ret);
                    continue;
                }
                reqList.putAll((Object)mod.getModId(), Iterables.transform(mod.getRequirements(), ArtifactVersion::getLabel));
                HashSet allDeps = Sets.newHashSet();
                allDeps.addAll(mod.getDependants());
                allDeps.addAll(mod.getDependencies());
                allDeps.addAll(mod.getRequirements());
                MissingModsException missingModsException = new MissingModsException(mod.getModId(), mod.getName());
                for (ArtifactVersion acceptedVersion : allDeps) {
                    ArtifactVersion currentVersion;
                    boolean required = mod.getRequirements().contains(acceptedVersion);
                    if (!required && !modVersions.containsKey((Object)acceptedVersion.getLabel()) || (currentVersion = (ArtifactVersion)modVersions.get((Object)acceptedVersion.getLabel())) != null && acceptedVersion.containsVersion(currentVersion)) continue;
                    missingModsException.addMissingMod(acceptedVersion, currentVersion, required);
                }
                if (missingModsException.getMissingModInfos().isEmpty()) continue;
                FMLLog.log.fatal(missingModsException.toString());
                missingModsExceptions.add(missingModsException);
            }
            if (!wrongMinecraftExceptions.isEmpty() || !missingModsExceptions.isEmpty()) {
                if (missingModsExceptions.size() == 1 && wrongMinecraftExceptions.isEmpty()) {
                    throw (MissingModsException)missingModsExceptions.get(0);
                }
                if (wrongMinecraftExceptions.size() == 1 && missingModsExceptions.isEmpty()) {
                    throw (WrongMinecraftVersionException)wrongMinecraftExceptions.get(0);
                }
                throw new MultipleModsErrored(wrongMinecraftExceptions, missingModsExceptions);
            }
            FMLLog.log.trace("All mod requirements are satisfied");
            this.reverseDependencies = (ListMultimap)Multimaps.invertFrom((Multimap)reqList, (Multimap)ArrayListMultimap.create());
            ModSorter modSorter = new ModSorter(this.getActiveModList(), this.namedMods);
            try {
                FMLLog.log.trace("Sorting mods into an ordered list");
                List<ModContainer> sortedMods = modSorter.sort();
                this.modController.getActiveModList().clear();
                this.modController.getActiveModList().addAll(sortedMods);
                this.mods.removeAll(sortedMods);
                sortedMods.addAll(this.mods);
                this.mods = sortedMods;
                FMLLog.log.trace("Mod sorting completed successfully");
            }
            catch (ModSortingException sortException) {
                FMLLog.log.fatal("A dependency cycle was detected in the input mod set so an ordering cannot be determined");
                ModSortingException.SortingExceptionData exceptionData = sortException.getExceptionData();
                FMLLog.log.fatal("The first mod in the cycle is {}", exceptionData.getFirstBadNode());
                FMLLog.log.fatal("The mod cycle involves");
                for (ModContainer mc : exceptionData.getVisitedNodes()) {
                    FMLLog.log.fatal("{} : before: {}, after: {}", (Object)mc.toString(), mc.getDependants(), mc.getDependencies());
                }
                FMLLog.log.error("The full error", (Throwable)sortException);
                throw sortException;
            }
        }
        catch (Throwable throwable) {
            FMLLog.log.debug("Mod sorting data");
            int unprintedMods = this.mods.size();
            for (ModContainer mod : this.getActiveModList()) {
                if (mod.isImmutable()) continue;
                FMLLog.log.debug("\t{}({}:{}): {} ({})", (Object)mod.getModId(), (Object)mod.getName(), (Object)mod.getVersion(), (Object)mod.getSource().getName(), (Object)mod.getSortingRules());
                --unprintedMods;
            }
            if (unprintedMods == this.mods.size()) {
                FMLLog.log.debug("No user mods found to sort");
            }
            throw throwable;
        }
        FMLLog.log.debug("Mod sorting data");
        int unprintedMods = this.mods.size();
        for (ModContainer modContainer : this.getActiveModList()) {
            if (modContainer.isImmutable()) continue;
            FMLLog.log.debug("\t{}({}:{}): {} ({})", (Object)modContainer.getModId(), (Object)modContainer.getName(), (Object)modContainer.getVersion(), (Object)modContainer.getSource().getName(), (Object)modContainer.getSortingRules());
            --unprintedMods;
        }
        if (unprintedMods == this.mods.size()) {
            FMLLog.log.debug("No user mods found to sort");
        }
    }

    private ModDiscoverer identifyMods(List<String> additionalContainers) {
        injectedContainers.addAll(additionalContainers);
        FMLLog.log.debug("Building injected Mod Containers {}", injectedContainers);
        this.mods.add(this.minecraft);
        this.mods.add(new InjectedModContainer(this.mcp, new File("minecraft.jar")));
        for (String cont : injectedContainers) {
            ModContainer mc;
            try {
                mc = (ModContainer)Class.forName(cont, true, this.modClassLoader).newInstance();
            }
            catch (Exception e) {
                FMLLog.log.error("A problem occurred instantiating the injected mod container {}", (Object)cont, (Object)e);
                throw new LoaderException(e);
            }
            this.mods.add(new InjectedModContainer(mc, mc.getSource()));
        }
        ModDiscoverer discoverer = new ModDiscoverer();
        FMLLog.log.debug("Attempting to load mods contained in the minecraft jar file and associated classes");
        discoverer.findClasspathMods(this.modClassLoader);
        FMLLog.log.debug("Minecraft jar mods loaded successfully");
        List<Artifact> maven_canidates = LibraryManager.flattenLists(minecraftDir);
        List<File> file_canidates = LibraryManager.gatherLegacyCanidates(minecraftDir);
        for (Artifact artifact : maven_canidates) {
            File target;
            if ((artifact = Repository.resolveAll(artifact)) == null || file_canidates.contains(target = artifact.getFile())) continue;
            file_canidates.add(target);
        }
        for (File mod : file_canidates) {
            if (CoreModManager.getIgnoredMods().contains(mod.getName())) {
                FMLLog.log.trace("Skipping already parsed coremod or tweaker {}", (Object)mod.getName());
                continue;
            }
            FMLLog.log.debug("Found a candidate zip or jar file {}", (Object)mod.getName());
            discoverer.addCandidate(new ModCandidate(mod, mod, ContainerType.JAR));
        }
        this.mods.addAll(discoverer.identifyMods());
        this.identifyDuplicates(this.mods);
        this.namedMods = Maps.uniqueIndex(this.mods, ModContainer::getModId);
        FMLLog.log.info("Forge Mod Loader has identified {} mod{} to load", (Object)this.mods.size(), (Object)(this.mods.size() != 1 ? "s" : ""));
        return discoverer;
    }

    private void identifyDuplicates(List<ModContainer> mods) {
        TreeMultimap dupsearch = TreeMultimap.create((Comparator)new ModIdComparator(), (Comparator)Ordering.arbitrary());
        for (ModContainer mc : mods) {
            if (mc.getSource() == null) continue;
            dupsearch.put((Object)mc, (Object)mc.getSource());
        }
        ImmutableMultiset duplist = Multisets.copyHighestCountFirst((Multiset)dupsearch.keys());
        LinkedHashMultimap dupes = LinkedHashMultimap.create();
        for (Multiset.Entry e : duplist.entrySet()) {
            if (e.getCount() <= 1) continue;
            FMLLog.log.fatal("Found a duplicate mod {} at {}", (Object)((ModContainer)e.getElement()).getModId(), (Object)dupsearch.get(e.getElement()));
            dupes.putAll(e.getElement(), (Iterable)dupsearch.get(e.getElement()));
        }
        if (!dupes.isEmpty()) {
            throw new DuplicateModsFoundException((SetMultimap<ModContainer, File>)dupes);
        }
    }

    private void initializeLoader() {
        boolean dirMade;
        String canonicalConfigPath;
        String canonicalModsPath;
        File modsDir = new File(minecraftDir, "mods");
        File configDir = new File(minecraftDir, "config");
        try {
            canonicalModsPath = modsDir.getCanonicalPath();
            canonicalConfigPath = configDir.getCanonicalPath();
            this.canonicalConfigDir = configDir.getCanonicalFile();
            this.canonicalModsDir = modsDir.getCanonicalFile();
        }
        catch (IOException ioe) {
            FMLLog.log.error("Failed to resolve loader directories: mods : {} ; config {}", (Object)this.canonicalModsDir.getAbsolutePath(), (Object)configDir.getAbsolutePath(), (Object)ioe);
            throw new LoaderException(ioe);
        }
        if (!this.canonicalModsDir.exists()) {
            FMLLog.log.info("No mod directory found, creating one: {}", (Object)canonicalModsPath);
            dirMade = this.canonicalModsDir.mkdir();
            if (!dirMade) {
                FMLLog.log.fatal("Unable to create the mod directory {}", (Object)canonicalModsPath);
                throw new LoaderException(String.format("Unable to create the mod directory %s", canonicalModsPath));
            }
            FMLLog.log.info("Mod directory created successfully");
        }
        if (!this.canonicalConfigDir.exists()) {
            FMLLog.log.debug("No config directory found, creating one: {}", (Object)canonicalConfigPath);
            dirMade = this.canonicalConfigDir.mkdir();
            if (!dirMade) {
                FMLLog.log.fatal("Unable to create the config directory {}", (Object)canonicalConfigPath);
                throw new LoaderException();
            }
            FMLLog.log.info("Config directory created successfully");
        }
        if (!this.canonicalModsDir.isDirectory()) {
            FMLLog.log.fatal("Attempting to load mods from {}, which is not a directory", (Object)canonicalModsPath);
            throw new LoaderException();
        }
        if (!configDir.isDirectory()) {
            FMLLog.log.fatal("Attempting to load configuration from {}, which is not a directory", (Object)canonicalConfigPath);
            throw new LoaderException();
        }
        this.readInjectedDependencies();
    }

    public List<ModContainer> getModList() {
        return Loader.instance().mods != null ? ImmutableList.copyOf(Loader.instance().mods) : ImmutableList.of();
    }

    public void setupTestHarness(ModContainer ... containers) {
        this.modController = new LoadController(this);
        this.mods = Lists.newArrayList((Object[])containers);
        this.namedMods = Maps.uniqueIndex(this.mods, ModContainer::getModId);
        this.modController.transition(LoaderState.LOADING, false);
        this.modController.transition(LoaderState.CONSTRUCTING, false);
        ObjectHolderRegistry.INSTANCE.findObjectHolders(new ASMDataTable());
        this.modController.forceActiveContainer(containers[0]);
    }

    public void loadMods(List<String> injectedModContainers) {
        this.progressBar = ProgressManager.push("Loading", 7);
        this.progressBar.step("Constructing Mods");
        this.initializeLoader();
        this.mods = Lists.newArrayList();
        this.namedMods = Maps.newHashMap();
        this.modController = new LoadController(this);
        this.modController.transition(LoaderState.LOADING, false);
        this.discoverer = this.identifyMods(injectedModContainers);
        ModAPIManager.INSTANCE.manageAPI(this.modClassLoader, this.discoverer);
        this.disableRequestedMods();
        this.modController.distributeStateMessage(FMLLoadEvent.class);
        this.sortModList();
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.modController.getActiveModList());
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.mods);
        this.mods = ImmutableList.copyOf(this.mods);
        for (File nonMod : this.discoverer.getNonModLibs()) {
            if (!nonMod.isFile()) continue;
            FMLLog.log.info("FML has found a non-mod file {} in your mods directory. It will now be injected into your classpath. This could severe stability issues, it should be removed if possible.", (Object)nonMod.getName());
            try {
                this.modClassLoader.addFile(nonMod);
            }
            catch (MalformedURLException e) {
                FMLLog.log.error("Encountered a weird problem with non-mod file injection : {}", (Object)nonMod.getName(), (Object)e);
            }
        }
        ConfigManager.loadData(this.discoverer.getASMTable());
        this.modController.transition(LoaderState.CONSTRUCTING, false);
        this.modController.distributeStateMessage(LoaderState.CONSTRUCTING, this.modClassLoader, this.discoverer.getASMTable(), this.reverseDependencies);
        FMLLog.log.debug("Mod signature data");
        FMLLog.log.debug(" \tValid Signatures:");
        for (ModContainer mod : this.getActiveModList()) {
            if (mod.getSigningCertificate() == null) continue;
            FMLLog.log.debug("\t\t({}) {}\t({}\t{})\t{}", (Object)CertificateHelper.getFingerprint(mod.getSigningCertificate()), (Object)mod.getModId(), (Object)mod.getName(), (Object)mod.getVersion(), (Object)mod.getSource().getName());
        }
        FMLLog.log.debug(" \tMissing Signatures:");
        for (ModContainer mod : this.getActiveModList()) {
            if (mod.getSigningCertificate() != null) continue;
            FMLLog.log.debug("\t\t{}\t({}\t{})\t{}", (Object)mod.getModId(), (Object)mod.getName(), (Object)mod.getVersion(), (Object)mod.getSource().getName());
        }
        if (this.getActiveModList().isEmpty()) {
            FMLLog.log.debug("No user mod signature data found");
        }
        this.progressBar.step("Initializing mods Phase 1");
        this.modController.transition(LoaderState.PREINITIALIZATION, false);
    }

    public void preinitializeMods() {
        if (!this.modController.isInState(LoaderState.PREINITIALIZATION)) {
            FMLLog.log.warn("There were errors previously. Not beginning mod initialization phase");
            return;
        }
        GameData.fireCreateRegistryEvents();
        ObjectHolderRegistry.INSTANCE.findObjectHolders(this.discoverer.getASMTable());
        ItemStackHolderInjector.INSTANCE.findHolders(this.discoverer.getASMTable());
        CapabilityManager.INSTANCE.injectCapabilities(this.discoverer.getASMTable());
        this.modController.distributeStateMessage(LoaderState.PREINITIALIZATION, this.discoverer.getASMTable(), this.canonicalConfigDir);
        GameData.fireRegistryEvents(rl2 -> !rl2.equals((Object)GameData.RECIPES));
        FMLCommonHandler.instance().fireSidedRegistryEvents();
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        ItemStackHolderInjector.INSTANCE.inject();
        this.modController.transition(LoaderState.INITIALIZATION, false);
        this.progressBar.step("Initializing Minecraft Engine");
    }

    private void disableRequestedMods() {
        String forcedModList = System.getProperty("fml.modStates", "");
        FMLLog.log.trace("Received a system property request '{}'", (Object)forcedModList);
        Map sysPropertyStateList = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)";:")).omitEmptyStrings().trimResults().withKeyValueSeparator("=").split((CharSequence)forcedModList);
        FMLLog.log.trace("System property request managing the state of {} mods", (Object)sysPropertyStateList.size());
        HashMap modStates = Maps.newHashMap();
        this.forcedModFile = new File(this.canonicalConfigDir, "fmlModState.properties");
        Properties forcedModListProperties = new Properties();
        if (this.forcedModFile.exists() && this.forcedModFile.isFile()) {
            FMLLog.log.trace("Found a mod state file {}", (Object)this.forcedModFile.getName());
            try {
                forcedModListProperties.load(new InputStreamReader((InputStream)new FileInputStream(this.forcedModFile), StandardCharsets.UTF_8));
                FMLLog.log.trace("Loaded states for {} mods from file", (Object)forcedModListProperties.size());
            }
            catch (Exception e) {
                FMLLog.log.info("An error occurred reading the fmlModState.properties file", (Throwable)e);
            }
        }
        modStates.putAll(Maps.fromProperties((Properties)forcedModListProperties));
        modStates.putAll(sysPropertyStateList);
        FMLLog.log.debug("After merging, found state information for {} mods", (Object)modStates.size());
        Map isEnabled = Maps.transformValues((Map)modStates, Boolean::parseBoolean);
        for (Map.Entry entry : isEnabled.entrySet()) {
            if (!this.namedMods.containsKey(entry.getKey())) continue;
            FMLLog.log.info("Setting mod {} to enabled state {}", entry.getKey(), entry.getValue());
            this.namedMods.get(entry.getKey()).setEnabledState((Boolean)entry.getValue());
        }
    }

    public static boolean isModLoaded(String modname) {
        return Loader.instance().namedMods.containsKey(modname) && Loader.instance().modController.getModState(Loader.instance.namedMods.get(modname)) != LoaderState.ModState.DISABLED;
    }

    public File getConfigDir() {
        return this.canonicalConfigDir;
    }

    public String getCrashInformation() {
        if (this.modController == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        List<String> branding = FMLCommonHandler.instance().getBrandings(false);
        Joiner.on((char)' ').skipNulls().appendTo(ret, branding);
        if (this.modController != null) {
            this.modController.printModStates(ret);
        }
        return ret.toString();
    }

    public String getFMLVersionString() {
        return "8.0.99.99";
    }

    public ModClassLoader getModClassLoader() {
        return this.modClassLoader;
    }

    @Deprecated
    public void computeDependencies(String dependencyString, Set<ArtifactVersion> requirements, List<ArtifactVersion> dependencies, List<ArtifactVersion> dependants) {
        DependencyParser dependencyParser = new DependencyParser("unknown", FMLCommonHandler.instance().getSide());
        DependencyParser.DependencyInfo info = dependencyParser.parseDependencies(dependencyString);
        requirements.addAll(info.requirements);
        dependencies.addAll(info.dependencies);
        dependants.addAll(info.dependants);
    }

    public Map<String, ModContainer> getIndexedModList() {
        return this.namedMods != null ? ImmutableMap.copyOf(this.namedMods) : ImmutableMap.of();
    }

    public void initializeMods() {
        this.progressBar.step("Initializing mods Phase 2");
        CraftingHelper.loadRecipes(false);
        this.modController.distributeStateMessage(LoaderState.INITIALIZATION, new Object[0]);
        this.progressBar.step("Initializing mods Phase 3");
        this.modController.transition(LoaderState.POSTINITIALIZATION, false);
        this.modController.distributeStateMessage(FMLInterModComms.IMCEvent.class);
        ItemStackHolderInjector.INSTANCE.inject();
        this.modController.distributeStateMessage(LoaderState.POSTINITIALIZATION, new Object[0]);
        this.progressBar.step("Finishing up");
        this.modController.transition(LoaderState.AVAILABLE, false);
        this.modController.distributeStateMessage(LoaderState.AVAILABLE, new Object[0]);
        GameData.freezeData();
        FMLLog.log.info("Forge Mod Loader has successfully loaded {} mod{}", (Object)this.mods.size(), (Object)(this.mods.size() == 1 ? "" : "s"));
        this.progressBar.step("Completing Minecraft initialization");
    }

    public ICrashCallable getCallableCrashInformation() {
        return new ICrashCallable(){

            public String call() throws Exception {
                return Loader.this.getCrashInformation();
            }

            @Override
            public String getLabel() {
                return "FML";
            }
        };
    }

    public List<ModContainer> getActiveModList() {
        return this.modController != null ? this.modController.getActiveModList() : ImmutableList.of();
    }

    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return this.modController.getModState(selectedMod);
    }

    public String getMCVersionString() {
        return "Minecraft " + mccversion;
    }

    public boolean serverStarting(Object server) {
        this.modController.distributeStateMessage(LoaderState.SERVER_STARTING, server);
        this.modController.transition(LoaderState.SERVER_STARTING, false);
        return true;
    }

    public void serverStarted() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STARTED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STARTED, false);
    }

    public void serverStopping() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPING, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPING, false);
    }

    public BiMap<ModContainer, Object> getModObjectList() {
        return this.modController.getModObjectList();
    }

    public BiMap<Object, ModContainer> getReversedModObjectList() {
        return this.getModObjectList().inverse();
    }

    @Nullable
    public ModContainer activeModContainer() {
        return this.modController != null ? this.modController.activeContainer() : null;
    }

    public boolean isInState(LoaderState state) {
        return this.modController.isInState(state);
    }

    public MinecraftDummyContainer getMinecraftModContainer() {
        return this.minecraft;
    }

    public boolean hasReachedState(LoaderState state) {
        return this.modController != null ? this.modController.hasReachedState(state) : false;
    }

    public String getMCPVersionString() {
        return String.format("MCP %s", mcpversion);
    }

    public void serverStopped() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPED, true);
        this.modController.transition(LoaderState.AVAILABLE, true);
    }

    public boolean serverAboutToStart(Object server) {
        this.modController.distributeStateMessage(LoaderState.SERVER_ABOUT_TO_START, server);
        this.modController.transition(LoaderState.SERVER_ABOUT_TO_START, false);
        return true;
    }

    public Map<String, String> getFMLBrandingProperties() {
        if (this.fmlBrandingProperties == null) {
            Properties loaded = new Properties();
            try {
                loaded.load(this.getClass().getClassLoader().getResourceAsStream("fmlbranding.properties"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fmlBrandingProperties = Maps.fromProperties((Properties)loaded);
        }
        return this.fmlBrandingProperties;
    }

    public Map<String, String> getCustomModProperties(String modId) {
        return this.getIndexedModList().get(modId).getCustomModProperties();
    }

    boolean checkRemoteModList(Map<String, String> modList, Side side) {
        Set<String> remoteModIds = modList.keySet();
        Set<String> localModIds = this.namedMods.keySet();
        LinkedHashSet difference = Sets.newLinkedHashSet((Iterable)Sets.difference(localModIds, remoteModIds));
        Iterator iterator = difference.iterator();
        while (iterator.hasNext()) {
            String missingRemotely = (String)iterator.next();
            LoaderState.ModState modState = this.modController.getModState(this.namedMods.get(missingRemotely));
            if (modState != LoaderState.ModState.DISABLED) continue;
            iterator.remove();
        }
        if (difference.size() > 0) {
            FMLLog.log.info("Attempting connection with missing mods {} at {}", (Object)difference, (Object)side);
        }
        return true;
    }

    public void fireRemapEvent(Map<nf, Map<nf, Integer[]>> remaps, boolean isFreezing) {
        if (this.modController != null) {
            this.modController.propogateStateMessage(new FMLModIdMappingEvent(remaps, isFreezing));
        }
    }

    public void runtimeDisableMod(String modId) {
        ModContainer mc = this.namedMods.get(modId);
        ModContainer.Disableable disableable = mc.canBeDisabled();
        if (disableable == ModContainer.Disableable.NEVER) {
            FMLLog.log.info("Cannot disable mod {} - it is never allowed to be disabled", (Object)modId);
            return;
        }
        if (disableable == ModContainer.Disableable.DEPENDENCIES) {
            FMLLog.log.info("Cannot disable mod {} - there are dependent mods that require its presence", (Object)modId);
            return;
        }
        if (disableable == ModContainer.Disableable.YES) {
            FMLLog.log.info("Runtime disabling mod {}", (Object)modId);
            this.modController.disableMod(mc);
            ArrayList localmods = Lists.newArrayList(this.mods);
            localmods.remove(mc);
            this.mods = ImmutableList.copyOf((Collection)localmods);
        }
        try {
            Properties props = new Properties();
            props.load(new InputStreamReader((InputStream)new FileInputStream(this.forcedModFile), StandardCharsets.UTF_8));
            props.put(modId, "false");
            props.store(new OutputStreamWriter((OutputStream)new FileOutputStream(this.forcedModFile), StandardCharsets.UTF_8), null);
        }
        catch (Exception e) {
            FMLLog.log.info("An error occurred writing the fml mod states file, your disabled change won't persist", (Throwable)e);
        }
    }

    public void loadingComplete() {
        ProgressManager.pop(this.progressBar);
        this.progressBar = null;
    }

    private void readInjectedDependencies() {
        File injectedDepFile = new File(this.getConfigDir(), "injectedDependencies.json");
        if (!injectedDepFile.exists()) {
            FMLLog.log.debug("File {} not found. No dependencies injected", (Object)injectedDepFile.getAbsolutePath());
            return;
        }
        JsonParser parser = new JsonParser();
        try {
            JsonElement injectedDeps = parser.parse((Reader)new InputStreamReader((InputStream)new FileInputStream(injectedDepFile), StandardCharsets.UTF_8));
            for (JsonElement el : injectedDeps.getAsJsonArray()) {
                JsonObject jo = el.getAsJsonObject();
                String modId = jo.get("modId").getAsString();
                JsonArray deps = jo.get("deps").getAsJsonArray();
                for (JsonElement dep : deps) {
                    JsonObject depObj = dep.getAsJsonObject();
                    String type = depObj.get("type").getAsString();
                    if (type.equals("before")) {
                        this.injectedBefore.put((Object)modId, (Object)VersionParser.parseVersionReference(depObj.get("target").getAsString()));
                        continue;
                    }
                    if (type.equals("after")) {
                        this.injectedAfter.put((Object)modId, (Object)VersionParser.parseVersionReference(depObj.get("target").getAsString()));
                        continue;
                    }
                    FMLLog.log.error("Invalid dependency type {}", (Object)type);
                    throw new RuntimeException("Unable to parse type");
                }
            }
        }
        catch (Exception e) {
            FMLLog.log.error("Unable to parse {} - skipping", (Object)injectedDepFile);
            FMLLog.log.throwing(Level.ERROR, (Throwable)e);
            return;
        }
        FMLLog.log.debug("Loaded {} injected dependencies on modIds: {}", (Object)this.injectedBefore.size(), (Object)this.injectedBefore.keySet());
    }

    List<ArtifactVersion> getInjectedBefore(String modId) {
        return this.injectedBefore.get((Object)modId);
    }

    List<ArtifactVersion> getInjectedAfter(String modId) {
        return this.injectedAfter.get((Object)modId);
    }

    public final LoaderState getLoaderState() {
        return this.modController != null ? this.modController.getState() : LoaderState.NOINIT;
    }

    public void setActiveModContainer(@Nullable ModContainer container) {
        this.modController.forceActiveContainer(container);
    }

    private class ModIdComparator
    implements Comparator<ModContainer> {
        private ModIdComparator() {
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            return o1.getModId().compareTo(o2.getModId());
        }
    }
}

