/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.templates;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerFluidMap
implements IFluidHandler {
    protected final Map<Fluid, IFluidHandler> handlers;

    public FluidHandlerFluidMap() {
        this(new LinkedHashMap<Fluid, IFluidHandler>());
    }

    public FluidHandlerFluidMap(Map<Fluid, IFluidHandler> handlers) {
        this.handlers = handlers;
    }

    public FluidHandlerFluidMap addHandler(Fluid fluid, IFluidHandler handler) {
        this.handlers.put(fluid, handler);
        return this;
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        ArrayList tanks = Lists.newArrayList();
        for (IFluidHandler iFluidHandler : this.handlers.values()) {
            Collections.addAll(tanks, iFluidHandler.getTankProperties());
        }
        return tanks.toArray(new IFluidTankProperties[tanks.size()]);
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        IFluidHandler handler = this.handlers.get(resource.getFluid());
        if (handler == null) {
            return 0;
        }
        return handler.fill(resource, doFill);
    }

    @Override
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        IFluidHandler handler = this.handlers.get(resource.getFluid());
        if (handler == null) {
            return null;
        }
        return handler.drain(resource, doDrain);
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        for (IFluidHandler handler : this.handlers.values()) {
            FluidStack drain = handler.drain(maxDrain, doDrain);
            if (drain == null) continue;
            return drain;
        }
        return null;
    }
}

