/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.pool;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import pw.prok.imagine.pool.Pool;
import pw.prok.imagine.pool.PoolFactory;

public class DynamicPool<T>
implements Pool<T> {
    private final PoolFactory<T> mFactory;
    private final Queue<T> mLocked;
    private final Queue<T> mUnlocked;
    private final Queue<T> mObjects = new ConcurrentLinkedQueue<T>();
    private final Lock mLock = new ReentrantLock(true);

    public DynamicPool(PoolFactory<T> factory) {
        this.mFactory = factory;
        this.mLocked = new LinkedList<T>();
        this.mUnlocked = new LinkedList<T>();
    }

    @Override
    public T obtain() {
        this.mLock.lock();
        try {
            T object = this.mUnlocked.poll();
            if (object == null) {
                object = this.mFactory.create();
                this.mObjects.add(object);
            }
            this.mLocked.add(object);
            T t = object;
            return t;
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public void release(T object) {
        this.mLock.lock();
        try {
            if (!this.mLocked.remove(object)) {
                throw new IllegalStateException("Object not assigned to this pool!");
            }
            this.mUnlocked.add(object);
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList<T> objects;
        this.mLock.lock();
        try {
            objects = new ArrayList<T>(this.mObjects);
        }
        finally {
            this.mLock.unlock();
        }
        return new Iterator<T>(){
            private final Iterator<T> iterator;
            {
                this.iterator = objects.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

