/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.fastdiscover.dd;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DiscoverData {
    private Map<String, Set<String>> annotationToClass = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> classToAnnotation = new HashMap<String, Set<String>>();

    public Map<String, Set<String>> getAnnotationToClass() {
        return this.annotationToClass;
    }

    public Map<String, Set<String>> getClassesToAnnotation() {
        return this.classToAnnotation;
    }

    public Set<String> getAnnotationsForClass(String className) {
        ImmutableSet annotations = this.classToAnnotation.get(className);
        return annotations != null ? annotations : ImmutableSet.of();
    }

    public Set<String> getClassesForAnnotation(String annotation) {
        ImmutableSet classes = this.annotationToClass.get(annotation);
        return classes != null ? classes : ImmutableSet.of();
    }

    public void putAnnotations(String className, Set<String> annotations) {
        this.classToAnnotation.put(className, annotations);
        for (String annotation : annotations) {
            HashSet classes = this.annotationToClass.get(annotation);
            if (classes == null) {
                classes = Sets.newHashSet((Object[])new String[]{className});
                this.annotationToClass.put(annotation, classes);
                continue;
            }
            classes.add((String)className);
        }
    }
}

