/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.fastdiscover;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.launchwrapper.LaunchClassLoader;
import pw.prok.imagine.fastdiscover.DiscoverCandidate;

public class DirCandidate
extends DiscoverCandidate {
    private final File mDir;
    private final boolean mNeedInjection;

    public DirCandidate(File dir, boolean needInjection) {
        this.mDir = dir;
        this.mNeedInjection = needInjection;
    }

    @Override
    public Iterator<InputStream> iterator() {
        return new Iter(this.mDir);
    }

    @Override
    public void injectClassLoader(LaunchClassLoader classLoader) {
        if (this.mNeedInjection) {
            try {
                classLoader.addURL(this.mDir.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.mDir);
    }

    private static final class Iter
    implements Iterator<InputStream> {
        private final Set<File> mClasses = new LinkedHashSet<File>();
        private final Iterator<File> mIterator;

        public Iter(File dir) {
            this.scanDir(dir);
            this.mIterator = this.mClasses.iterator();
        }

        private void scanDir(File dir) {
            File[] files = dir.listFiles();
            if (files == null || files.length == 0) {
                return;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    this.scanDir(file);
                    continue;
                }
                if (!file.isFile() || !file.getName().endsWith(".class")) continue;
                this.mClasses.add(file);
            }
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public InputStream next() {
            try {
                return new FileInputStream(this.mIterator.next());
            }
            catch (FileNotFoundException ignored) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

