/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import pw.prok.imagine.util.Array;

public class CuttableList<T>
implements List<T> {
    private final List<T> mList;
    private int mStartOffset;
    private int mEndOffset;

    public CuttableList(List<T> list) {
        this.mList = list;
        this.mStartOffset = 0;
        this.mEndOffset = 0;
    }

    public CuttableList(List<T> list, int startOffset, int endOffset) {
        assert (startOffset >= 0 && endOffset >= 0);
        this.mList = list;
        this.mStartOffset = startOffset;
        this.mEndOffset = endOffset;
    }

    @Override
    public int size() {
        return Math.max(this.mList.size() - this.mStartOffset - this.mEndOffset, 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int startOffset() {
        return this.mStartOffset;
    }

    public int startOffset(int startOffset) {
        assert (startOffset >= 0);
        int oldStartOffset = this.mStartOffset;
        this.mStartOffset = startOffset;
        return oldStartOffset;
    }

    public int endOffset() {
        return this.mEndOffset;
    }

    public int endOffset(int endOffset) {
        assert (endOffset >= 0);
        int oldEndOffset = this.mEndOffset;
        this.mEndOffset = endOffset;
        return oldEndOffset;
    }

    @Override
    public T get(int index) {
        if (this.valid(index)) {
            return this.mList.get(this.privateIndex(index));
        }
        throw new IndexOutOfBoundsException("Index out of bounds: " + index + ", size: " + this.size());
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    private boolean valid(int index) {
        return index >= 0 && index < this.size();
    }

    private int privateIndex(int index) {
        return index + this.mStartOffset;
    }

    private int publicIndex(int index) {
        return index - this.mStartOffset;
    }

    @Override
    public boolean contains(Object o) {
        return this.valid(this.indexOf(o));
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        ListIterator<T> iterator = this.listIterator();
        while (iterator.hasNext()) {
            if (iterator.next() == o) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = 0;
        ListIterator<T> iterator = this.listIterator();
        while (iterator.hasPrevious()) {
            if (iterator.previous() == o) {
                return this.size() - index - 1;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T1[])new Object[this.size()]);
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        int size = this.size();
        if (size > a.length) {
            a = Array.newArray(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (T o : this) {
            a[i++] = o;
        }
        return a;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            private final ListIterator<T> iterator;
            private final int size;
            private int nextIndex;
            private int previousIndex;
            {
                this.iterator = CuttableList.this.mList.listIterator(index);
                this.size = CuttableList.this.size();
                this.nextIndex = 0;
                this.previousIndex = this.size - 1;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex < this.size - 1 && this.iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    return null;
                }
                ++this.nextIndex;
                return this.iterator.next();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex > 0 && this.iterator.hasPrevious();
            }

            @Override
            public T previous() {
                if (!this.hasPrevious()) {
                    return null;
                }
                --this.previousIndex;
                return this.iterator.previous();
            }

            @Override
            public int nextIndex() {
                return this.nextIndex;
            }

            @Override
            public int previousIndex() {
                return this.previousIndex;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(T t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(T t) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new CuttableList<T>(this.mList, this.privateIndex(fromIndex), this.privateIndex(this.size() - toIndex));
    }
}

