/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.asm;

import LZMA.LzmaInputStream;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pw.prok.imagine.api.Pair;
import pw.prok.imagine.api.Triple;
import pw.prok.imagine.asm.FieldDesc;
import pw.prok.imagine.asm.Mapping;
import pw.prok.imagine.asm.MethodDesc;

public class ImagineRemapper {
    protected static final BiMap<String, String> sRawClass = HashBiMap.create();
    protected static final BiMap<String, String> sRawField = HashBiMap.create();
    protected static final BiMap<String, String> sRawMethod = HashBiMap.create();
    protected static final Map<String, String> sSrgMethods = new HashMap<String, String>();
    protected static final Map<String, String> sSrgFields = new HashMap<String, String>();
    private static Set<Pair<String, String>> sClasses;
    private static Set<Triple<MethodDesc, MethodDesc, MethodDesc>> sMethods;
    private static Set<Triple<FieldDesc, FieldDesc, FieldDesc>> sFields;
    private static boolean sMapsDirty;

    public static Triple<String, String, String> createMethodDesc(String s) {
        return Triple.create(ImagineRemapper.cutMethodClass(s), ImagineRemapper.cutMethod(s), ImagineRemapper.cutMethodDesc(s));
    }

    public static String descDev(String desc) {
        return ImagineRemapper.desc(desc, Mapping.DEV);
    }

    public static String descObf(String desc) {
        return ImagineRemapper.desc(desc, Mapping.OBF);
    }

    public static String descSrg(String desc) {
        return ImagineRemapper.desc(desc, Mapping.SRG);
    }

    public static String desc(String desc, Mapping mapping) {
        StringBuilder newDesc = new StringBuilder();
        for (int i = 0; i < desc.length(); ++i) {
            char c = desc.charAt(i);
            if (c == 'L') {
                int end = desc.indexOf(59, i + 1);
                newDesc.append('L');
                newDesc.append(mapping.clazz(desc.substring(i + 1, end)));
                newDesc.append(';');
                i = end;
                continue;
            }
            newDesc.append(c);
        }
        return newDesc.toString();
    }

    public static String clazzDev(String name) {
        return ImagineRemapper.clazz(name, Mapping.DEV);
    }

    public static String clazzObf(String name) {
        return ImagineRemapper.clazz(name, Mapping.OBF);
    }

    public static String clazzSrg(String name) {
        return ImagineRemapper.clazz(name, Mapping.SRG);
    }

    public static String clazz(String name, Mapping mapping) {
        return mapping.clazz(name);
    }

    private static String methodSrgToDev(String srg) {
        String dev = sSrgMethods.get(srg);
        return dev != null ? dev : srg;
    }

    public static MethodDesc methodDev(String owner, String name, String desc) {
        return ImagineRemapper.method(owner, name, desc, Mapping.DEV);
    }

    public static MethodDesc methodObf(String owner, String name, String desc) {
        return ImagineRemapper.method(owner, name, desc, Mapping.OBF);
    }

    public static MethodDesc methodSrg(String owner, String name, String desc) {
        return ImagineRemapper.method(owner, name, desc, Mapping.SRG);
    }

    public static MethodDesc method(String owner, String name, String desc, Mapping mapping) {
        return mapping.method(owner, name, desc);
    }

    public static String cutMethod(String fullDesc) {
        int c = fullDesc.indexOf(40);
        if (c > 0) {
            int n = fullDesc.lastIndexOf(47, c);
            return fullDesc.substring(n >= 0 ? n + 1 : 0, c);
        }
        return fullDesc;
    }

    public static String cutMethodClass(String fullDesc) {
        int n;
        int c = fullDesc.indexOf(40);
        if (c > 0 && (n = fullDesc.lastIndexOf(47, c)) > 0) {
            return fullDesc.substring(0, n);
        }
        return fullDesc;
    }

    public static String cutDesc(String fullDesc) {
        int c = fullDesc.indexOf(40);
        if (c > 0) {
            return fullDesc.substring(c);
        }
        return fullDesc;
    }

    public static String cutMethodDesc(String fullDesc) {
        int c = fullDesc.indexOf(40);
        if (c > 0) {
            return fullDesc.substring(c);
        }
        return fullDesc;
    }

    public static String cutField(String fullDesc) {
        int c = fullDesc.lastIndexOf(47);
        if (c > 0) {
            return fullDesc.substring(c + 1);
        }
        return fullDesc;
    }

    public static String cutFieldClass(String fullDesc) {
        int c = fullDesc.lastIndexOf(47);
        if (c > 0) {
            return fullDesc.substring(0, c);
        }
        return fullDesc;
    }

    private static String fieldSrgToDev(String srg) {
        String dev = sSrgFields.get(srg);
        return dev != null ? dev : srg;
    }

    public static FieldDesc fieldDev(String owner, String name) {
        return ImagineRemapper.field(owner, name, Mapping.DEV);
    }

    public static FieldDesc fieldObf(String owner, String name) {
        return ImagineRemapper.field(owner, name, Mapping.OBF);
    }

    public static FieldDesc fieldSrg(String owner, String name) {
        return ImagineRemapper.field(owner, name, Mapping.SRG);
    }

    public static FieldDesc field(String owner, String name, Mapping mapping) {
        return mapping.field(owner, name);
    }

    public static void mergeDeobfuscationData(InputStream is, MappingType type) throws Exception {
        String line;
        Map<String, String> srgData = null;
        switch (type) {
            case Method: {
                srgData = sSrgMethods;
                ImagineRemapper.markDirty();
                break;
            }
            case Field: {
                srgData = sSrgFields;
                ImagineRemapper.markDirty();
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        if (type == MappingType.Srg) {
            ImagineRemapper.mergeSrgData(reader);
            return;
        }
        boolean firstLine = true;
        while ((line = reader.readLine()) != null) {
            int c2;
            if (firstLine) {
                firstLine = false;
                continue;
            }
            int c1 = line.indexOf(44);
            if (c1 < 0 || (c2 = line.indexOf(44, c1 + 1)) < 0) continue;
            String srgName = line.substring(0, c1);
            String devName = line.substring(c1 + 1, c2);
            srgData.put(srgName, devName);
        }
        reader.close();
        is.close();
    }

    private static void markDirty() {
        sMapsDirty = true;
    }

    private static void mergeSrgData(BufferedReader reader) throws Exception {
        String line;
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split("\\s+");
            switch (parts[0]) {
                case "CL:": {
                    sRawClass.put((Object)parts[1], (Object)parts[2]);
                    break;
                }
                case "FD:": {
                    sRawField.put((Object)parts[1], (Object)parts[2]);
                    break;
                }
                case "MD:": {
                    sRawMethod.put((Object)(parts[1] + parts[2]), (Object)(parts[3] + parts[4]));
                }
            }
        }
    }

    public static void setupDeobfuscationData(String srg, String methodData, String fieldData) {
        try {
            ImagineRemapper.mergeDeobfuscationData((InputStream)new LzmaInputStream(ImagineRemapper.class.getResourceAsStream(srg)), MappingType.Srg);
            ImagineRemapper.mergeDeobfuscationData((InputStream)new LzmaInputStream(ImagineRemapper.class.getResourceAsStream(methodData)), MappingType.Method);
            ImagineRemapper.mergeDeobfuscationData((InputStream)new LzmaInputStream(ImagineRemapper.class.getResourceAsStream(fieldData)), MappingType.Field);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't load deobfuscation data", e);
        }
    }

    private static void ensureMappings() {
        if (!sMapsDirty) {
            return;
        }
        HashSet<Pair<String, String>> classes = new HashSet<Pair<String, String>>();
        for (Object clazz : sRawClass.entrySet()) {
            String obf = (String)clazz.getKey();
            String srg = (String)clazz.getValue();
            classes.add(new Pair<String, String>(obf, srg));
        }
        sClasses = ImmutableSet.copyOf(classes);
        HashSet<Triple<MethodDesc, MethodDesc, MethodDesc>> methods = new HashSet<Triple<MethodDesc, MethodDesc, MethodDesc>>();
        for (Map.Entry method : sRawMethod.entrySet()) {
            MethodDesc obf = new MethodDesc((String)method.getKey());
            MethodDesc srg = new MethodDesc((String)method.getValue());
            MethodDesc dev = new MethodDesc((String)srg.first(), ImagineRemapper.methodSrgToDev((String)srg.second()), (String)srg.third());
            methods.add(new Triple<MethodDesc, MethodDesc, MethodDesc>(obf, srg, dev));
        }
        sMethods = ImmutableSet.copyOf(methods);
        HashSet<Triple<FieldDesc, FieldDesc, FieldDesc>> fields = new HashSet<Triple<FieldDesc, FieldDesc, FieldDesc>>();
        for (Map.Entry field : sRawField.entrySet()) {
            FieldDesc obf = new FieldDesc((String)field.getKey());
            FieldDesc srg = new FieldDesc((String)field.getValue());
            FieldDesc dev = new FieldDesc((String)srg.first(), ImagineRemapper.fieldSrgToDev((String)srg.second()));
            fields.add(new Triple<FieldDesc, FieldDesc, FieldDesc>(obf, srg, dev));
        }
        sFields = ImmutableSet.copyOf(fields);
        sMapsDirty = false;
    }

    public static Set<Pair<String, String>> clazz() {
        ImagineRemapper.ensureMappings();
        return sClasses;
    }

    public static Set<Triple<MethodDesc, MethodDesc, MethodDesc>> methods() {
        ImagineRemapper.ensureMappings();
        return sMethods;
    }

    public static Set<Triple<FieldDesc, FieldDesc, FieldDesc>> fields() {
        ImagineRemapper.ensureMappings();
        return sFields;
    }

    static {
        sMapsDirty = true;
    }

    public static enum MappingType {
        Srg,
        Method,
        Field;

    }
}

