/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.asm;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import pw.prok.imagine.asm.Action;
import pw.prok.imagine.asm.ImagineASM;
import pw.prok.imagine.asm.ImagineAccess;
import pw.prok.imagine.asm.ImagineDesc;
import pw.prok.imagine.asm.ImagineMethodPosition;
import pw.prok.imagine.asm.MethodDesc;
import pw.prok.imagine.collections.CuttableList;
import pw.prok.imagine.collections.LazyIterable;

public class ImagineMethod
extends ImagineAccess<ImagineMethod> {
    private final ImagineASM mAsm;
    private final MethodNode mMethod;

    ImagineMethod(ImagineASM asm, MethodNode method) {
        this.mAsm = asm;
        this.mMethod = method;
    }

    public ImagineMethod exception(String ... exceptions) {
        if (exceptions == null) {
            return this;
        }
        for (String exception : exceptions) {
            this.mMethod.exceptions.add(this.mAsm.mapClazz(exception));
        }
        return this;
    }

    public ImagineMethod constMethod(int value) {
        InsnList instructions = this.mMethod.instructions;
        instructions.clear();
        ImagineMethod.pushInt(value, instructions);
        instructions.add((AbstractInsnNode)new InsnNode(172));
        return this;
    }

    private static void pushInt(int value, InsnList instructions) {
        switch (value) {
            case -1: {
                instructions.add((AbstractInsnNode)new InsnNode(2));
                break;
            }
            case 0: {
                instructions.add((AbstractInsnNode)new InsnNode(3));
                break;
            }
            case 1: {
                instructions.add((AbstractInsnNode)new InsnNode(4));
                break;
            }
            case 2: {
                instructions.add((AbstractInsnNode)new InsnNode(5));
                break;
            }
            case 3: {
                instructions.add((AbstractInsnNode)new InsnNode(6));
                break;
            }
            case 4: {
                instructions.add((AbstractInsnNode)new InsnNode(7));
                break;
            }
            case 5: {
                instructions.add((AbstractInsnNode)new InsnNode(8));
                break;
            }
            default: {
                if (value >= -128 && value <= 127) {
                    instructions.add((AbstractInsnNode)new IntInsnNode(16, value));
                    break;
                }
                if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                    instructions.add((AbstractInsnNode)new IntInsnNode(17, value));
                    break;
                }
                instructions.add((AbstractInsnNode)new LdcInsnNode((Object)value));
            }
        }
    }

    public ImagineMethod push(int value) {
        ImagineMethod.pushInt(value, this.mMethod.instructions);
        return this;
    }

    public ImagineMethod constMethod(boolean value) {
        return this.constMethod(value ? 1 : 0);
    }

    public ImagineMethod constMethod(double value) {
        InsnList instructions = this.mMethod.instructions;
        instructions.clear();
        ImagineMethod.pushDouble(value, instructions);
        instructions.add((AbstractInsnNode)new InsnNode(175));
        return this;
    }

    private static void pushDouble(double value, InsnList instructions) {
        if (value == 0.0) {
            instructions.add((AbstractInsnNode)new InsnNode(14));
        } else if (value == 1.0) {
            instructions.add((AbstractInsnNode)new InsnNode(15));
        } else {
            instructions.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        }
    }

    public ImagineMethod push(double value) {
        ImagineMethod.pushDouble(value, this.mMethod.instructions);
        return this;
    }

    public ImagineMethod constMethod(float value) {
        InsnList instructions = this.mMethod.instructions;
        instructions.clear();
        ImagineMethod.pushFloat(value, instructions);
        instructions.add((AbstractInsnNode)new InsnNode(174));
        return this;
    }

    public ImagineMethod push(float value) {
        ImagineMethod.pushFloat(value, this.mMethod.instructions);
        return this;
    }

    private static void pushFloat(float value, InsnList instructions) {
        if (value == 0.0f) {
            instructions.add((AbstractInsnNode)new InsnNode(11));
        } else if (value == 1.0f) {
            instructions.add((AbstractInsnNode)new InsnNode(12));
        } else if (value == 2.0f) {
            instructions.add((AbstractInsnNode)new InsnNode(13));
        } else {
            instructions.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(value)));
        }
    }

    public static InsnList methodCall(ImagineMethod img, String owner, String methodName, boolean staticForward, boolean needReturn) {
        if (!staticForward || owner == null) {
            owner = img.mAsm.getActualName();
        }
        owner = ImagineASM.toDesc(owner);
        ImagineDesc desc = ImagineDesc.parse(img.mMethod.desc);
        if (!needReturn) {
            desc.returnType(ImagineDesc.SubDesc.create(Type.VOID_TYPE, 0));
        }
        InsnList instructions = new InsnList();
        if (!img.isStatic()) {
            staticForward = true;
            instructions.add((AbstractInsnNode)new IntInsnNode(25, 0));
        }
        int i = img.isStatic() ? 0 : 1;
        for (ImagineDesc.SubDesc sub : desc.parameters()) {
            instructions.add((AbstractInsnNode)new IntInsnNode(sub.opcodeLoad(), i++));
        }
        if (staticForward && !img.isStatic()) {
            desc.first(Type.getType((String)("L" + ImagineASM.toDesc(img.mAsm.getActualName()) + ";")), 0);
        }
        MethodDesc method = img.mAsm.mapMethod(owner, methodName, desc.toString());
        instructions.add((AbstractInsnNode)new MethodInsnNode(staticForward ? 184 : 185, (String)method.first(), (String)method.second(), (String)method.third(), false));
        if (needReturn) {
            instructions.add((AbstractInsnNode)new InsnNode(desc.returnOpcode()));
        }
        return instructions;
    }

    private static void forward(ImagineMethod img, String owner, String methodName, boolean staticForward) {
        InsnList list = img.mMethod.instructions;
        list.clear();
        list.add(ImagineMethod.methodCall(img, owner, methodName, staticForward, true));
    }

    public ImagineMethod forward(String owner, String methodName) {
        ImagineMethod.forward(this, owner, methodName, owner != null);
        return this;
    }

    public ImagineMethod forward(String methodName) {
        return this.forward(null, methodName);
    }

    public ImagineMethod callFirst(String owner, String methodName) {
        InsnList instructions = this.mMethod.instructions;
        instructions.insertBefore(instructions.getFirst(), ImagineMethod.methodCall(this, owner, methodName, owner != null, false));
        return this;
    }

    public ImagineMethod callFirst(String methodName) {
        return this.callFirst(null, methodName);
    }

    public ImagineMethod callLast(String owner, String methodName) {
        InsnList instructions = this.mMethod.instructions;
        InsnList methodCall = ImagineMethod.methodCall(this, owner, methodName, owner != null, false);
        for (AbstractInsnNode node : instructions) {
            switch (node.getOpcode()) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    instructions.insertBefore(node, methodCall);
                }
            }
        }
        return this;
    }

    public ImagineMethod callLast(String methodName) {
        return this.callLast(null, methodName);
    }

    public InsnList instructions() {
        return this.mMethod.instructions;
    }

    public String getName() {
        return this.mAsm.getActualName();
    }

    public Iterable<ImagineMethodPosition> find(InsnList patternRaw) {
        final List<AbstractInsnNode> pattern = ImagineASM.asList(patternRaw);
        return new LazyIterable<ImagineMethodPosition>(new LazyIterable.LazyAction<ImagineMethodPosition>(){
            private int mPosition = 0;
            private CuttableList<AbstractInsnNode> mInstructions;
            {
                this.mInstructions = new CuttableList<AbstractInsnNode>(ImagineASM.asList(((ImagineMethod)ImagineMethod.this).mMethod.instructions));
            }

            @Override
            public ImagineMethodPosition acquire() {
                int index = Collections.indexOfSubList(this.mInstructions, pattern);
                if (index >= 0) {
                    this.mPosition += index;
                    for (int i = 0; i < index; ++i) {
                    }
                }
                Iterator patternIterator = pattern.iterator();
                return null;
            }
        });
    }

    public ImagineMethod find(InsnList pattern, Action<ImagineMethodPosition> action) {
        for (ImagineMethodPosition position : this.find(pattern)) {
            action.action(position);
        }
        return this;
    }

    public boolean isStatic() {
        return (this.mMethod.access & 8) != 0;
    }

    @Override
    public ImagineMethod addAccess(int modifiers) {
        this.mMethod.access |= modifiers;
        return this;
    }

    @Override
    public ImagineMethod limitAccess(int modifiers) {
        this.mMethod.access &= modifiers;
        return this;
    }
}

