/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.id.ImportedId;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployUpdateMapFactory {
    private static final Logger logger = Logger.getLogger(DeployUpdateMapFactory.class.getName());

    public static Map<String, String> build(BeanDescriptor<?> descriptor) {
        BeanPropertyAssocOne<?>[] oneImported;
        BeanProperty[] baseScalar;
        HashMap<String, String> deployMap = new HashMap<String, String>();
        String shortName = descriptor.getName();
        String beanName = shortName.toLowerCase();
        deployMap.put(beanName, descriptor.getBaseTable());
        for (BeanProperty baseProp : baseScalar = descriptor.propertiesBaseScalar()) {
            if (!baseProp.isDbInsertable() && !baseProp.isDbUpdatable()) continue;
            deployMap.put(baseProp.getName().toLowerCase(), baseProp.getDbColumn());
        }
        for (BeanPropertyAssocOne<?> assocOne : oneImported = descriptor.propertiesOneImported()) {
            ImportedId importedId = assocOne.getImportedId();
            if (importedId == null) {
                String m = descriptor.getFullName() + " importedId is null for associated: " + assocOne.getFullBeanName();
                logger.log(Level.SEVERE, m);
                continue;
            }
            if (!importedId.isScalar()) continue;
            deployMap.put(importedId.getLogicalName(), importedId.getDbColumn());
        }
        return deployMap;
    }
}

