/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.validation.factory;

import com.avaje.ebean.validation.factory.NoAttributesValidator;
import com.avaje.ebean.validation.factory.Validator;
import com.avaje.ebean.validation.factory.ValidatorFactory;
import java.lang.annotation.Annotation;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PastValidatorFactory
implements ValidatorFactory {
    Validator DATE = new DateValidator();
    Validator CALENDAR = new CalendarValidator();

    @Override
    public Validator create(Annotation annotation, Class<?> type) {
        if (Date.class.isAssignableFrom(type)) {
            return this.DATE;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return this.CALENDAR;
        }
        String msg = "Can not use @Past on type " + type;
        throw new RuntimeException(msg);
    }

    private static class CalendarValidator
    extends NoAttributesValidator {
        private CalendarValidator() {
        }

        public String getKey() {
            return "past";
        }

        public boolean isValid(Object value) {
            if (value == null) {
                return true;
            }
            Calendar cal = (Calendar)value;
            return cal.before(Calendar.getInstance());
        }
    }

    private static class DateValidator
    extends NoAttributesValidator {
        private DateValidator() {
        }

        public String getKey() {
            return "past";
        }

        public boolean isValid(Object value) {
            if (value == null) {
                return true;
            }
            Date date = (Date)value;
            return date.before(new Date());
        }
    }
}

