/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import com.google.common.base.Throwables;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.spigotmc.Metrics;
import org.spigotmc.RestartCommand;
import org.spigotmc.TicksPerSecondCommand;
import org.spigotmc.WatchdogThread;

public class SpigotConfig {
    private static final File CONFIG_FILE = new File("spigot.yml");
    private static final String HEADER = "This is the main configuration file for Spigot.\nAs you can see, there's tons to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\nFor a reference for any variable inside this file, check out the Spigot wiki at\nhttp://www.spigotmc.org/wiki/spigot-configuration/\n\nIf you need help with the configuration or have any questions related to Spigot,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #spigot @ irc.esper.net ( http://webchat.esper.net/?channel=spigot )\nForums: http://www.spigotmc.org/forum/\n";
    static YamlConfiguration config;
    static int version;
    static Map<String, Command> commands;
    private static Metrics metrics;
    public static boolean logCommands;
    public static boolean tabComplete;
    public static String whitelistMessage;
    public static String unknownCommandMessage;
    public static String serverFullMessage;
    public static String outdatedClientMessage;
    public static String outdatedServerMessage;
    public static int timeoutTime;
    public static boolean restartOnCrash;
    public static String restartScript;
    public static String restartMessage;
    public static boolean bungee;
    public static boolean lateBind;
    public static boolean disableStatSaving;
    public static TObjectIntHashMap<String> forcedStats;
    public static int playerSample;
    public static int playerShuffle;
    public static int fullMatchRate;

    public static void init() {
        config = YamlConfiguration.loadConfiguration(CONFIG_FILE);
        config.options().header(HEADER);
        config.options().copyDefaults(true);
        commands = new HashMap<String, Command>();
        version = SpigotConfig.getInt("config-version", 7);
        SpigotConfig.set("config-version", 7);
        SpigotConfig.readConfig(SpigotConfig.class, null);
    }

    public static void registerCommands() {
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            MinecraftServer.I().server.getCommandMap().register(entry.getKey(), "Spigot", entry.getValue());
        }
        if (metrics == null) {
            try {
                metrics = new Metrics();
                metrics.start();
            }
            catch (IOException ex) {
                Bukkit.getServer().getLogger().log(Level.SEVERE, "Could not start metrics service", ex);
            }
        }
    }

    static void readConfig(Class<?> clazz, Object instance) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwables.propagate((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + method, ex);
            }
        }
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + CONFIG_FILE, ex);
        }
    }

    private static void set(String path, Object val) {
        config.set(path, val);
    }

    private static boolean getBoolean(String path, boolean def) {
        config.addDefault(path, def);
        return config.getBoolean(path, config.getBoolean(path));
    }

    private static int getInt(String path, int def) {
        config.addDefault(path, def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    private static String getString(String path, String def) {
        config.addDefault(path, def);
        return config.getString(path, config.getString(path));
    }

    private static void logCommands() {
        logCommands = SpigotConfig.getBoolean("commands.log", true);
    }

    private static void tabComplete() {
        tabComplete = SpigotConfig.getBoolean("commands.tab-complete", true);
    }

    private static String transform(String s) {
        return ChatColor.translateAlternateColorCodes('&', s).replaceAll("\\n", "\n");
    }

    private static void messages() {
        if (version < 4) {
            SpigotConfig.set("messages.outdated-client", outdatedClientMessage);
            SpigotConfig.set("messages.outdated-server", outdatedServerMessage);
        }
        whitelistMessage = SpigotConfig.transform(SpigotConfig.getString("messages.whitelist", "You are not whitelisted on this server!"));
        unknownCommandMessage = SpigotConfig.transform(SpigotConfig.getString("messages.unknown-command", "Unknown command. Type \"/help\" for help."));
        serverFullMessage = SpigotConfig.transform(SpigotConfig.getString("messages.server-full", "The server is full!"));
        outdatedClientMessage = SpigotConfig.transform(SpigotConfig.getString("messages.outdated-client", outdatedClientMessage));
        outdatedServerMessage = SpigotConfig.transform(SpigotConfig.getString("messages.outdated-server", outdatedServerMessage));
    }

    private static void watchdog() {
        timeoutTime = SpigotConfig.getInt("settings.timeout-time", timeoutTime);
        restartOnCrash = SpigotConfig.getBoolean("settings.restart-on-crash", restartOnCrash);
        restartScript = SpigotConfig.getString("settings.restart-script", restartScript);
        restartMessage = SpigotConfig.transform(SpigotConfig.getString("messages.restart", "Server is restarting"));
        commands.put("restart", new RestartCommand("restart"));
        WatchdogThread.doStart(timeoutTime, restartOnCrash);
    }

    private static void bungee() {
        if (version < 4) {
            SpigotConfig.set("settings.bungeecord", false);
            System.out.println("Oudated config, disabling BungeeCord support!");
        }
        bungee = SpigotConfig.getBoolean("settings.bungeecord", false);
    }

    private static void nettyThreads() {
        int count;
        if (version < 7) {
            SpigotConfig.set("settings.netty-threads", -1);
        }
        count = (count = SpigotConfig.getInt("settings.netty-threads", -1)) == -1 ? Runtime.getRuntime().availableProcessors() : count;
        System.setProperty("io.netty.eventLoopThreads", Integer.toString(count));
        Bukkit.getLogger().log(Level.INFO, "Using {0} threads for Netty based IO", count);
    }

    private static void lateBind() {
        lateBind = SpigotConfig.getBoolean("settings.late-bind", false);
    }

    private static void stats() {
        disableStatSaving = SpigotConfig.getBoolean("stats.disable-saving", false);
        if (!config.contains("stats.forced-stats")) {
            config.createSection("stats.forced-stats");
        }
        ConfigurationSection section = config.getConfigurationSection("stats.forced-stats");
        for (String name : section.getKeys(true)) {
            if (!section.isInt(name)) continue;
            forcedStats.put((Object)name, section.getInt(name));
        }
        if (disableStatSaving && section.getInt("achievement.openInventory", 0) < 1) {
            Bukkit.getLogger().warning("*** WARNING *** stats.disable-saving is true but stats.forced-stats.achievement.openInventory isn't set to 1. Disabling stat saving without forcing the achievement may cause it to get stuck on the player's screen.");
        }
    }

    private static void tpsCommand() {
        commands.put("tps", new TicksPerSecondCommand("tps"));
    }

    private static void playerSample() {
        playerSample = SpigotConfig.getInt("settings.sample-count", 12);
        System.out.println("Server Ping Player Sample Count: " + playerSample);
    }

    private static void playerShuffle() {
        playerShuffle = SpigotConfig.getInt("settings.player-shuffle", 0);
    }

    private static void fullMatchRate() {
        fullMatchRate = SpigotConfig.getInt("settings.fullMatchRate", 10);
    }

    static {
        outdatedClientMessage = "Outdated client! Please use {}";
        outdatedServerMessage = "Outdated server! I'm still on {}";
        timeoutTime = 90;
        restartOnCrash = true;
        restartScript = "./start.sh";
        forcedStats = new TObjectIntHashMap();
    }
}

