/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportCommand
extends VanillaCommand {
    public TeleportCommand() {
        super("tp");
        this.description = "Teleports the given player (or yourself) to another player or coordinates";
        this.usageMessage = "/tp [player] <target> and/or <x> <y> <z>";
        this.setPermission("bukkit.command.teleport");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        Player player;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 1 || args.length > 4) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if (args.length == 1 || args.length == 3) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Please provide a player!");
                return true;
            }
            player = (Player)sender;
        } else {
            player = Bukkit.getPlayerExact(args[0]);
        }
        if (player == null) {
            sender.sendMessage("Player not found: " + args[0]);
            return true;
        }
        if (args.length < 3) {
            Player target = Bukkit.getPlayerExact(args[args.length - 1]);
            if (target == null) {
                sender.sendMessage("Can't find player " + args[args.length - 1] + ". No tp.");
                return true;
            }
            player.teleport(target, PlayerTeleportEvent.TeleportCause.COMMAND);
            Command.broadcastCommandMessage(sender, "Teleported " + player.getDisplayName() + " to " + target.getDisplayName());
            return true;
        }
        if (player.getWorld() == null) return true;
        Location playerLocation = player.getLocation();
        double x = this.getCoordinate(sender, playerLocation.getX(), args[args.length - 3]);
        double y2 = this.getCoordinate(sender, playerLocation.getY(), args[args.length - 2], 0, 0);
        double z2 = this.getCoordinate(sender, playerLocation.getZ(), args[args.length - 1]);
        if (x != -3.0000001E7 && y2 != -3.0000001E7 && z2 != -3.0000001E7) {
            playerLocation.setX(x);
            playerLocation.setY(y2);
            playerLocation.setZ(z2);
            player.teleport(playerLocation, PlayerTeleportEvent.TeleportCause.COMMAND);
            Command.broadcastCommandMessage(sender, String.format("Teleported %s to %.2f, %.2f, %.2f", player.getDisplayName(), x, y2, z2));
            return true;
        }
        sender.sendMessage("Please provide a valid location!");
        return true;
    }

    private double getCoordinate(CommandSender sender, double current, String input) {
        return this.getCoordinate(sender, current, input, -30000000, 30000000);
    }

    private double getCoordinate(CommandSender sender, double current, String input, int min, int max) {
        double result;
        boolean relative = input.startsWith("~");
        double d = result = relative ? current : 0.0;
        if (!relative || input.length() > 1) {
            double testResult;
            boolean exact = input.contains(".");
            if (relative) {
                input = input.substring(1);
            }
            if ((testResult = TeleportCommand.getDouble(sender, input)) == -3.0000001E7) {
                return -3.0000001E7;
            }
            result += testResult;
            if (!exact && !relative) {
                result += 0.5;
            }
        }
        if (min != 0 || max != 0) {
            if (result < (double)min) {
                result = -3.0000001E7;
            }
            if (result > (double)max) {
                result = -3.0000001E7;
            }
        }
        return result;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1 || args.length == 2) {
            return super.tabComplete(sender, alias, args);
        }
        return ImmutableList.of();
    }
}

