/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.chunkio;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import kcauldron.ChunkCallback;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.chunkio.QueuedChunk;
import net.minecraftforge.common.util.AsynchronousExecutor;
import net.minecraftforge.event.world.ChunkDataEvent;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.event.world.ChunkLoadEvent;

class ChunkIOProvider
implements AsynchronousExecutor.CallBackProvider<QueuedChunk, apx, ChunkCallback, RuntimeException> {
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    ChunkIOProvider() {
    }

    @Override
    public apx callStage1(QueuedChunk queuedChunk) throws RuntimeException {
        aqk loader = queuedChunk.loader;
        Object[] data = null;
        try {
            data = loader.loadChunk__Async(queuedChunk.world, queuedChunk.x, queuedChunk.z);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (data != null) {
            queuedChunk.compound = (dh)data[1];
            return (apx)data[0];
        }
        return null;
    }

    @Override
    public void callStage2(QueuedChunk queuedChunk, apx chunk) throws RuntimeException {
        CraftServer server;
        if (chunk == null) {
            queuedChunk.provider.originalLoadChunk(queuedChunk.x, queuedChunk.z);
            return;
        }
        queuedChunk.loader.loadEntities(queuedChunk.world, queuedChunk.compound.m("Level"), chunk);
        MinecraftForge.EVENT_BUS.post(new ChunkDataEvent.Load(chunk, queuedChunk.compound));
        chunk.p = queuedChunk.provider.i.I();
        queuedChunk.provider.chunkManager.putChunk(chunk, queuedChunk.x, queuedChunk.z);
        queuedChunk.provider.h.add(chunk);
        chunk.c();
        if (queuedChunk.provider.e != null) {
            queuedChunk.provider.i.timings.syncChunkLoadStructuresTimer.startTiming();
            queuedChunk.provider.e.e(queuedChunk.x, queuedChunk.z);
            queuedChunk.provider.i.timings.syncChunkLoadStructuresTimer.stopTiming();
        }
        if ((server = queuedChunk.provider.i.getServer()) != null) {
            server.getPluginManager().callEvent(new ChunkLoadEvent(chunk.bukkitChunk, false));
        }
        for (int x = -2; x < 3; ++x) {
            for (int z2 = -2; z2 < 3; ++z2) {
                apx neighbor;
                if (x == 0 && z2 == 0 || (neighbor = queuedChunk.provider.getChunkIfLoaded(chunk.g + x, chunk.h + z2)) == null) continue;
                neighbor.setNeighborLoaded(-x, -z2);
                chunk.setNeighborLoaded(x, z2);
            }
        }
        chunk.a((apu)queuedChunk.provider, (apu)queuedChunk.provider, queuedChunk.x, queuedChunk.z);
    }

    @Override
    public void callStage3(QueuedChunk queuedChunk, apx chunk, ChunkCallback callback) throws RuntimeException {
        callback.onChunkLoaded(chunk);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, "Chunk I/O Executor Thread-" + this.threadNumber.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    }
}

