/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.chunkio;

import kcauldron.ChunkCallback;
import net.minecraftforge.common.chunkio.ChunkIOProvider;
import net.minecraftforge.common.chunkio.QueuedChunk;
import net.minecraftforge.common.util.AsynchronousExecutor;

public class ChunkIOExecutor {
    static final int BASE_THREADS = 1;
    static final int PLAYERS_PER_THREAD = 50;
    private static final AsynchronousExecutor<QueuedChunk, apx, ChunkCallback, RuntimeException> instance = new AsynchronousExecutor<QueuedChunk, apx, ChunkCallback, RuntimeException>(new ChunkIOProvider(), 1);

    public static apx syncChunkLoad(ahb world, aqk loader, ms provider, int x, int z2) {
        return instance.getSkipQueue(new QueuedChunk(x, z2, loader, world, provider));
    }

    public static void queueChunkLoad(ahb world, aqk loader, ms provider, int x, int z2, Runnable runnable) {
        instance.add(new QueuedChunk(x, z2, loader, world, provider), new RunnableCallback(runnable));
    }

    public static void dropQueuedChunkLoad(ahb world, int x, int z2, Runnable runnable) {
        instance.drop(new QueuedChunk(x, z2, null, world, null), new RunnableCallback(runnable));
    }

    public static void adjustPoolSize(int players) {
        int size = Math.max(1, (int)Math.ceil((double)players / 50.0));
        instance.setActiveThreads(size);
    }

    public static void tick() {
        instance.finishActive();
    }

    public static void queueChunkLoad(ahb world, aqk loader, ms provider, int x, int z2, ChunkCallback runnable) {
        instance.add(new QueuedChunk(x, z2, loader, world, provider), runnable);
    }

    public static final class RunnableCallback
    implements ChunkCallback {
        private final Runnable runnable;

        public RunnableCallback(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void onChunkLoaded(apx chunk) {
            this.runnable.run();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            Runnable runnable = obj instanceof Runnable ? (Runnable)obj : (obj instanceof RunnableCallback ? ((RunnableCallback)obj).runnable : null);
            return this.runnable == runnable;
        }
    }
}

