/*
 * Decompiled with CFR 0.152.
 */
package kcauldron.updater;

import java.io.InputStreamReader;
import java.io.Reader;
import kcauldron.KCauldron;
import kcauldron.KLog;
import kcauldron.updater.DefaultUpdateCallback;
import net.minecraft.server.MinecraftServer;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class KVersionRetriever
implements Runnable,
Thread.UncaughtExceptionHandler {
    private static final boolean DEBUG = false;
    private static final KLog sLogger = KLog.get(KVersionRetriever.class.getSimpleName());
    private static final JSONParser sParser = new JSONParser();
    private static MinecraftServer sServer;
    private final IVersionCheckCallback mCallback;
    private final boolean mLoop;
    private final Thread mThread;
    private final String mGroup;
    private final String mName;
    private final boolean mUpToDateSupport;

    public static void init(MinecraftServer server) {
        sServer = server;
        if (MinecraftServer.kcauldronConfig.updatecheckerEnable.getValue().booleanValue()) {
            KVersionRetriever.startServer(DefaultUpdateCallback.INSTANCE, true);
        }
    }

    public static void startServer(IVersionCheckCallback callback, boolean loop) {
        new KVersionRetriever(callback, loop, true, KCauldron.getGroup(), KCauldron.getChannel());
    }

    public KVersionRetriever(IVersionCheckCallback callback, boolean loop, boolean upToDateSupport, String group, String name) {
        if (DEBUG) {
            sLogger.info("Created new version retrivier", new Object[0]);
        }
        this.mCallback = callback;
        this.mLoop = loop;
        this.mUpToDateSupport = upToDateSupport;
        this.mGroup = group;
        this.mName = name;
        this.mThread = new Thread(KCauldron.sKCauldronThreadGroup, this, "KCauldron version retrievier");
        this.mThread.setPriority(1);
        this.mThread.setDaemon(true);
        this.mThread.setUncaughtExceptionHandler(this);
        this.mThread.start();
    }

    @Override
    public void run() {
        while (!this.mThread.isInterrupted()) {
            this.check();
            if (!this.mLoop) break;
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void check() {
        try {
            HttpUriRequest request = RequestBuilder.get().setUri("https://api.prok.pw/repo/version/" + this.mGroup + "/" + this.mName).addParameter("version", KCauldron.getCurrentVersion()).addParameter("hostname", sServer.y()).addParameter("port", "" + sServer.z()).build();
            CloseableHttpResponse response = HttpClientBuilder.create().setUserAgent("KCauldron Version Retriever").setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build().execute(request);
            if (response.getStatusLine().getStatusCode() != 200) {
                this.uncaughtException(this.mThread, new IllegalStateException("Status code isn't OK"));
                return;
            }
            JSONObject json = (JSONObject)sParser.parse((Reader)new InputStreamReader(response.getEntity().getContent()));
            String version = (String)json.get((Object)"version");
            if (!this.mUpToDateSupport || KCauldron.getCurrentVersion() == null || !version.equals(KCauldron.getCurrentVersion())) {
                this.mCallback.newVersion(version);
            } else {
                this.mCallback.upToDate();
            }
        }
        catch (Exception e) {
            this.uncaughtException(null, e);
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        sLogger.warning(e, "Error occured during retriving version", new Object[0]);
        if (this.mCallback != null) {
            this.mCallback.error(e);
        }
    }

    public static interface IVersionCheckCallback {
        public void upToDate();

        public void newVersion(String var1);

        public void error(Throwable var1);
    }
}

