/*
 * Decompiled with CFR 0.152.
 */
package kcauldron;

import cpw.mods.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class KLog {
    private static final KLog DEFAULT_LOGGER = new KLog("KCauldron");
    private final String mTag;

    public static KLog get() {
        return DEFAULT_LOGGER;
    }

    public static KLog get(String tag) {
        return new KLog("KCauldron: " + tag);
    }

    public KLog(String tag) {
        this.mTag = tag;
    }

    public void log(Level level, Throwable throwable, String message, Object ... args) {
        Throwable t = null;
        if (throwable != null) {
            t = new Throwable();
            t.initCause(throwable);
            t.fillInStackTrace();
        }
        FMLLog.log(this.mTag, level, t, String.format(message, args), new Object[0]);
    }

    public void warning(String message, Object ... args) {
        this.log(Level.WARN, null, message, args);
    }

    public void warning(Throwable throwable, String message, Object ... args) {
        this.log(Level.WARN, throwable, message, args);
    }

    public void info(String message, Object ... args) {
        this.log(Level.INFO, null, message, args);
    }

    public void info(Throwable throwable, String message, Object ... args) {
        this.log(Level.INFO, throwable, message, args);
    }
}

