/*
 * Decompiled with CFR 0.152.
 */
package kcauldron;

import kcauldron.KCauldronCommand;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.ConfigBase;
import net.minecraftforge.cauldron.configuration.IntSetting;
import net.minecraftforge.cauldron.configuration.Setting;
import net.minecraftforge.cauldron.configuration.StringSetting;
import org.bukkit.configuration.file.YamlConfiguration;

public class KCauldronConfig
extends ConfigBase {
    public BoolSetting commandEnable = new BoolSetting(this, "command.enable", true, "Enable KCauldron command");
    public BoolSetting updatecheckerEnable = new BoolSetting(this, "updatechecker.enable", true, "Enable KCauldron update checker");
    public StringSetting updatecheckerSymlinks = new StringSetting(this, "updatechecker.symlinks", "KCauldron.jar", "(Re)create symlinks after update");
    public BoolSetting updatecheckerAutoinstall = new BoolSetting(this, "updatechecker.autoinstall", false, "Install updates without confirming");
    public BoolSetting updatecheckerAutorestart = new BoolSetting(this, "updatechecker.autorestart", false, "Restart server after updating without confirming (set restart script in spigot.yml)");
    public BoolSetting updatecheckerQuiet = new BoolSetting(this, "updatechecker.quiet", false, "Print less info during update");
    public BoolSetting loggingMaterialInjection = new BoolSetting(this, "logging.materialInjection", false, "Log material injection event");
    public BoolSetting loggingClientModList = new BoolSetting(this, "logging.clientModList", true, "Print client's mod list during attempt to join");
    public BoolSetting commonAllowNetherPortal = new BoolSetting(this, "common.allowNetherPortalBesidesOverworld", false, "Allow nether portals in dimensions besides overworld");
    public BoolSetting commonFastLeavesDecayEnable = new BoolSetting(this, "common.fastLeavesDecay.enable", false, "Enable fast decaying of leaves, not affects drop chanches /etc");
    public IntSetting commonFastLeavesDecayMinTickTime = new IntSetting(this, "common.fastLeavesDecay.minTickTime", 5, "Minimal amount of tick between block updates");
    public IntSetting commonFastLeavesDecayMaxTickTime = new IntSetting(this, "common.fastLeavesDecay.maxTickTime", 10, "Minimal amount of tick between block updates");
    public IntSetting commonMaxChunkGenPerTick = new IntSetting(this, "common.maxChunkGenPerTick", 1, "How many chunks generate during tick");
    public BoolSetting experimentalTileEntityListRecreation = new BoolSetting(this, "experimental.tileEntityListRecreation", false, "EXPERIMENTAL! Recreate list of TE each tick.");
    public static boolean tileEntityListRecreation;

    public KCauldronConfig() {
        super("kcauldron.yml", "kc");
        this.register(this.commandEnable);
        this.register(this.updatecheckerEnable);
        this.register(this.updatecheckerSymlinks);
        this.register(this.updatecheckerAutoinstall);
        this.register(this.updatecheckerAutorestart);
        this.register(this.updatecheckerQuiet);
        this.register(this.loggingMaterialInjection);
        this.register(this.loggingClientModList);
        this.register(this.commonAllowNetherPortal);
        this.register(this.commonFastLeavesDecayEnable);
        this.register(this.commonFastLeavesDecayMinTickTime);
        this.register(this.commonFastLeavesDecayMaxTickTime);
        this.register(this.experimentalTileEntityListRecreation);
        this.load();
    }

    private void register(Setting<?> setting) {
        this.settings.put(setting.path, setting);
    }

    @Override
    public void registerCommands() {
        if (this.commandEnable.getValue().booleanValue()) {
            super.registerCommands();
        }
    }

    @Override
    protected void addCommands() {
        this.commands.put(this.commandName, new KCauldronCommand());
    }

    @Override
    protected void load() {
        try {
            this.config = YamlConfiguration.loadConfiguration(this.configFile);
            String header = "";
            for (Setting toggle : this.settings.values()) {
                if (!toggle.description.equals("")) {
                    header = header + "Setting: " + toggle.path + " Default: " + toggle.def + " # " + toggle.description + "\n";
                }
                this.config.addDefault(toggle.path, toggle.def);
                ((Setting)this.settings.get(toggle.path)).setValue(this.config.getString(toggle.path));
            }
            this.config.options().header(header);
            this.config.options().copyDefaults(true);
            this.save();
        }
        catch (Exception ex) {
            MinecraftServer.I().h("Could not load " + this.configFile);
            ex.printStackTrace();
        }
        tileEntityListRecreation = this.experimentalTileEntityListRecreation.getValue();
    }
}

