/*
 * Decompiled with CFR 0.152.
 */
package kcauldron;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import kcauldron.KCauldron;
import kcauldron.updater.CommandSenderUpdateCallback;
import kcauldron.updater.KCauldronUpdater;
import kcauldron.updater.KVersionRetriever;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;

public class KCauldronCommand
extends Command {
    public static final String NAME = "kc";
    public static final String CHECK = "kc.check";
    public static final String UPDATE = "kc.update";
    public static final String TPS = "kc.tps";
    public static final String RESTART = "kc.restart";
    public static final String DUMP = "kc.dump";

    public KCauldronCommand() {
        super(NAME);
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("/%s check - Check to update\n", NAME));
        builder.append(String.format("/%s update [version] - Update to specified or latest version\n", NAME));
        builder.append(String.format("/%s tps - Show tps statistics\n", NAME));
        builder.append(String.format("/%s restart - Restart server\n", NAME));
        builder.append(String.format("/%s dump - Dump statistics into kcauldron.dump file\n", NAME));
        this.setUsage(builder.toString());
        this.setPermission(NAME);
    }

    public boolean testPermission(CommandSender target, String permission) {
        if (this.testPermissionSilent(target, permission)) {
            return true;
        }
        target.sendMessage((Object)((Object)ChatColor.RED) + "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.");
        return false;
    }

    public boolean testPermissionSilent(CommandSender target, String permission) {
        if (!super.testPermissionSilent(target)) {
            return false;
        }
        for (String p : permission.split(";")) {
            if (!target.hasPermission(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.YELLOW) + "Please specify action");
            sender.sendMessage((Object)((Object)ChatColor.AQUA) + this.usageMessage);
            return true;
        }
        String action = args[0];
        if ("check".equals(action)) {
            if (!this.testPermission(sender, CHECK)) {
                return true;
            }
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Initiated version check...");
            KVersionRetriever.startServer(new CommandSenderUpdateCallback(sender), false);
        } else if ("update".equals(action)) {
            KCauldronUpdater.initUpdate(sender, args.length > 1 ? args[1] : null);
        } else if ("tps".equals(action)) {
            if (!this.testPermission(sender, TPS)) {
                return true;
            }
            World currentWorld = null;
            if (sender instanceof CraftPlayer) {
                currentWorld = ((CraftPlayer)sender).getWorld();
            }
            sender.sendMessage((Object)((Object)ChatColor.DARK_BLUE) + "---------------------------------------");
            MinecraftServer server = MinecraftServer.I();
            for (World world : server.server.getWorlds()) {
                if (!(world instanceof CraftWorld)) continue;
                boolean current = currentWorld != null && currentWorld == world;
                mt mcWorld = ((CraftWorld)world).getHandle();
                String bukkitName = world.getName();
                int dimensionId = mcWorld.t.i;
                String name = mcWorld.t.l();
                String displayName = name.equals(bukkitName) ? name : String.format("%s | %s", name, bukkitName);
                double worldTickTime = (double)KCauldronCommand.mean((long[])server.worldTickTimes.get(dimensionId)) * 1.0E-6;
                double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
                ChatColor color = worldTPS >= 19.2 ? ChatColor.GREEN : (worldTPS >= 15.0 ? ChatColor.YELLOW : ChatColor.RED);
                sender.sendMessage(String.format("%s[%d] %s%s %s- %s%.2fms %s/ %s%.2ftps", new Object[]{ChatColor.GOLD, dimensionId, current ? ChatColor.GREEN : ChatColor.YELLOW, displayName, ChatColor.RESET, color, worldTickTime, ChatColor.WHITE, color, worldTPS}));
            }
            double meanTickTime = (double)KCauldronCommand.mean(server.g) * 1.0E-6;
            double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
            ChatColor color = meanTPS >= 19.2 ? ChatColor.GREEN : (meanTPS >= 15.0 ? ChatColor.YELLOW : ChatColor.RED);
            sender.sendMessage(String.format("%sOverall - %s%s%.2fms %s/ %s%.2ftps", new Object[]{ChatColor.BLUE, ChatColor.RESET, color, meanTickTime, ChatColor.WHITE, color, meanTPS}));
        } else if ("restart".equals(action)) {
            if (!this.testPermission(sender, RESTART)) {
                return true;
            }
            KCauldron.restart();
        } else if ("dump".equals(action)) {
            if (!this.testPermission(sender, DUMP)) {
                return true;
            }
            try {
                File outputFile = new File("kcauldron.dump");
                FileOutputStream os = new FileOutputStream(outputFile);
                OutputStreamWriter writer = new OutputStreamWriter(os);
                for (mt world : DimensionManager.getWorlds()) {
                    writer.write(String.format("Stats for %s [%s] with id %d\n", world, world.t.l(), world.dimension));
                    writer.write("Current tick: " + world.x.f() + "\n");
                    writer.write("\nEntities: ");
                    writer.write("count - " + world.e.size() + "\n");
                    for (sa entity : world.e) {
                        writer.write(String.format("  %s at (%.4f;%.4f;%.4f)\n", entity.getClass().getName(), entity.s, entity.t, entity.u));
                    }
                    writer.write("\nTileEntities: ");
                    writer.write("count - " + world.g.size() + "\n");
                    for (sa entity : world.g) {
                        writer.write(String.format("  %s at (%d;%d;%d)\n", entity.getClass().getName(), entity.c, entity.d, entity.e));
                    }
                    writer.write("\nLoaded chunks: ");
                    writer.write("count - " + world.F.size() + "\n");
                    for (agu chunkCoords : world.F) {
                        int x = chunkCoords.a;
                        int z2 = chunkCoords.b;
                        apx chunk = world.v.d(x, z2);
                        if (chunk == null) continue;
                        writer.write(String.format("Chunk at (%d;%d)\n", x, z2));
                        List updates = world.a(chunk, false);
                        writer.write("Pending block updates [" + updates.size() + "]:\n");
                        for (ahs entry : updates) {
                            writer.write(String.format("(%d;%d;%d) at %d with priority %d\n", entry.a, entry.b, entry.c, entry.d, entry.e));
                        }
                    }
                    writer.write("-------------------------\n");
                }
                ((Writer)writer).close();
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Dump saved!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Unknown action");
        }
        return true;
    }

    private static final long mean(long[] array) {
        if (array == null || array.length == 0) {
            return 0L;
        }
        long r = 0L;
        for (long i : array) {
            r += i;
        }
        return r / (long)array.length;
    }
}

