/*
 * Decompiled with CFR 0.152.
 */
package kcauldron;

import cern.colt.function.IntObjectProcedure;
import cern.colt.function.LongObjectProcedure;
import cern.colt.function.ObjectProcedure;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.OpenLongObjectHashMap;

public class ChunkManager {
    private static final int MIN = Short.MIN_VALUE;
    private static final int MAX = Short.MAX_VALUE;
    public OpenIntObjectHashMap loadedChunksLSB = new OpenIntObjectHashMap();
    public OpenLongObjectHashMap loadefChunksMSB = new OpenLongObjectHashMap();

    public apx getChunk(int x, int z2) {
        if (Short.MIN_VALUE <= x && Short.MIN_VALUE <= z2 && x <= Short.MAX_VALUE && z2 <= Short.MAX_VALUE) {
            return (apx)this.loadedChunksLSB.get(x << 16 | z2 & 0xFFFF);
        }
        return (apx)this.loadefChunksMSB.get((long)x << 32 | (long)z2);
    }

    public boolean chunkExists(int x, int z2) {
        if (Short.MIN_VALUE <= x && Short.MIN_VALUE <= z2 && x <= Short.MAX_VALUE && z2 <= Short.MAX_VALUE) {
            return this.loadedChunksLSB.containsKey(x << 16 | z2 & 0xFFFF);
        }
        return this.loadefChunksMSB.containsKey((long)x << 32 | (long)z2);
    }

    public void putChunk(apx chunk) {
        this.putChunk(chunk, chunk.g, chunk.h);
    }

    public void putChunk(apx chunk, int x, int z2) {
        if (Short.MIN_VALUE <= x && Short.MIN_VALUE <= z2 && x <= Short.MAX_VALUE && z2 <= Short.MAX_VALUE) {
            this.loadedChunksLSB.put(x << 16 | z2 & 0xFFFF, (Object)chunk);
        } else {
            this.loadefChunksMSB.put((long)x << 32 | (long)z2, (Object)chunk);
        }
    }

    public boolean removeKey(int x, int z2) {
        if (Short.MIN_VALUE <= x && Short.MIN_VALUE <= z2 && x <= Short.MAX_VALUE && z2 <= Short.MAX_VALUE) {
            return this.loadedChunksLSB.removeKey(x << 16 | z2 & 0xFFFF);
        }
        return this.loadefChunksMSB.removeKey((long)x << 32 | (long)z2);
    }

    public apx remove(int x, int z2) {
        apx chunk = this.getChunk(x, z2);
        return this.removeKey(x, z2) ? chunk : null;
    }

    public int size() {
        return this.loadedChunksLSB.size() + this.loadefChunksMSB.size();
    }

    public void forEach(final ObjectProcedure proc) {
        this.loadedChunksLSB.forEachPair(new IntObjectProcedure(){

            public boolean apply(int arg0, Object arg1) {
                return proc.apply(arg1);
            }
        });
        this.loadefChunksMSB.forEachPair(new LongObjectProcedure(){

            public boolean apply(long arg0, Object arg1) {
                return proc.apply(arg1);
            }
        });
    }
}

