/*
 * Decompiled with CFR 0.152.
 */
package kcauldron;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kcauldron.ChunkCallback;
import net.minecraft.server.MinecraftServer;

public enum ChunkGenerator {
    INSTANCE;

    private final Queue<QueuedChunk> queue = Queues.newArrayDeque();
    private final qd map = new qd();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueChunkGeneration(ms provider, int cx, int cz, ChunkCallback callback) {
        QueuedChunk chunk;
        long key = agu.a((int)cx, (int)cz);
        this.lock.readLock().lock();
        try {
            chunk = (QueuedChunk)this.map.a(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (chunk != null) {
            chunk.callbacks.add(callback);
        } else {
            chunk = new QueuedChunk(provider, cx, cz, callback);
            this.lock.writeLock().lock();
            try {
                this.map.a(key, (Object)chunk);
                this.queue.add(chunk);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void chunkGeneratorCycle() {
        int max = MinecraftServer.kcauldronConfig.commonMaxChunkGenPerTick.getValue();
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < max && this.internalGenerate(); ++i) {
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean generate() {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.internalGenerate();
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean internalGenerate() {
        QueuedChunk chunk;
        while ((chunk = this.queue.poll()) != null) {
            this.map.d(agu.a((int)chunk.cx, (int)chunk.cz));
            if (chunk.provider.loadAsync(chunk.cx, chunk.cz, false, (ChunkCallback)chunk)) continue;
            chunk.onChunkLoaded(chunk.provider.originalLoadChunk(chunk.cx, chunk.cz));
            return true;
        }
        return false;
    }

    private static class QueuedChunk
    implements ChunkCallback {
        public final ms provider;
        public final int cx;
        public final int cz;
        public final List<ChunkCallback> callbacks = Lists.newArrayListWithCapacity((int)1);

        public QueuedChunk(ms provider, int cx, int cz, ChunkCallback callback) {
            this.provider = provider;
            this.cx = cx;
            this.cz = cz;
            this.callbacks.add(callback);
        }

        @Override
        public void onChunkLoaded(apx chunk) {
            for (ChunkCallback cb : this.callbacks) {
                cb.onChunkLoaded(chunk);
            }
        }
    }
}

