/*
 * Decompiled with CFR 0.152.
 */
package kcauldron;

import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kcauldron.BlockCoords;
import kcauldron.BlockUpdateEntry;

public final class BlockUpdatesTracker
implements Iterable<BlockUpdateEntry> {
    private long lastEntryId = Long.MIN_VALUE;
    private final mt world;
    private final NavigableSet<BlockUpdateEntry> sortedTree = new TreeSet<BlockUpdateEntry>();
    private final TLongObjectMap<BlockUpdateEntry> trackerMap = new TLongObjectHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final VanillaWrapper wrapper = new VanillaWrapper();
    public final HashSet<ahs> hashSet = new VanillaHashSetWrapper();
    public final TreeSet<ahs> treeSet = new VanillaTreeSetWrapper();

    public BlockUpdatesTracker(mt world) {
        this.world = world;
    }

    public BlockUpdateEntry allocateEntry(int x, int y, int z2, int priority, long time, aji block) {
        return this.allocateEntry(x, y, z2, priority, time, block, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUpdateEntry allocateEntry(int x, int y, int z2, int priority, long time, aji block, boolean allowChunkTracking) {
        this.lock.writeLock().lock();
        try {
            apx chunk = allowChunkTracking ? this.world.getChunkIfLoaded(x >> 4, z2 >> 4) : null;
            BlockUpdateEntry entry = new BlockUpdateEntry(x, y, z2, priority, time, block, this.lastEntryId++);
            BlockUpdateEntry oldEntry = (BlockUpdateEntry)this.trackerMap.remove(entry.key);
            if (oldEntry != null) {
                this.sortedTree.remove(oldEntry);
                if (chunk != null) {
                    chunk.blockUpdates.remove(oldEntry);
                }
            }
            this.trackerMap.put(entry.key, (Object)entry);
            this.sortedTree.add(entry);
            if (chunk != null) {
                chunk.blockUpdates.add(entry);
            }
            BlockUpdateEntry blockUpdateEntry = entry;
            return blockUpdateEntry;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public BlockUpdateEntry removeEntry(int x, int y, int z2) {
        return this.removeEntry(x, y, z2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUpdateEntry removeEntry(int x, int y, int z2, boolean allowChunkTracking) {
        this.lock.writeLock().lock();
        try {
            apx chunk = allowChunkTracking ? this.world.getChunkIfLoaded(x >> 4, z2 >> 4) : null;
            BlockUpdateEntry entry = (BlockUpdateEntry)this.trackerMap.remove(new BlockCoords((int)x, (int)y, (int)z2).key);
            if (entry != null) {
                this.sortedTree.remove(entry);
                if (chunk != null) {
                    chunk.blockUpdates.remove(entry);
                }
            }
            BlockUpdateEntry blockUpdateEntry = entry;
            return blockUpdateEntry;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUpdateEntry removeEntry(BlockUpdateEntry entry, boolean allowChunkTracking) {
        this.lock.writeLock().lock();
        try {
            apx chunk = allowChunkTracking ? this.world.getChunkIfLoaded(entry.x >> 4, entry.z >> 4) : null;
            this.trackerMap.remove(entry.key);
            if (entry != null) {
                this.sortedTree.remove(entry);
                if (chunk != null) {
                    chunk.blockUpdates.remove(entry);
                }
            }
            BlockUpdateEntry blockUpdateEntry = entry;
            return blockUpdateEntry;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUpdateEntry getEntry(int x, int y, int z2) {
        this.lock.readLock().lock();
        try {
            BlockUpdateEntry blockUpdateEntry = (BlockUpdateEntry)this.trackerMap.get(new BlockCoords((int)x, (int)y, (int)z2).key);
            return blockUpdateEntry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public BlockUpdateEntry peek() {
        this.lock.readLock().lock();
        try {
            BlockUpdateEntry blockUpdateEntry = (BlockUpdateEntry)this.sortedTree.first();
            return blockUpdateEntry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.trackerMap.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.trackerMap.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<BlockUpdateEntry> iterator() {
        return new Iterator<BlockUpdateEntry>(){
            private final Iterator<BlockUpdateEntry> iterator;
            private BlockUpdateEntry next;
            {
                this.iterator = BlockUpdatesTracker.this.sortedTree.iterator();
            }

            @Override
            public boolean hasNext() {
                this.next = null;
                return this.iterator.hasNext();
            }

            @Override
            public BlockUpdateEntry next() {
                this.next = this.iterator.next();
                return this.next;
            }

            @Override
            public void remove() {
                if (this.next == null) {
                    this.next();
                }
                if (this.next != null) {
                    BlockUpdatesTracker.this.removeEntry(this.next, true);
                }
            }
        };
    }

    private final class VanillaTreeSetWrapper
    extends TreeSet<ahs> {
        private VanillaTreeSetWrapper() {
        }

        @Override
        public Iterator<ahs> iterator() {
            return new Iterator<ahs>(){
                private final Iterator<BlockUpdateEntry> iterator;
                private BlockUpdateEntry next;
                {
                    this.iterator = BlockUpdatesTracker.this.sortedTree.iterator();
                }

                @Override
                public boolean hasNext() {
                    this.next = null;
                    return this.iterator.hasNext();
                }

                @Override
                public ahs next() {
                    this.next = this.iterator.next();
                    return this.next.asMCEntry();
                }

                @Override
                public void remove() {
                    if (this.next == null) {
                        this.next();
                    }
                    if (this.next != null) {
                        BlockUpdatesTracker.this.removeEntry(this.next, true);
                    }
                }
            };
        }

        @Override
        public boolean add(ahs e) {
            return BlockUpdatesTracker.this.wrapper.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return BlockUpdatesTracker.this.wrapper.remove((ahs)o);
        }

        @Override
        public boolean contains(Object o) {
            return BlockUpdatesTracker.this.wrapper.contains((ahs)o, false);
        }

        @Override
        public boolean isEmpty() {
            return BlockUpdatesTracker.this.sortedTree.isEmpty();
        }

        @Override
        public int size() {
            return BlockUpdatesTracker.this.sortedTree.size();
        }
    }

    private final class VanillaHashSetWrapper
    extends HashSet<ahs> {
        private VanillaHashSetWrapper() {
        }

        @Override
        public Iterator<ahs> iterator() {
            return new Iterator<ahs>(){
                private final TLongObjectIterator<BlockUpdateEntry> iterator;
                {
                    this.iterator = BlockUpdatesTracker.this.trackerMap.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public ahs next() {
                    this.iterator.advance();
                    return ((BlockUpdateEntry)this.iterator.value()).asMCEntry();
                }

                @Override
                public void remove() {
                    BlockUpdatesTracker.this.removeEntry((BlockUpdateEntry)this.iterator.value(), true);
                }
            };
        }

        @Override
        public boolean add(ahs e) {
            return BlockUpdatesTracker.this.wrapper.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return BlockUpdatesTracker.this.wrapper.remove((ahs)o);
        }

        @Override
        public boolean contains(Object o) {
            return BlockUpdatesTracker.this.wrapper.contains((ahs)o, true);
        }

        @Override
        public boolean isEmpty() {
            return BlockUpdatesTracker.this.sortedTree.isEmpty();
        }

        @Override
        public int size() {
            return BlockUpdatesTracker.this.sortedTree.size();
        }
    }

    private final class VanillaWrapper {
        private Set<ahs> add = new HashSet<ahs>();
        private Set<ahs> remove = new HashSet<ahs>();

        private VanillaWrapper() {
        }

        public boolean add(ahs e) {
            if (this.add.remove(e)) {
                BlockUpdatesTracker.this.allocateEntry(e.a, e.b, e.c, e.e, e.d, e.a());
                return true;
            }
            return this.add.add(e);
        }

        public boolean remove(ahs e) {
            if (this.remove.remove(e)) {
                BlockUpdatesTracker.this.removeEntry(e.a, e.b, e.c);
                return true;
            }
            return this.remove.add(e);
        }

        public boolean contains(ahs e, boolean allowInterscan) {
            if (allowInterscan) {
                if (this.add.contains(e)) {
                    return true;
                }
                if (this.remove.contains(e)) {
                    return false;
                }
            }
            return BlockUpdatesTracker.this.getEntry(e.a, e.b, e.c) != null;
        }
    }
}

