/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.TimedRegisteredListener;

public class CustomTimingsHandler {
    private static final Collection<CustomTimingsHandler> ALL_HANDLERS = new HashSet<CustomTimingsHandler>();
    private static CustomTimingsHandler[] BAKED_HANDLERS;
    private final String name;
    private final CustomTimingsHandler parent;
    private long count = 0L;
    private long start = 0L;
    private long timingDepth = 0L;
    private long totalTime = 0L;
    private long curTickTotal = 0L;
    private long violations = 0L;

    public CustomTimingsHandler(String name) {
        this(name, null);
    }

    public CustomTimingsHandler(String name, CustomTimingsHandler parent) {
        this.name = name;
        this.parent = parent;
        ALL_HANDLERS.add(this);
        BAKED_HANDLERS = ALL_HANDLERS.toArray(new CustomTimingsHandler[ALL_HANDLERS.size()]);
    }

    public static void printTimings(PrintStream printStream) {
        printStream.println("Minecraft");
        for (CustomTimingsHandler timings : BAKED_HANDLERS) {
            long time = timings.totalTime;
            long count = timings.count;
            if (count == 0L) continue;
            long avg = time / count;
            printStream.println("    " + timings.name + " Time: " + time + " Count: " + count + " Avg: " + avg + " Violations: " + timings.violations);
        }
        printStream.println("# Version " + Bukkit.getVersion());
        int entities = 0;
        int livingEntities = 0;
        for (World world : Bukkit.getWorlds()) {
            entities += world.getEntities().size();
            livingEntities += world.getLivingEntities().size();
        }
        printStream.println("# Entities " + entities);
        printStream.println("# LivingEntities " + livingEntities);
    }

    public static void reload() {
        if (Bukkit.getPluginManager().useTimings()) {
            for (CustomTimingsHandler timings : BAKED_HANDLERS) {
                timings.reset();
            }
        }
    }

    public static void tick() {
        if (Bukkit.getPluginManager().useTimings()) {
            for (CustomTimingsHandler timings : BAKED_HANDLERS) {
                if (timings.curTickTotal > 50000000L) {
                    timings.violations = (long)((double)timings.violations + Math.ceil(timings.curTickTotal / 50000000L));
                }
                timings.curTickTotal = 0L;
                timings.timingDepth = 0L;
            }
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                for (RegisteredListener listener : HandlerList.getRegisteredListeners(plugin)) {
                    if (!(listener instanceof TimedRegisteredListener)) continue;
                    TimedRegisteredListener timings = (TimedRegisteredListener)listener;
                    if (timings.curTickTotal > 50000000L) {
                        timings.violations = (long)((double)timings.violations + Math.ceil(timings.curTickTotal / 50000000L));
                    }
                    timings.curTickTotal = 0L;
                }
            }
        }
    }

    public void startTiming() {
        if (Bukkit.getPluginManager().useTimings() && ++this.timingDepth == 1L) {
            this.start = System.nanoTime();
            if (this.parent != null && ++this.parent.timingDepth == 1L) {
                this.parent.start = this.start;
            }
        }
    }

    public void stopTiming() {
        if (Bukkit.getPluginManager().useTimings()) {
            if (--this.timingDepth != 0L || this.start == 0L) {
                return;
            }
            long diff = System.nanoTime() - this.start;
            this.totalTime += diff;
            this.curTickTotal += diff;
            ++this.count;
            this.start = 0L;
            if (this.parent != null) {
                this.parent.stopTiming();
            }
        }
    }

    public void reset() {
        this.count = 0L;
        this.violations = 0L;
        this.curTickTotal = 0L;
        this.totalTime = 0L;
    }
}

