/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import gnu.trove.set.hash.TByteHashSet;
import org.spigotmc.CustomTimingsHandler;
import org.spigotmc.SpigotWorldConfig;

public class AntiXray {
    private static final CustomTimingsHandler update = new CustomTimingsHandler("xray - update");
    private static final CustomTimingsHandler obfuscate = new CustomTimingsHandler("xray - obfuscate");
    private final boolean[] obfuscateBlocks = new boolean[Short.MAX_VALUE];
    private final byte[] replacementOres;

    public AntiXray(SpigotWorldConfig config) {
        for (int id : config.engineMode == 1 ? config.hiddenBlocks : config.replaceBlocks) {
            this.obfuscateBlocks[id] = true;
        }
        TByteHashSet blocks = new TByteHashSet();
        for (Integer i : config.hiddenBlocks) {
            ahu block = ahu.e((int)i);
            if (block == null || block.u()) continue;
            blocks.add((byte)i.intValue());
        }
        this.replacementOres = blocks.toArray();
    }

    public void updateNearbyBlocks(afn world, int x, int y2, int z2) {
        if (world.spigotConfig.antiXray) {
            update.startTiming();
            this.updateNearbyBlocks(world, x, y2, z2, 2, false);
            update.stopTiming();
        }
    }

    public void obfuscate(int chunkX, int chunkZ, int bitmask, byte[] buffer, afn world) {
        if (world.spigotConfig.antiXray) {
            obfuscate.startTiming();
            int initialRadius = 1;
            int index = 0;
            int randomOre = 0;
            int startX = chunkX << 4;
            int startZ = chunkZ << 4;
            for (int i = 0; i < 16; ++i) {
                if ((bitmask & 1 << i) == 0) continue;
                for (int y2 = 0; y2 < 16; ++y2) {
                    for (int z2 = 0; z2 < 16; ++z2) {
                        for (int x = 0; x < 16; ++x) {
                            if (index >= buffer.length) continue;
                            int blockId = buffer[index] & 0xFF;
                            if (this.obfuscateBlocks[blockId]) {
                                if (initialRadius != 0 && !AntiXray.isLoaded(world, startX + x, (i << 4) + y2, startZ + z2, initialRadius)) continue;
                                if (initialRadius == 0 || !AntiXray.hasTransparentBlockAdjacent(world, startX + x, (i << 4) + y2, startZ + z2, initialRadius)) {
                                    switch (world.spigotConfig.engineMode) {
                                        case 1: {
                                            buffer[index] = 1;
                                            break;
                                        }
                                        case 2: {
                                            if (randomOre >= this.replacementOres.length) {
                                                randomOre = 0;
                                            }
                                            buffer[index] = this.replacementOres[randomOre++];
                                        }
                                    }
                                }
                            }
                            ++index;
                        }
                    }
                }
            }
            obfuscate.stopTiming();
        }
    }

    private void updateNearbyBlocks(afn world, int x, int y2, int z2, int radius, boolean updateSelf) {
        if (world.d(x, y2, z2)) {
            ahu block = world.a(x, y2, z2);
            if (updateSelf && this.obfuscateBlocks[ahu.b((ahu)block)]) {
                world.g(x, y2, z2);
            }
            if (radius > 0) {
                this.updateNearbyBlocks(world, x + 1, y2, z2, radius - 1, true);
                this.updateNearbyBlocks(world, x - 1, y2, z2, radius - 1, true);
                this.updateNearbyBlocks(world, x, y2 + 1, z2, radius - 1, true);
                this.updateNearbyBlocks(world, x, y2 - 1, z2, radius - 1, true);
                this.updateNearbyBlocks(world, x, y2, z2 + 1, radius - 1, true);
                this.updateNearbyBlocks(world, x, y2, z2 - 1, radius - 1, true);
            }
        }
    }

    private static boolean isLoaded(afn world, int x, int y2, int z2, int radius) {
        return world.d(x, y2, z2) || radius > 0 && (AntiXray.isLoaded(world, x + 1, y2, z2, radius - 1) || AntiXray.isLoaded(world, x - 1, y2, z2, radius - 1) || AntiXray.isLoaded(world, x, y2 + 1, z2, radius - 1) || AntiXray.isLoaded(world, x, y2 - 1, z2, radius - 1) || AntiXray.isLoaded(world, x, y2, z2 + 1, radius - 1) || AntiXray.isLoaded(world, x, y2, z2 - 1, radius - 1));
    }

    private static boolean hasTransparentBlockAdjacent(afn world, int x, int y2, int z2, int radius) {
        return !world.a(x, y2, z2).r() || radius > 0 && (AntiXray.hasTransparentBlockAdjacent(world, x + 1, y2, z2, radius - 1) || AntiXray.hasTransparentBlockAdjacent(world, x - 1, y2, z2, radius - 1) || AntiXray.hasTransparentBlockAdjacent(world, x, y2 + 1, z2, radius - 1) || AntiXray.hasTransparentBlockAdjacent(world, x, y2 - 1, z2, radius - 1) || AntiXray.hasTransparentBlockAdjacent(world, x, y2, z2 + 1, radius - 1) || AntiXray.hasTransparentBlockAdjacent(world, x, y2, z2 - 1, radius - 1));
    }
}

