/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R1.projectiles;

import java.util.Random;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_7_R1.inventory.CraftItemStack;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.WitherSkull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final ann dispenserBlock;

    public CraftBlockProjectileSource(ann dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    @Override
    public Block getBlock() {
        return this.dispenserBlock.w().getWorld().getBlockAt(this.dispenserBlock.c, this.dispenserBlock.d, this.dispenserBlock.e);
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Validate.isTrue((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (String)"Block is no longer dispenser");
        ck isourceblock = new ck(this.dispenserBlock.w(), this.dispenserBlock.c, this.dispenserBlock.d, this.dispenserBlock.e);
        cw iposition = aiy.a((cj)isourceblock);
        cq enumfacing = aiy.b((int)isourceblock.h());
        afn world = this.dispenserBlock.w();
        xv launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new xv(world, iposition.a(), iposition.b(), iposition.c());
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new xx(world, iposition.a(), iposition.b(), iposition.c());
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new xy(world);
            launch.b(iposition.a(), iposition.b(), iposition.c());
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new xz(world, iposition.a(), iposition.b(), iposition.c());
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            launch = new ya(world, iposition.a(), iposition.b(), iposition.c(), CraftItemStack.asNMSCopy(new ItemStack(Material.POTION, 1)));
        } else if (Arrow.class.isAssignableFrom(projectile)) {
            launch = new xo(world, iposition.a(), iposition.b(), iposition.c());
            ((xo)launch).a = 1;
            ((xo)launch).projectileSource = this;
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            double d0 = iposition.a() + (double)((float)enumfacing.c() * 0.3f);
            double d1 = iposition.b() + (double)((float)enumfacing.c() * 0.3f);
            double d2 = iposition.c() + (double)((float)enumfacing.e() * 0.3f);
            Random random = world.s;
            double d3 = random.nextGaussian() * 0.05 + (double)enumfacing.c();
            double d4 = random.nextGaussian() * 0.05 + (double)enumfacing.d();
            double d5 = random.nextGaussian() * 0.05 + (double)enumfacing.e();
            if (SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new xu(world, d0, d1, d2, d3, d4, d5);
            } else if (WitherSkull.class.isAssignableFrom(projectile)) {
                launch = new yb(world);
                launch.b(d0, d1, d2);
                double d6 = ou.a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                ((xq)launch).b = d3 / d6 * 0.1;
                ((xq)launch).c = d4 / d6 * 0.1;
                ((xq)launch).d = d5 / d6 * 0.1;
            } else {
                launch = new xs(world);
                launch.b(d0, d1, d2);
                double d6 = ou.a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                ((xq)launch).b = d3 / d6 * 0.1;
                ((xq)launch).c = d4 / d6 * 0.1;
                ((xq)launch).d = d5 / d6 * 0.1;
            }
            ((xq)launch).projectileSource = this;
        }
        Validate.notNull((Object)launch, (String)"Projectile not supported");
        if (launch instanceof xt) {
            if (launch instanceof xw) {
                ((xw)launch).projectileSource = this;
            }
            float a2 = 6.0f;
            float b2 = 1.1f;
            if (launch instanceof ya || launch instanceof ThrownExpBottle) {
                a2 *= 0.5f;
                b2 *= 1.25f;
            }
            ((xt)launch).c((double)enumfacing.c(), (double)((float)enumfacing.d() + 0.1f), (double)enumfacing.e(), b2, a2);
        }
        if (velocity != null) {
            ((Projectile)((Object)launch.getBukkitEntity())).setVelocity(velocity);
        }
        world.d((qn)launch);
        return (T)((Projectile)((Object)launch.getBukkitEntity()));
    }
}

