/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R1.entity;

import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_7_R1.CraftServer;
import org.bukkit.craftbukkit.v1_7_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_7_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_7_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_7_R1.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_7_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_7_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_7_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_7_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase(this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, xl entity) {
        super(server, (rh)entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.bn);
        this.enderChest = new CraftInventory((po)entity.bQ());
    }

    @Override
    public String getName() {
        return this.getHandle().b_();
    }

    @Override
    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    @Override
    public Inventory getEnderChest() {
        return this.enderChest;
    }

    @Override
    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    @Override
    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    @Override
    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().bn.o());
    }

    @Override
    public void setItemOnCursor(ItemStack item) {
        abp stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().bn.b(stack);
        if (this instanceof CraftPlayer) {
            ((mm)this.getHandle()).l();
        }
    }

    @Override
    public boolean isSleeping() {
        return this.getHandle().bB;
    }

    @Override
    public int getSleepTicks() {
        return this.getHandle().b;
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    @Override
    public GameMode getGameMode() {
        return this.mode;
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.mode = mode;
    }

    public xl getHandle() {
        return (xl)this.entity;
    }

    public void setHandle(xl entity) {
        super.setHandle((rh)entity);
        this.inventory = new CraftInventoryPlayer(entity.bn);
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + '}';
    }

    @Override
    public InventoryView getOpenInventory() {
        return this.getHandle().bp.getBukkitView();
    }

    @Override
    public InventoryView openInventory(Inventory inventory) {
        if (!(this.getHandle() instanceof mm)) {
            return null;
        }
        mm player = (mm)this.getHandle();
        InventoryType type = inventory.getType();
        ye formerContainer = this.getHandle().bp;
        CraftInventory craftinv = (CraftInventory)inventory;
        switch (type) {
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: {
                this.getHandle().a(craftinv.getInventory());
                break;
            }
            case DISPENSER: {
                if (craftinv.getInventory() instanceof ann) {
                    this.getHandle().a((ann)craftinv.getInventory());
                    break;
                }
                this.openCustomInventory(inventory, player, 3);
                break;
            }
            case FURNACE: {
                if (craftinv.getInventory() instanceof ans) {
                    this.getHandle().a((ans)craftinv.getInventory());
                    break;
                }
                this.openCustomInventory(inventory, player, 2);
                break;
            }
            case WORKBENCH: {
                this.openCustomInventory(inventory, player, 1);
                break;
            }
            case BREWING: {
                if (craftinv.getInventory() instanceof anh) {
                    this.getHandle().a((anh)craftinv.getInventory());
                    break;
                }
                this.openCustomInventory(inventory, player, 5);
                break;
            }
            case ENCHANTING: {
                this.openCustomInventory(inventory, player, 4);
                break;
            }
            case HOPPER: {
                if (craftinv.getInventory() instanceof anu) {
                    this.getHandle().a((anu)craftinv.getInventory());
                    break;
                }
                if (craftinv.getInventory() instanceof wd) {
                    this.getHandle().a((wd)craftinv.getInventory());
                    break;
                }
                this.openCustomInventory(inventory, player, 9);
                break;
            }
            case CREATIVE: 
            case CRAFTING: {
                throw new IllegalArgumentException("Can't open a " + (Object)((Object)type) + " inventory!");
            }
        }
        if (this.getHandle().bp == formerContainer) {
            return null;
        }
        this.getHandle().bp.checkReachable = false;
        return this.getHandle().bp.getBukkitView();
    }

    private void openCustomInventory(Inventory inventory, mm player, int windowType) {
        if (player.a == null) {
            return;
        }
        CraftContainer container = new CraftContainer(inventory, this, player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        String title = container.getBukkitView().getTitle();
        int size = container.getBukkitView().getTopInventory().getSize();
        player.a.a((fk)new ge(container.d, windowType, title, size, true));
        this.getHandle().bp = container;
        this.getHandle().bp.a((yo)player);
    }

    @Override
    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (!force && (block = location.getBlock()).getType() != Material.WORKBENCH) {
            return null;
        }
        if (location == null) {
            location = this.getLocation();
        }
        this.getHandle().b(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        if (force) {
            this.getHandle().bp.checkReachable = false;
        }
        return this.getHandle().bp.getBukkitView();
    }

    @Override
    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTMENT_TABLE) {
            return null;
        }
        if (location == null) {
            location = this.getLocation();
        }
        this.getHandle().a(location.getBlockX(), location.getBlockY(), location.getBlockZ(), null);
        if (force) {
            this.getHandle().bp.checkReachable = false;
        }
        return this.getHandle().bp.getBukkitView();
    }

    @Override
    public void openInventory(InventoryView inventory) {
        if (!(this.getHandle() instanceof mm)) {
            return;
        }
        if (((mm)this.getHandle()).a == null) {
            return;
        }
        if (this.getHandle().bp != this.getHandle().bo) {
            ((mm)this.getHandle()).a.a(new im(this.getHandle().bp.d));
        }
        mm player = (mm)this.getHandle();
        Object container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        InventoryType type = inventory.getType();
        int windowType = CraftContainer.getNotchInventoryType(type);
        String title = inventory.getTitle();
        int size = inventory.getTopInventory().getSize();
        player.a.a((fk)new ge(container.d, windowType, title, size, false));
        player.bp = container;
        player.bp.a((yo)player);
    }

    @Override
    public void closeInventory() {
        this.getHandle().k();
    }

    @Override
    public boolean isBlocking() {
        return this.getHandle().bA();
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    @Override
    public int getExpToLevel() {
        return this.getHandle().bN();
    }
}

