/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R1.block;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.cauldron.block.CraftCustomContainer;
import net.minecraftforge.cauldron.configuration.CauldronConfig;
import net.minecraftforge.common.util.EnumHelper;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_7_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_7_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftChest;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftDropper;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftFurnace;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftHopper;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftNoteBlock;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_7_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_7_R1.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;

public class CraftBlock
implements Block {
    private final CraftChunk chunk;
    private final int x;
    private final int y;
    private final int z;
    private static final Biome[] BIOME_MAPPING = new Biome[agg.n().length];
    private static final agg[] BIOMEBASE_MAPPING = new agg[agg.n().length];

    public CraftBlock(CraftChunk chunk, int x, int y2, int z2) {
        this.x = x;
        this.y = y2;
        this.z = z2;
        this.chunk = chunk;
    }

    private ahu getNMSBlock() {
        return CraftMagicNumbers.getBlock(this);
    }

    private static ahu getNMSBlock(int type) {
        return CraftMagicNumbers.getBlock(type);
    }

    @Override
    public World getWorld() {
        return this.chunk.getWorld();
    }

    @Override
    public Location getLocation() {
        return new Location(this.getWorld(), this.x, this.y, this.z);
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.x);
            loc.setY(this.y);
            loc.setZ(this.z);
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public BlockVector getVector() {
        return new BlockVector(this.x, this.y, this.z);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public Chunk getChunk() {
        return this.chunk;
    }

    @Override
    public void setData(byte data) {
        this.chunk.getHandle().e.a(this.x, this.y, this.z, (int)data, 3);
    }

    @Override
    public void setData(byte data, boolean applyPhysics) {
        if (applyPhysics) {
            this.chunk.getHandle().e.a(this.x, this.y, this.z, (int)data, 3);
        } else {
            this.chunk.getHandle().e.a(this.x, this.y, this.z, (int)data, 2);
        }
    }

    @Override
    public byte getData() {
        return (byte)this.chunk.getHandle().c(this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    @Override
    public void setType(Material type) {
        this.setTypeId(type.getId());
    }

    @Override
    public boolean setTypeId(int type) {
        return this.setTypeId(type, true);
    }

    @Override
    public boolean setTypeId(int type, boolean applyPhysics) {
        return this.setTypeIdAndData(type, this.getData(), applyPhysics);
    }

    @Override
    public boolean setTypeIdAndData(int type, byte data, boolean applyPhysics) {
        if (applyPhysics) {
            return this.chunk.getHandle().e.d(this.x, this.y, this.z, CraftBlock.getNMSBlock(type), (int)data, 3);
        }
        boolean success = this.chunk.getHandle().e.d(this.x, this.y, this.z, CraftBlock.getNMSBlock(type), (int)data, 2);
        if (success) {
            this.chunk.getHandle().e.g(this.x, this.y, this.z);
        }
        return success;
    }

    @Override
    public Material getType() {
        return Material.getMaterial(this.getTypeId());
    }

    @Override
    @Deprecated
    public int getTypeId() {
        return CraftMagicNumbers.getId(this.chunk.getHandle().a(this.x & 0xF, this.y & 0xFF, this.z & 0xF));
    }

    @Override
    public byte getLightLevel() {
        return (byte)this.chunk.getHandle().e.k(this.x, this.y, this.z);
    }

    @Override
    public byte getLightFromSky() {
        return (byte)this.chunk.getHandle().a(afz.a, this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    @Override
    public byte getLightFromBlocks() {
        return (byte)this.chunk.getHandle().a(afz.b, this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    public Block getFace(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getFace(BlockFace face, int distance) {
        return this.getRelative(face, distance);
    }

    @Override
    public Block getRelative(int modX, int modY, int modZ) {
        return this.getWorld().getBlockAt(this.getX() + modX, this.getY() + modY, this.getZ() + modZ);
    }

    @Override
    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    @Override
    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    @Override
    public BlockFace getFace(Block block) {
        BlockFace[] values;
        for (BlockFace face : values = BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    public String toString() {
        return "CraftBlock{chunk=" + this.chunk + ",x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",type=" + (Object)((Object)this.getType()) + ",data=" + this.getData() + '}';
    }

    public static BlockFace notchToBlockFace(int notch) {
        switch (notch) {
            case 0: {
                return BlockFace.DOWN;
            }
            case 1: {
                return BlockFace.UP;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
            case 4: {
                return BlockFace.WEST;
            }
            case 5: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static int blockFaceToNotch(BlockFace face) {
        switch (face) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return 7;
    }

    @Override
    public BlockState getState() {
        Material material = this.getType();
        if (material == null) {
            and te = ((CraftWorld)this.getWorld()).getHandle().o(this.getX(), this.getY(), this.getZ());
            if (te != null && te instanceof po) {
                return new CraftCustomContainer(this);
            }
            return new CraftBlockState(this);
        }
        switch (material) {
            case SIGN: 
            case SIGN_POST: 
            case WALL_SIGN: {
                return new CraftSign(this);
            }
            case CHEST: 
            case TRAPPED_CHEST: {
                return new CraftChest(this);
            }
            case BURNING_FURNACE: 
            case FURNACE: {
                return new CraftFurnace(this);
            }
            case DISPENSER: {
                return new CraftDispenser(this);
            }
            case DROPPER: {
                return new CraftDropper(this);
            }
            case HOPPER: {
                return new CraftHopper(this);
            }
            case MOB_SPAWNER: {
                return new CraftCreatureSpawner(this);
            }
            case NOTE_BLOCK: {
                return new CraftNoteBlock(this);
            }
            case JUKEBOX: {
                return new CraftJukebox(this);
            }
            case BREWING_STAND: {
                return new CraftBrewingStand(this);
            }
            case SKULL: {
                return new CraftSkull(this);
            }
            case COMMAND: {
                return new CraftCommandBlock(this);
            }
            case BEACON: {
                return new CraftBeacon(this);
            }
        }
        and te = ((CraftWorld)this.getWorld()).getHandle().o(this.getX(), this.getY(), this.getZ());
        if (te != null && te instanceof po) {
            return new CraftCustomContainer(this);
        }
        return new CraftBlockState(this);
    }

    @Override
    public Biome getBiome() {
        return this.getWorld().getBiome(this.x, this.z);
    }

    @Override
    public void setBiome(Biome bio) {
        this.getWorld().setBiome(this.x, this.z, bio);
    }

    public static Biome biomeBaseToBiome(agg base) {
        if (base == null) {
            return null;
        }
        return BIOME_MAPPING[base.ay];
    }

    public static agg biomeToBiomeBase(Biome bio) {
        if (bio == null) {
            return null;
        }
        return BIOMEBASE_MAPPING[bio.ordinal()];
    }

    @Override
    public double getTemperature() {
        return this.getWorld().getTemperature(this.x, this.z);
    }

    @Override
    public double getHumidity() {
        return this.getWorld().getHumidity(this.x, this.z);
    }

    @Override
    public boolean isBlockPowered() {
        return this.chunk.getHandle().e.u(this.x, this.y, this.z) > 0;
    }

    @Override
    public boolean isBlockIndirectlyPowered() {
        return this.chunk.getHandle().e.v(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftBlock)) {
            return false;
        }
        CraftBlock other = (CraftBlock)o;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        return this.y << 24 ^ this.x ^ this.z ^ this.getWorld().hashCode();
    }

    @Override
    public boolean isBlockFacePowered(BlockFace face) {
        return this.chunk.getHandle().e.f(this.x, this.y, this.z, CraftBlock.blockFaceToNotch(face));
    }

    @Override
    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        int power = this.chunk.getHandle().e.g(this.x, this.y, this.z, CraftBlock.blockFaceToNotch(face));
        Block relative = this.getRelative(face);
        if (relative.getType() == Material.REDSTONE_WIRE) {
            return Math.max(power, relative.getData()) > 0;
        }
        return power > 0;
    }

    @Override
    public int getBlockPower(BlockFace face) {
        int power = 0;
        alm wire = ahz.af;
        afn world = this.chunk.getHandle().e;
        if ((face == BlockFace.DOWN || face == BlockFace.SELF) && world.f(this.x, this.y - 1, this.z, 0)) {
            power = wire.a(world, this.x, this.y - 1, this.z, power);
        }
        if ((face == BlockFace.UP || face == BlockFace.SELF) && world.f(this.x, this.y + 1, this.z, 1)) {
            power = wire.a(world, this.x, this.y + 1, this.z, power);
        }
        if ((face == BlockFace.EAST || face == BlockFace.SELF) && world.f(this.x + 1, this.y, this.z, 2)) {
            power = wire.a(world, this.x + 1, this.y, this.z, power);
        }
        if ((face == BlockFace.WEST || face == BlockFace.SELF) && world.f(this.x - 1, this.y, this.z, 3)) {
            power = wire.a(world, this.x - 1, this.y, this.z, power);
        }
        if ((face == BlockFace.NORTH || face == BlockFace.SELF) && world.f(this.x, this.y, this.z - 1, 4)) {
            power = wire.a(world, this.x, this.y, this.z - 1, power);
        }
        if ((face == BlockFace.SOUTH || face == BlockFace.SELF) && world.f(this.x, this.y, this.z + 1, 5)) {
            power = wire.a(world, this.x, this.y, this.z - 1, power);
        }
        return power > 0 ? power : ((face == BlockFace.SELF ? this.isBlockIndirectlyPowered() : this.isBlockFaceIndirectlyPowered(face)) ? 15 : 0);
    }

    @Override
    public int getBlockPower() {
        return this.getBlockPower(BlockFace.SELF);
    }

    @Override
    public boolean isEmpty() {
        if (this.getType() == Material.AIR) {
            return true;
        }
        if (!(this.getWorld() instanceof CraftWorld)) {
            return false;
        }
        return ((CraftWorld)this.getWorld()).getHandle().c(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public boolean isLiquid() {
        return this.getType() == Material.WATER || this.getType() == Material.STATIONARY_WATER || this.getType() == Material.LAVA || this.getType() == Material.STATIONARY_LAVA;
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(this.getNMSBlock().o().m());
    }

    private boolean itemCausesDrops(ItemStack item) {
        ahu block = this.getNMSBlock();
        abn itemType = item != null ? abn.d((int)item.getTypeId()) : null;
        return block != null && (block.o().l() || itemType != null && itemType.b(block));
    }

    @Override
    public boolean breakNaturally() {
        ahu block = this.getNMSBlock();
        byte data = this.getData();
        boolean result = false;
        if (block != null && block != ahz.a) {
            block.a(this.chunk.getHandle().e, this.x, this.y, this.z, (int)data, 1.0f, 0);
            result = true;
        }
        this.setTypeId(Material.AIR.getId());
        return result;
    }

    @Override
    public boolean breakNaturally(ItemStack item) {
        if (this.itemCausesDrops(item)) {
            return this.breakNaturally();
        }
        return this.setTypeId(Material.AIR.getId());
    }

    @Override
    public Collection<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ahu block = this.getNMSBlock();
        if (block != ahz.a) {
            byte data = this.getData();
            int count = block.a(0, this.chunk.getHandle().e.s);
            for (int i = 0; i < count; ++i) {
                abn item = block.a((int)data, this.chunk.getHandle().e.s, 0);
                if (item == null) continue;
                if (ahz.bP == block) {
                    abp nmsStack = new abp(item, 1, block.k(this.chunk.getHandle().e, this.x, this.y, this.z));
                    anz tileentityskull = (anz)this.chunk.getHandle().e.o(this.x, this.y, this.z);
                    if (tileentityskull.a() == 3 && tileentityskull.c() != null && tileentityskull.c().length() > 0) {
                        nmsStack.d(new dg());
                        nmsStack.q().a("SkullOwner", tileentityskull.c());
                    }
                    drops.add(CraftItemStack.asBukkitCopy(nmsStack));
                    continue;
                }
                if (ahz.by == block) {
                    int dropAmount = ail.c((int)data) >= 2 ? 3 : 1;
                    for (int j = 0; j < dropAmount; ++j) {
                        drops.add(new ItemStack(Material.INK_SACK, 1, 3));
                    }
                    continue;
                }
                drops.add(new ItemStack(CraftMagicNumbers.getMaterial(item), 1, (short)block.a((int)data)));
            }
        }
        return drops;
    }

    @Override
    public Collection<ItemStack> getDrops(ItemStack item) {
        if (this.itemCausesDrops(item)) {
            return this.getDrops();
        }
        return Collections.emptyList();
    }

    public static void initMappings() {
        CraftBlock.BIOME_MAPPING[agg.u.ay] = Biome.SWAMPLAND;
        CraftBlock.BIOME_MAPPING[agg.s.ay] = Biome.FOREST;
        CraftBlock.BIOME_MAPPING[agg.t.ay] = Biome.TAIGA;
        CraftBlock.BIOME_MAPPING[agg.q.ay] = Biome.DESERT;
        CraftBlock.BIOME_MAPPING[agg.p.ay] = Biome.PLAINS;
        CraftBlock.BIOME_MAPPING[agg.w.ay] = Biome.HELL;
        CraftBlock.BIOME_MAPPING[agg.x.ay] = Biome.SKY;
        CraftBlock.BIOME_MAPPING[agg.v.ay] = Biome.RIVER;
        CraftBlock.BIOME_MAPPING[agg.r.ay] = Biome.EXTREME_HILLS;
        CraftBlock.BIOME_MAPPING[agg.o.ay] = Biome.OCEAN;
        CraftBlock.BIOME_MAPPING[agg.y.ay] = Biome.FROZEN_OCEAN;
        CraftBlock.BIOME_MAPPING[agg.z.ay] = Biome.FROZEN_RIVER;
        CraftBlock.BIOME_MAPPING[agg.A.ay] = Biome.ICE_PLAINS;
        CraftBlock.BIOME_MAPPING[agg.B.ay] = Biome.ICE_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.C.ay] = Biome.MUSHROOM_ISLAND;
        CraftBlock.BIOME_MAPPING[agg.D.ay] = Biome.MUSHROOM_SHORE;
        CraftBlock.BIOME_MAPPING[agg.E.ay] = Biome.BEACH;
        CraftBlock.BIOME_MAPPING[agg.F.ay] = Biome.DESERT_HILLS;
        CraftBlock.BIOME_MAPPING[agg.G.ay] = Biome.FOREST_HILLS;
        CraftBlock.BIOME_MAPPING[agg.H.ay] = Biome.TAIGA_HILLS;
        CraftBlock.BIOME_MAPPING[agg.I.ay] = Biome.SMALL_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.J.ay] = Biome.JUNGLE;
        CraftBlock.BIOME_MAPPING[agg.K.ay] = Biome.JUNGLE_HILLS;
        CraftBlock.BIOME_MAPPING[agg.L.ay] = Biome.JUNGLE_EDGE;
        CraftBlock.BIOME_MAPPING[agg.M.ay] = Biome.DEEP_OCEAN;
        CraftBlock.BIOME_MAPPING[agg.N.ay] = Biome.STONE_BEACH;
        CraftBlock.BIOME_MAPPING[agg.O.ay] = Biome.COLD_BEACH;
        CraftBlock.BIOME_MAPPING[agg.P.ay] = Biome.BIRCH_FOREST;
        CraftBlock.BIOME_MAPPING[agg.Q.ay] = Biome.BIRCH_FOREST_HILLS;
        CraftBlock.BIOME_MAPPING[agg.R.ay] = Biome.ROOFED_FOREST;
        CraftBlock.BIOME_MAPPING[agg.S.ay] = Biome.COLD_TAIGA;
        CraftBlock.BIOME_MAPPING[agg.T.ay] = Biome.COLD_TAIGA_HILLS;
        CraftBlock.BIOME_MAPPING[agg.U.ay] = Biome.MEGA_TAIGA;
        CraftBlock.BIOME_MAPPING[agg.V.ay] = Biome.MEGA_TAIGA_HILLS;
        CraftBlock.BIOME_MAPPING[agg.W.ay] = Biome.EXTREME_HILLS_PLUS;
        CraftBlock.BIOME_MAPPING[agg.X.ay] = Biome.SAVANNA;
        CraftBlock.BIOME_MAPPING[agg.Y.ay] = Biome.SAVANNA_PLATEAU;
        CraftBlock.BIOME_MAPPING[agg.Z.ay] = Biome.MESA;
        CraftBlock.BIOME_MAPPING[agg.aa.ay] = Biome.MESA_PLATEAU_FOREST;
        CraftBlock.BIOME_MAPPING[agg.ab.ay] = Biome.MESA_PLATEAU;
        CraftBlock.BIOME_MAPPING[agg.p.ay + 128] = Biome.SUNFLOWER_PLAINS;
        CraftBlock.BIOME_MAPPING[agg.q.ay + 128] = Biome.DESERT_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.s.ay + 128] = Biome.FLOWER_FOREST;
        CraftBlock.BIOME_MAPPING[agg.t.ay + 128] = Biome.TAIGA_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.u.ay + 128] = Biome.SWAMPLAND_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.A.ay + 128] = Biome.ICE_PLAINS_SPIKES;
        CraftBlock.BIOME_MAPPING[agg.J.ay + 128] = Biome.JUNGLE_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.L.ay + 128] = Biome.JUNGLE_EDGE_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.S.ay + 128] = Biome.COLD_TAIGA_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.X.ay + 128] = Biome.SAVANNA_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.Y.ay + 128] = Biome.SAVANNA_PLATEAU_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.Z.ay + 128] = Biome.MESA_BRYCE;
        CraftBlock.BIOME_MAPPING[agg.aa.ay + 128] = Biome.MESA_PLATEAU_FOREST_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.ab.ay + 128] = Biome.MESA_PLATEAU_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.P.ay + 128] = Biome.BIRCH_FOREST_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.Q.ay + 128] = Biome.BIRCH_FOREST_HILLS_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.R.ay + 128] = Biome.ROOFED_FOREST_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.U.ay + 128] = Biome.MEGA_SPRUCE_TAIGA;
        CraftBlock.BIOME_MAPPING[agg.r.ay + 128] = Biome.EXTREME_HILLS_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.W.ay + 128] = Biome.EXTREME_HILLS_PLUS_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[agg.V.ay + 128] = Biome.MEGA_SPRUCE_TAIGA_HILLS;
        for (int i = 0; i < BIOME_MAPPING.length; ++i) {
            if (agg.d((int)i) != null && BIOME_MAPPING[i] == null) {
                String name = agg.d((int)i).af;
                int id = agg.d((int)i).ay;
                System.out.println("Adding biome mapping " + agg.d((int)i).ay + " " + name + " at BiomeBase[" + i + "]");
                EnumHelper.addBukkitBiome(name);
                CraftBlock.BIOME_MAPPING[agg.d((int)i).ay] = Enum.valueOf(Biome.class, name);
            }
            if (BIOME_MAPPING[i] == null) continue;
            CraftBlock.BIOMEBASE_MAPPING[CraftBlock.BIOME_MAPPING[i].ordinal()] = agg.d((int)i);
        }
    }

    public static void dumpMaterials() {
        if (CauldronConfig.dumpMaterials.getValue().booleanValue()) {
            FMLLog.info("Cauldron Dump Materials is ENABLED. Starting dump...", new Object[0]);
            for (int i = 0; i < 32000; ++i) {
                Material material = Material.getMaterial(i);
                if (material == null) continue;
                FMLLog.info("Found material " + (Object)((Object)material) + " with ID " + i, new Object[0]);
            }
            FMLLog.info("Cauldron Dump Materials complete.", new Object[0]);
            FMLLog.info("To disable these dumps, set cauldron.dump-materials to false in bukkit.yml.", new Object[0]);
        }
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.chunk.getCraftWorld().getBlockMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.chunk.getCraftWorld().getBlockMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }
}

