/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public class SpreadPlayersCommand
extends VanillaCommand {
    private static final Random random = new Random();

    public SpreadPlayersCommand() {
        super("spreadplayers");
        this.description = "Spreads players around a point";
        this.usageMessage = "/spreadplayers <x> <z> <spreadDistance> <maxRange> <respectTeams true|false> <player ...>";
        this.setPermission("bukkit.command.spreadplayers");
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 6) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        double x = SpreadPlayersCommand.getDouble(sender, args[0], -3.0E7, 3.0E7);
        double z2 = SpreadPlayersCommand.getDouble(sender, args[1], -3.0E7, 3.0E7);
        double distance = SpreadPlayersCommand.getDouble(sender, args[2]);
        double range = SpreadPlayersCommand.getDouble(sender, args[3]);
        if (distance < 0.0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Distance is too small.");
            return false;
        }
        if (range < distance + 1.0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Max range is too small.");
            return false;
        }
        String respectTeams = args[4];
        boolean teams = false;
        if (respectTeams.equalsIgnoreCase("true")) {
            teams = true;
        } else if (!respectTeams.equalsIgnoreCase("false")) {
            sender.sendMessage(String.format((Object)((Object)ChatColor.RED) + "'%s' is not true or false", args[4]));
            return false;
        }
        ArrayList players = Lists.newArrayList();
        World world = null;
        for (int i = 5; i < args.length; ++i) {
            Player player = Bukkit.getPlayerExact(args[i]);
            if (player == null) continue;
            if (world == null) {
                world = player.getWorld();
            }
            players.add(player);
        }
        if (world == null) {
            return true;
        }
        double xRangeMin = x - range;
        double zRangeMin = z2 - range;
        double xRangeMax = x + range;
        double zRangeMax = z2 + range;
        int spreadSize = teams ? this.getTeams(players) : players.size();
        Location[] locations = this.getSpreadLocations(world, spreadSize, xRangeMin, zRangeMin, xRangeMax, zRangeMax);
        int rangeSpread = this.range(world, distance, xRangeMin, zRangeMin, xRangeMax, zRangeMax, locations);
        if (rangeSpread == -1) {
            sender.sendMessage(String.format("Could not spread %d %s around %s,%s (too many players for space - try using spread of at most %s)", spreadSize, teams ? "teams" : "players", x, z2));
            return false;
        }
        double distanceSpread = this.spread(world, players, locations, teams);
        sender.sendMessage(String.format("Succesfully spread %d %s around %s,%s", locations.length, teams ? "teams" : "players", x, z2));
        if (locations.length > 1) {
            sender.sendMessage(String.format("(Average distance between %s is %s blocks apart after %s iterations)", teams ? "teams" : "players", String.format("%.2f", distanceSpread), rangeSpread));
        }
        return true;
    }

    private int range(World world, double distance, double xRangeMin, double zRangeMin, double xRangeMax, double zRangeMax, Location[] locations) {
        int i;
        boolean flag = true;
        for (i = 0; i < 10000 && flag; ++i) {
            Location loc1;
            int j;
            flag = false;
            double max = 3.4028234663852886E38;
            for (int k2 = 0; k2 < locations.length; ++k2) {
                Location loc2 = locations[k2];
                j = 0;
                loc1 = new Location(world, 0.0, 0.0, 0.0);
                for (int l = 0; l < locations.length; ++l) {
                    if (k2 == l) continue;
                    Location loc3 = locations[l];
                    double dis = loc2.distanceSquared(loc3);
                    max = Math.min(dis, max);
                    if (!(dis < distance)) continue;
                    ++j;
                    loc1.add(loc3.getX() - loc2.getX(), 0.0, 0.0);
                    loc1.add(loc3.getZ() - loc2.getZ(), 0.0, 0.0);
                }
                if (j > 0) {
                    loc2.setX(loc2.getX() / (double)j);
                    loc2.setZ(loc2.getZ() / (double)j);
                    double d7 = Math.sqrt(loc1.getX() * loc1.getX() + loc1.getZ() * loc1.getZ());
                    if (d7 > 0.0) {
                        loc1.setX(loc1.getX() / d7);
                        loc2.add(-loc1.getX(), 0.0, -loc1.getZ());
                    } else {
                        double x = xRangeMin >= xRangeMax ? xRangeMin : random.nextDouble() * (xRangeMax - xRangeMin) + xRangeMin;
                        double z2 = zRangeMin >= zRangeMax ? zRangeMin : random.nextDouble() * (zRangeMax - zRangeMin) + zRangeMin;
                        loc2.setX(x);
                        loc2.setZ(z2);
                    }
                    flag = true;
                }
                boolean swap = false;
                if (loc2.getX() < xRangeMin) {
                    loc2.setX(xRangeMin);
                    swap = true;
                } else if (loc2.getX() > xRangeMax) {
                    loc2.setX(xRangeMax);
                    swap = true;
                }
                if (loc2.getZ() < zRangeMin) {
                    loc2.setZ(zRangeMin);
                    swap = true;
                } else if (loc2.getZ() > zRangeMax) {
                    loc2.setZ(zRangeMax);
                    swap = true;
                }
                if (!swap) continue;
                flag = true;
            }
            if (flag) continue;
            Location[] locs = locations;
            int i1 = locations.length;
            for (j = 0; j < i1; ++j) {
                loc1 = locs[j];
                if (world.getHighestBlockYAt(loc1) != 0) continue;
                double x = xRangeMin >= xRangeMax ? xRangeMin : random.nextDouble() * (xRangeMax - xRangeMin) + xRangeMin;
                double z3 = zRangeMin >= zRangeMax ? zRangeMin : random.nextDouble() * (zRangeMax - zRangeMin) + zRangeMin;
                locations[i] = new Location(world, x, 0.0, z3);
                loc1.setX(x);
                loc1.setZ(z3);
                flag = true;
            }
        }
        if (i >= 10000) {
            return -1;
        }
        return i;
    }

    private double spread(World world, List<Player> list, Location[] locations, boolean teams) {
        double distance = 0.0;
        int i = 0;
        HashMap hashmap = Maps.newHashMap();
        for (int j = 0; j < list.size(); ++j) {
            Location location;
            Player player = list.get(j);
            if (teams) {
                Team team = player.getScoreboard().getPlayerTeam(player);
                if (!hashmap.containsKey(team)) {
                    hashmap.put(team, locations[i++]);
                }
                location = (Location)hashmap.get(team);
            } else {
                location = locations[i++];
            }
            player.teleport(new Location(world, Math.floor(location.getX()) + 0.5, world.getHighestBlockYAt((int)location.getX(), (int)location.getZ()), Math.floor(location.getZ()) + 0.5));
            double value = Double.MAX_VALUE;
            for (int k2 = 0; k2 < locations.length; ++k2) {
                if (location == locations[k2]) continue;
                double d = location.distanceSquared(locations[k2]);
                value = Math.min(d, value);
            }
            distance += value;
        }
        return distance /= (double)list.size();
    }

    private int getTeams(List<Player> players) {
        HashSet teams = Sets.newHashSet();
        for (Player player : players) {
            teams.add(player.getScoreboard().getPlayerTeam(player));
        }
        return teams.size();
    }

    private Location[] getSpreadLocations(World world, int size, double xRangeMin, double zRangeMin, double xRangeMax, double zRangeMax) {
        Location[] locations = new Location[size];
        for (int i = 0; i < size; ++i) {
            double x = xRangeMin >= xRangeMax ? xRangeMin : random.nextDouble() * (xRangeMax - xRangeMin) + xRangeMin;
            double z2 = zRangeMin >= zRangeMax ? zRangeMin : random.nextDouble() * (zRangeMax - zRangeMin) + zRangeMin;
            locations[i] = new Location(world, x, 0.0, z2);
        }
        return locations;
    }
}

