/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.CauldronHooks;
import net.minecraftforge.cauldron.CauldronUtils;
import net.minecraftforge.cauldron.configuration.CauldronConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Level;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.ChunkGenerator;

public class DimensionManager {
    private static Hashtable<Integer, Class<? extends apa>> providers = new Hashtable();
    private static Hashtable<Integer, Boolean> spawnSettings = new Hashtable();
    private static Hashtable<Integer, mj> worlds = new Hashtable();
    private static boolean hasInit = false;
    private static Hashtable<Integer, Integer> dimensions = new Hashtable();
    private static ArrayList<Integer> unloadQueue = new ArrayList();
    private static BitSet dimensionMap = new BitSet(1024);
    private static ConcurrentMap<afn, afn> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static Multiset<Integer> leakedWorlds = HashMultiset.create();
    private static Hashtable<Class<? extends apa>, Integer> classToProviders = new Hashtable();
    private static ArrayList<Integer> bukkitDims = new ArrayList();
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static boolean registerProviderType(int id, Class<? extends apa> provider, boolean keepLoaded) {
        if (providers.containsKey(id)) {
            return false;
        }
        String worldType = "unknown";
        if (id != -1 && id != 0 && id != 1) {
            worldType = provider.getSimpleName().toLowerCase();
            worldType = worldType.replace("worldprovider", "");
            worldType = worldType.replace("provider", "");
            DimensionManager.registerBukkitEnvironment(id, worldType);
        } else {
            worldType = World.Environment.getEnvironment(id).name().toLowerCase();
        }
        CauldronConfig.init();
        keepLoaded = CauldronConfig.getBoolean("world-environment-settings." + worldType + ".keep-world-loaded", keepLoaded);
        CauldronConfig.save();
        providers.put(id, provider);
        classToProviders.put(provider, id);
        spawnSettings.put(id, keepLoaded);
        return true;
    }

    public static int[] unregisterProviderType(int id) {
        if (!providers.containsKey(id)) {
            return new int[0];
        }
        providers.remove(id);
        spawnSettings.remove(id);
        int[] ret = new int[dimensions.size()];
        int x = 0;
        for (Map.Entry<Integer, Integer> ent : dimensions.entrySet()) {
            if (ent.getValue() != id) continue;
            ret[x++] = ent.getKey();
        }
        return Arrays.copyOf(ret, x);
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerProviderType(0, apc.class, true);
        DimensionManager.registerProviderType(-1, apb.class, true);
        DimensionManager.registerProviderType(1, apd.class, false);
        DimensionManager.registerDimension(0, 0);
        DimensionManager.registerDimension(-1, -1);
        DimensionManager.registerDimension(1, 1);
    }

    public static void registerDimension(int id, int providerType) {
        if (!providers.containsKey(providerType)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, provider type %d does not exist", id, providerType));
        }
        if (dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id));
        }
        dimensions.put(id, providerType);
        if (id >= 0) {
            dimensionMap.set(id);
        }
    }

    public static void unregisterDimension(int id) {
        if (!dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id));
        }
        dimensions.remove(id);
    }

    public static boolean isDimensionRegistered(int dim) {
        return dimensions.containsKey(dim);
    }

    public static int getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return dimensions.get(dim);
    }

    public static apa getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).t;
    }

    public static Integer[] getIDs(boolean check) {
        if (CauldronConfig.worldLeakDebug.getValue().booleanValue() && check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll(worlds.values());
            ListIterator li2 = allWorlds.listIterator();
            while (li2.hasNext()) {
                afn w2 = (afn)li2.next();
                leakedWorlds.add((Object)System.identityHashCode(w2));
            }
            for (afn w2 : allWorlds) {
                int leakCount = leakedWorlds.count((Object)System.identityHashCode(w2));
                if (leakCount == 5) {
                    FMLLog.fine("The world %x (%s) may have leaked: first encounter (5 occurences). Note: This may be a caused by a mod, plugin, or just a false-positive(No memory leak). If server crashes due to OOM, report to Cauldron.\n", System.identityHashCode(w2), w2.M().k());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                FMLLog.fine("The world %x (%s) may have leaked: seen %d times. Note: This may be a caused by a mod, plugin, or just a false-positive(No memory leak). If server crashes due to OOM, report to Cauldron.\n", System.identityHashCode(w2), w2.M().k(), leakCount);
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return worlds.keySet().toArray(new Integer[worlds.size()]);
    }

    public static void setWorld(int id, mj world) {
        if (world != null) {
            worlds.put(id, world);
            if (CauldronConfig.worldLeakDebug.getValue().booleanValue()) {
                weakWorldMap.put((afn)world, (afn)world);
            }
            if (!MinecraftServer.G().worlds.contains(world)) {
                MinecraftServer.G().worlds.add(world);
            }
            MinecraftServer.G().worldTickTimes.put(id, new long[100]);
            FMLLog.info("Loading dimension %d (%s) (%s)", id, world.M().k(), world.p());
        } else {
            MinecraftServer.G().worlds.remove(DimensionManager.getWorld(id));
            worlds.remove(id);
            MinecraftServer.G().worldTickTimes.remove(id);
            FMLLog.info("Unloading dimension %d", id);
        }
        ArrayList<mj> tmp = new ArrayList<mj>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Map.Entry<Integer, mj> entry : worlds.entrySet()) {
            int dim = entry.getKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        MinecraftServer.G().b = tmp.toArray(new mj[tmp.size()]);
    }

    public static void initDimension(int dim) {
        String name;
        String worldType;
        if (dim == 0) {
            return;
        }
        mj overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            if (CauldronHooks.craftWorldLoading) {
                return;
            }
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e) {
            System.err.println("Cannot Hotload Dim: " + e.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.p();
        axo savehandler = overworld.L();
        afv worldSettings = new afv(overworld.M());
        String oldName = "";
        World.Environment env = World.Environment.getEnvironment(DimensionManager.getProviderType(dim));
        if (dim >= -1 && dim <= 1) {
            if (dim == -1 && !mcServer.v() || dim == 1 && !mcServer.server.getAllowEnd()) {
                return;
            }
            worldType = env.toString().toLowerCase();
            name = "DIM" + dim;
        } else {
            apa provider = apa.a((int)dim);
            worldType = provider.getClass().getSimpleName().toLowerCase();
            worldType = worldType.replace("worldprovider", "");
            oldName = "world_" + worldType;
            worldType = worldType.replace("provider", "");
            if (World.Environment.getEnvironment(DimensionManager.getProviderType(dim)) == null) {
                env = DimensionManager.registerBukkitEnvironment(DimensionManager.getProviderType(provider.getClass()), worldType);
            }
            if ((name = provider.getSaveFolder()) == null) {
                name = "DIM0";
            }
        }
        boolean enabled = CauldronConfig.getBoolean("world-environment-settings." + worldType + ".enabled", true);
        CauldronConfig.save();
        if (!enabled) {
            return;
        }
        CauldronUtils.migrateWorlds(worldType, oldName, overworld.M().k(), name);
        ChunkGenerator gen = mcServer.server.getGenerator(name);
        if (mcServer instanceof lj) {
            worldSettings.a(((lj)mcServer).a("generator-settings", ""));
        }
        mc world = new mc(mcServer, (axo)new awy(mcServer.server.getWorldContainer(), name, true), name, dim, worldSettings, overworld, mcServer.a, env, gen);
        if (gen != null) {
            world.getWorld().getPopulators().addAll(gen.getDefaultPopulators(world.getWorld()));
        }
        mcServer.af().a(mcServer.worlds.toArray(new mj[mcServer.worlds.size()]));
        world.a((aft)new mf(mcServer, (mj)world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load((afn)world));
        mcServer.server.getPluginManager().callEvent(new WorldLoadEvent(world.getWorld()));
        if (!mcServer.L()) {
            world.M().a(mcServer.i());
        }
        mcServer.a(mcServer.j());
    }

    public static mj initDimension(WorldCreator creator, afv worldSettings) {
        int savedDim;
        mj overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        MinecraftServer mcServer = overworld.p();
        int providerId = 0;
        if (creator.environment() != null) {
            providerId = creator.environment().getId();
        }
        try {
            providerId = DimensionManager.getProviderType(providerId);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        World.Environment env = creator.environment();
        String worldType = env.name().toLowerCase();
        String name = creator.name();
        int dim = 0;
        awy saveHandler = new awy(mcServer.server.getWorldContainer(), name, true);
        if (saveHandler.d() != null && (savedDim = saveHandler.d().getDimension()) != 0 && savedDim != -1 && savedDim != 1) {
            dim = savedDim;
        }
        if (dim == 0) {
            dim = DimensionManager.getNextFreeDimId();
        }
        DimensionManager.registerDimension(dim, providerId);
        DimensionManager.addBukkitDimension(dim);
        ChunkGenerator gen = creator.generator();
        if (mcServer instanceof lj) {
            worldSettings.a(((lj)mcServer).a("generator-settings", ""));
        }
        mc world = new mc(mcServer, (axo)saveHandler, name, dim, worldSettings, overworld, mcServer.a, env, gen);
        if (gen != null) {
            world.getWorld().getPopulators().addAll(gen.getDefaultPopulators(world.getWorld()));
        }
        world.t.i = dim;
        mcServer.af().a(mcServer.worlds.toArray(new mj[mcServer.worlds.size()]));
        world.a((aft)new mf(mcServer, (mj)world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load((afn)world));
        if (!mcServer.L()) {
            world.M().a(mcServer.i());
        }
        mcServer.a(mcServer.j());
        return world;
    }

    public static mj getWorld(int id) {
        return worlds.get(id);
    }

    public static mj[] getWorlds() {
        return worlds.values().toArray(new mj[worlds.size()]);
    }

    public static boolean shouldLoadSpawn(int dim) {
        int id = DimensionManager.getProviderType(dim);
        return spawnSettings.containsKey(id) && spawnSettings.get(id) != false || DimensionManager.getWorld(dim) != null && DimensionManager.getWorld((int)dim).keepSpawnInMemory;
    }

    public static Integer[] getStaticDimensionIDs() {
        return dimensions.keySet().toArray(new Integer[dimensions.keySet().size()]);
    }

    public static apa createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                apa provider = providers.get(DimensionManager.getProviderType(dim)).newInstance();
                provider.setDimension(dim);
                return provider;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.ERROR, String.format("An error occured trying to create an instance of WorldProvider %d (%s)", dim, providers.get(DimensionManager.getProviderType(dim)).getSimpleName()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void unloadWorld(int id) {
        if (!DimensionManager.shouldLoadSpawn(id)) {
            unloadQueue.add(id);
        }
    }

    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        for (int id : unloadQueue) {
            mj w2 = worlds.get(id);
            if (w2 == null) continue;
            MinecraftServer.G().server.unloadWorld(w2.getWorld(), true);
        }
        unloadQueue.clear();
    }

    public static int getNextFreeDimId() {
        int next = 0;
        while (dimensions.containsKey(next = dimensionMap.nextClearBit(next))) {
            dimensionMap.set(next);
        }
        return next;
    }

    public static dg saveDimensionDataMap() {
        int[] data = new int[(dimensionMap.length() + 32 - 1) / 32];
        dg dimMap = new dg();
        for (int i = 0; i < data.length; ++i) {
            int val = 0;
            for (int j = 0; j < 32; ++j) {
                val |= dimensionMap.get(i * 32 + j) ? 1 << j : 0;
            }
            data[i] = val;
        }
        dimMap.a("DimensionArray", data);
        return dimMap;
    }

    public static void loadDimensionDataMap(dg compoundTag) {
        dimensionMap.clear();
        if (compoundTag == null) {
            for (Integer id : dimensions.keySet()) {
                if (id < 0) continue;
                dimensionMap.set(id);
            }
        } else {
            int[] intArray = compoundTag.l("DimensionArray");
            for (int i = 0; i < intArray.length; ++i) {
                for (int j = 0; j < 32; ++j) {
                    dimensionMap.set(i * 32 + j, (intArray[i] & 1 << j) != 0);
                }
            }
        }
    }

    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return ((axc)DimensionManager.getWorld(0).L()).b();
        }
        if (MinecraftServer.G() != null) {
            MinecraftServer srv = MinecraftServer.G();
            axc saveHandler = (axc)srv.Q().a(srv.M(), false);
            return saveHandler.b();
        }
        return null;
    }

    public static World.Environment registerBukkitEnvironment(int dim, String providerName) {
        World.Environment env = World.Environment.getEnvironment(dim);
        if (env == null) {
            providerName = providerName.replace("WorldProvider", "");
            env = EnumHelper.addBukkitEnvironment(dim, providerName.toUpperCase());
            World.Environment.registerEnvironment(env);
        }
        return env;
    }

    public static int getProviderType(Class<? extends apa> provider) {
        return classToProviders.get(provider);
    }

    public static void addBukkitDimension(int dim) {
        if (!bukkitDims.contains(dim)) {
            bukkitDims.add(dim);
        }
    }

    public static void removeBukkitDimension(int dim) {
        if (bukkitDims.contains(dim)) {
            bukkitDims.remove(bukkitDims.indexOf(dim));
        }
    }

    public static ArrayList<Integer> getBukkitDimensionIDs() {
        return bukkitDims;
    }

    public static boolean isBukkitDimension(int dim) {
        return bukkitDims.contains(dim);
    }

    static {
        DimensionManager.init();
    }
}

