/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.MethodAttributes;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.PropertyAttributes;
import ch.epfl.lamp.compiler.msil.Type;

public class PropertyInfo
extends MemberInfo {
    public final short Attributes;
    public final boolean CanRead;
    public final boolean CanWrite;
    public final Type PropertyType;
    protected static final PropertyInfo[] EMPTY_ARRAY = new PropertyInfo[0];
    protected MethodInfo getter;
    protected MethodInfo setter;

    @Override
    public final int MemberType() {
        return 16;
    }

    public MethodInfo[] GetAccessors() {
        return this.GetAccessors(false);
    }

    public MethodInfo[] GetAccessors(boolean nonPublic) {
        MethodInfo getter = this.GetGetMethod(nonPublic);
        MethodInfo setter = this.GetSetMethod(nonPublic);
        if (getter == null) {
            if (setter == null) {
                return MethodInfo.EMPTY_ARRAY;
            }
            return new MethodInfo[]{setter};
        }
        if (setter == null) {
            return new MethodInfo[]{getter};
        }
        return new MethodInfo[]{getter, setter};
    }

    public MethodInfo GetGetMethod() {
        return this.GetGetMethod(false);
    }

    public MethodInfo GetGetMethod(boolean nonPublic) {
        return nonPublic ? this.getter : (this.getter == null || this.getter.IsPublic() ? this.getter : null);
    }

    public MethodInfo GetSetMethod() {
        return this.GetSetMethod(false);
    }

    public MethodInfo GetSetMethod(boolean nonPublic) {
        return nonPublic ? this.setter : (this.setter == null || this.setter.IsPublic() ? this.setter : null);
    }

    public String toString() {
        MethodInfo m = this.getter != null ? this.getter : this.setter;
        return MethodAttributes.accessFlagsToString((this.getter != null ? this.getter : this.setter).Attributes) + " " + PropertyAttributes.toString(this.Attributes) + this.DeclaringType + "::" + this.Name;
    }

    protected PropertyInfo(String name, Type declType, short attr, Type propType, MethodInfo getter, MethodInfo setter) {
        super(name, declType);
        this.Attributes = attr;
        this.PropertyType = propType;
        this.getter = getter;
        this.setter = setter;
        this.CanRead = getter != null;
        this.CanWrite = setter != null;
    }
}

